<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Barryvdh\DomPDF\Facade\Pdf;
use App\Models\Document;
use App\Models\User;

// Final submitted form models
use App\Models\Form1MdaatData;
use App\Models\Form2Mmt8Data;
use App\Models\Form3CdasiData;
use App\Models\Form4CdasiDamageData;
use App\Models\Form5Data;
use App\Models\Form6PgdaData;
use App\Models\Form7MdaatFollowupData;
use App\Models\Form8FollowupMmt8Data;
use App\Models\Form9CdasiActivityData;
use App\Models\Form10CdasiDamageData;
use App\Models\Form11Data;
use App\Models\Form12PgdaData;

class FormSubmissionController extends Controller
{
   
public function index()
{
    $formCases = Form1MdaatData::with('user')->latest()->get();

    return view('admin.submissions.index', compact('formCases'));
}

    public function show($id)
    {
        $submission = Form1MdaatData::with('user')->findOrFail($id);
        return view('admin.submissions.show', compact('submission'));
    }

    

    public function downloadUserPdf($caseId, $userId)
    {
        $document = Document::with('uploader')->where('case_no', $caseId)->firstOrFail();
    
        // Load each form's submission by user + case
        $form1 = Form1MdaatData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form2 = Form2Mmt8Data::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form3 = Form3CdasiData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form4 = Form4CdasiDamageData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form5 = Form5Data::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form6 = Form6PgdaData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form7 = Form7MdaatFollowupData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form8 = Form8FollowupMmt8Data::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form9 = Form9CdasiActivityData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form10 = Form10CdasiDamageData::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form11 = Form11Data::where('case_id', $caseId)->where('user_id', $userId)->first();
        $form12 = Form12PgdaData::where('case_id', $caseId)->where('user_id', $userId)->first();
    
        $submittedBy = $form1?->user->username ?? $form1?->user->name ?? $document->uploader->name ?? 'N/A';
    
        $data = [
            'document' => $document,
            'case_no' => $document->case_no,
            'submittedBy' => $submittedBy,
            'user_id' => $userId,
            'currentDate' => now()->format('m/d/Y'),
    
            // Pass all user-specific form data
            'form1' => $form1,
            'form2' => $form2,
            'form3' => $form3,
            'form4' => $form4,
            'form5' => $form5,
            'form6' => $form6,
            'form7' => $form7,
            'form8' => $form8,
            'form9' => $form9,
            'form10' => $form10,
            'form11' => $form11,
            'form12' => $form12,
        ];
    
        $pdf = PDF::loadView('admin.submissions.pdf', $data)
                  ->setPaper('A4', 'portrait')
                  ->setOption('isHtml5ParserEnabled', true)
                  ->setOption('isRemoteEnabled', true);
    
        $submittedDate = $form1?->created_at?->timezone('America/New_York')->format('m-d-Y') ?? now()->format('m-d-Y');
        $filename = "{$submittedBy} - {$submittedDate} - Case {$caseId}.pdf";
        return $pdf->download($filename);

    }
    
    
    
}