<?php

 
namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Document;
use App\Models\User;

// Final submitted form models
use App\Models\Form1MdaatData;
use App\Models\Form2Mmt8Data;
use App\Models\Form3CdasiData;
use App\Models\Form4CdasiDamageData;
use App\Models\Form5Data;
use App\Models\Form6PgdaData;
use App\Models\Form7MdaatFollowupData;
use App\Models\Form8FollowupMmt8Data;
use App\Models\Form9CdasiActivityData;
use App\Models\Form10CdasiDamageData;
use App\Models\Form11Data;
use App\Models\Form12PgdaData;

class ViewSubmissionController extends Controller
{
    public function show($case_id, $user_id)
    {
        // Fetch the user
        $user = User::findOrFail($user_id);

        // Fetch the associated document
        $document = Document::whereHas('users', function ($q) use ($user_id) {
            $q->where('user_id', $user_id);
        })->where('case_no', $case_id)->first();

        if (!$document) {
            return abort(404, 'Document not found.');
        }

        // Fetch the file content if it's a DOCX file
        $filePath = storage_path("app/public/{$document->file_path}");
        if (!file_exists($filePath)) {
            return abort(404, 'File not found.');
        }

        $extension = pathinfo($filePath, PATHINFO_EXTENSION);
        $htmlContent = null;

        if ($extension === 'docx') {
            $phpWord = \PhpOffice\PhpWord\IOFactory::load($filePath);
            $htmlWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'HTML');
            ob_start();
            $htmlWriter->save('php://output');
            $htmlContent = ob_get_clean();
        }

        // Manually fetch data for each form (instead of using a loop)
        $form1Data = Form1MdaatData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form2Data = Form2Mmt8Data::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form3Data = Form3CdasiData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form4Data = Form4CdasiDamageData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form5Data = Form5Data::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();
 

        $form6Data = Form6PgdaData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();
             
 
        $form7Data = Form7MdaatFollowupData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form8Data = Form8FollowupMmt8Data::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();
            

        $form9Data = Form9CdasiActivityData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form10Data = Form10CdasiDamageData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form11Data = Form11Data::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        $form12Data = Form12PgdaData::where('case_id', $case_id)
            ->where('user_id', $user_id)
            ->latest()
            ->first();

        // Decoding the form data
        $savedScores = [
            'form1Mdaat' => json_decode($form1Data->form_data ?? '{}', true),
            'form2mmt8' => json_decode($form2Data->form_data ?? '{}', true),
            'form3CDASI' => json_decode($form3Data->form_data ?? '{}', true),
            'form4CdasiDamage' => json_decode($form4Data->form_data ?? '{}', true),
            'form5' => json_decode($form5Data->form_data ?? '{}', true),
            'form6Pgda' => json_decode($form6Data->form_data ?? '{}', true),
            'form7MdaatFollowUp' => json_decode($form7Data->form_data ?? '{}', true),
            'form8FollowupMmt8' => json_decode($form8Data->form_data ?? '{}', true),
            'form9CdasiActivity' => json_decode($form9Data->form_data ?? '{}', true),
            'form10CdasiDamage' => json_decode($form10Data->form_data ?? '{}', true),
            'form11' => json_decode($form11Data->form_data ?? '{}', true),
            'form12Pgda' => json_decode($form12Data->form_data ?? '{}', true),
        ];

        

        // Return the view with the saved data
        return view('admin.submissions.show', [
            'document' => $document,
            'case_no' => $case_id,
            'htmlContent' => $htmlContent,
            'savedScores' => $savedScores,
            'user' => $user
        ]);
    }


    
    
}
