<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Document;
use App\Models\User;


class AdminController extends Controller
{
    
    
    public function dashboard()
{
    $documents = Document::orderBy('created_at', 'desc')->paginate(10); // Paginated
    $users = User::where('role', 'user')->get();
    
    // Fetch assigned cases with pagination
    $assignedCases = Document::whereHas('users')
        ->with('users')
        ->orderBy('created_at', 'desc')
        ->paginate(10);

    return view('admin.dashboard', compact('documents', 'users', 'assignedCases'));
}

    

    public function assignedCases()
{
    $assignedCases = CaseAssignment::with('user')->orderBy('assigned_at', 'desc')->get();
    return view('admin.assigned_cases', compact('assignedCases'));
}

}
