<?php

namespace App\Http\Controllers\Doctor;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Form1Mdaat;

class Form1MdaatController extends Controller
{
    public function save(Request $request)
    {
        $validated = $request->validate([
            'case_id' => 'required|exists:case_details,id',
            'scores' => 'required|array',
            'input_types' => 'required|array'
        ]);

        $form = Form1Mdaat::updateOrCreate(
            ['case_id' => $validated['case_id']],
            [
                'scores' => json_encode($validated['scores']),
                'input_types' => json_encode($validated['input_types']),
                'status' => 'draft'
            ]
        );

        return back()->with('success', 'MDAAT Form saved successfully!');
    }
}
