<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\FormDraft;
use Auth;
use Illuminate\Support\Facades\Mail;
use App\Mail\FinalFormSubmitted;

class FormDraftController extends Controller
{
      
    public function save(Request $request)
    {
        try {
            \Log::info("💾 Save Called", $request->all());
    
            $userId = auth()->id();
            $formId = $request->input('form_id');
            $case_no = $request->input('case_id'); // ✅ fixed
    
            \Log::info("Form: $formId, Case No: $case_no");
    
            $case = \App\Models\CaseDetail::firstOrCreate(['case_no' => $case_no], ['submitted_at' => null]);
            $caseId = $case->id;
    
            $formDataRaw = $request->input('form_data');
            if (!is_array($formDataRaw)) {
                \Log::error("❌ Invalid form_data format: Not an array", ['data' => $formDataRaw]);
                return response()->json(['message' => 'Invalid form data format'], 400);
            }
    
            // Parse the serialized array
            $serializedStr = '';
            foreach ($formDataRaw as $item) {
                $serializedStr .= urlencode($item['name']) . '=' . urlencode($item['value']) . '&';
            }
            parse_str(rtrim($serializedStr, '&'), $formData);
    
            \Log::info("Parsed Data: ", $formData);
    
            $finalData = ['scores' => $formData['scores'] ?? []];
    
            FormDraft::updateOrCreate(
                ['user_id' => $userId, 'form_id' => $formId, 'case_id' => $caseId],
                ['form_data' => json_encode($finalData), 'status' => 'draft']
            );
    
            return response()->json(['message' => 'Form saved successfully.']);
        } catch (\Exception $e) {
            \Log::error("🔥 Exception in Save: " . $e->getMessage(), ['trace' => $e->getTraceAsString()]);
            return response()->json(['message' => 'Internal server error.'], 500);
        }
    }
    
    
    
    

    public function submitAll(Request $request)
    {
        $userId = Auth::id();
        $case_no = $request->input('case_id');
    
        $case = \App\Models\CaseDetail::firstOrCreate(['case_no' => $case_no], ['submitted_at' => null]);
        $caseId = $case->id;
    
        $formIds = [
            'form1mdaat', 'form2mmt8', 'form3cdasi', 'form4cdasidamange',
            'form5', 'form6pgda', 'form7mdaatfollowup', 'form8followupmmt8',
            'form9cdasiactivity', 'form10cdasidamage', 'form11', 'form12pgda'
        ];
    
        $submittedForms = FormDraft::where('user_id', $userId)
            ->where('case_id', $caseId)
            ->where('status', 'submitted')
            ->pluck('form_id')
            ->map('strtolower')
            ->toArray();
    
        // Update drafts
        FormDraft::where('user_id', $userId)
            ->where('case_id', $caseId)
            ->where('status', 'draft')
            ->update(['status' => 'submitted']);
    
        // Create missing
        foreach ($formIds as $formId) {
            if (!in_array($formId, $submittedForms)) {
                FormDraft::updateOrCreate(
                    ['user_id' => $userId, 'form_id' => $formId, 'case_id' => $caseId],
                    ['form_data' => json_encode(['scores' => []]), 'status' => 'submitted']
                );
            }
        }
    
        \App\Models\CaseDetail::where('id', $caseId)->update(['submitted_at' => now()]);
    
        return response()->json(['message' => 'All forms submitted.']);
    }
    


}
 