<?php

namespace App\Http\Controllers\User;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use App\Models\FormDraft;

// Import final data models
use App\Models\Form1MdaatData;
use App\Models\Form2Mmt8Data;
use App\Models\Form3CdasiData;
use App\Models\Form4CdasiDamageData;
use App\Models\Form5Data;
use App\Models\Form6PgdaData;
use App\Models\Form7MdaatFollowupData;
use App\Models\Form8FollowupMmt8Data;
use App\Models\Form9CdasiActivityData;
use App\Models\Form10CdasiDamageData;
use App\Models\Form11Data;
use App\Models\Form12PgdaData;

class FormSubmissionController extends Controller
{
    public function submitAllForms(Request $request)
    {
        $userId = auth()->id();
        $caseId = $request->input('case_id');

        // Map form_id to their final data model
        $formMap = [
            'form1Mdaat' => Form1MdaatData::class,
            'form2mmt8' => Form2Mmt8Data::class,
            'form3CDASI' => Form3CdasiData::class,
            'form4CDASIDamange' => Form4CdasiDamageData::class,
            'form5' => Form5Data::class,
            'form6PGDA' => Form6PgdaData::class,
            'form7MdaatFollowUp' => Form7MdaatFollowupData::class,
            'form8FollowUpMMT8' => Form8FollowupMmt8Data::class,
            'form9CDASIActivity' => Form9CdasiActivityData::class,
            'form10CDASIDamage' => Form10CdasiDamageData::class,
            'form11' => Form11Data::class,
            'form12PGDA' => Form12PgdaData::class,
        ];

        DB::beginTransaction();

        try {
            foreach ($formMap as $formId => $modelClass) {
                // ❌ Already submitted? Block submission
                if ($modelClass::where('user_id', $userId)->where('case_id', $caseId)->exists()) {
                    return response()->json([
                        'message' => "❌ [$formId] already submitted for this case."
                    ], 400);
                }

                // 📝 Fetch draft
                $draft = FormDraft::where('user_id', $userId)
                    ->where('case_id', $caseId)
                    ->where('form_id', $formId)
                    ->where('status', 'draft')
                    ->first();

                // ❌ If draft missing
                if (!$draft) {
                    return response()->json([
                        'message' => "❌ Draft not found for [$formId]. Please save first."
                    ], 400);
                }

                // ❌ If draft is empty or null
                if (empty($draft->form_data) || $draft->form_data == '[]') {
                    return response()->json([
                        'message' => "❌ [$formId] has no data. Please complete it."
                    ], 400);
                }

                // ✅ Save into final table
                $modelClass::create([
                    'user_id' => $userId,
                    'case_id' => $caseId,
                    'form_data' => $draft->form_data,
                    'submitted_at' => now(),
                ]);

                // ✅ Mark draft as submitted
                $draft->update(['status' => 'submitted']);
            }

            DB::commit();

            return response()->json([
                'message' => '✅ All forms submitted successfully.'
            ]);
        } catch (\Exception $e) {
            DB::rollBack();
            return response()->json([
                'message' => '❌ Submission failed: ' . $e->getMessage()
            ], 500);
        }
    }
}
