<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Document;
use App\Models\User;
use Illuminate\Support\Facades\Storage;
use Symfony\Component\HttpFoundation\StreamedResponse;
use Illuminate\Support\Facades\Response;
 use PhpOffice\PhpWord\IOFactory as WordIOFactory;
use PhpOffice\PhpSpreadsheet\IOFactory as ExcelIOFactory;
use Barryvdh\DomPDF\Facade\Pdf;
use ZipArchive;
use App\Models\CaseDetail;
use App\Models\Form1Mdaat;
use App\Models\FormDraft;
use PhpOffice\PhpWord\IOFactory;
use Dompdf\Dompdf;
use Dompdf\Options;
use Illuminate\Support\Str;



 

class UserController extends Controller
{
 
    public function profile()
{
    return view('doctors.profile');
}


public function dashboard()
{
    $user = auth()->user();

    $assignedCases = Document::whereHas('users', function ($query) use ($user) {
        $query->where('users.id', $user->id);
    })->orderBy('created_at', 'desc')->get();

    // Submitted
    $submittedCaseIds = FormDraft::where('user_id', $user->id)
        ->where('status', 'submitted')
        ->pluck('case_id')
        ->toArray();

    // Drafts
    $draftCaseIds = FormDraft::where('user_id', $user->id)
        ->where('status', 'draft')
        ->pluck('case_id')
        ->toArray();

    $totalCases = $assignedCases->count();
    $completedCases = $assignedCases->whereIn('case_no', $submittedCaseIds)->count();
    $pendingCases = $totalCases - $completedCases;

    return view('doctors.dashboard', compact(
        'assignedCases', 'totalCases', 'completedCases', 'pendingCases',
        'submittedCaseIds', 'draftCaseIds'
    ));
}


    public function show(){
        $users = User::where('role', 'user')->get();
        return view('admin.usershow',compact('users'));
    }


    public function edit($id) {
        $user = User::findOrFail($id);
        return view('admin.useredit', compact('user'));
    }
    
    public function destroy($id) {
        $user = User::findOrFail($id);
        $user->delete();
        return redirect()->route('admin.usershow')->with('success', 'User deleted successfully!');
    }
    

    public function myCases()
{
    $user = auth()->user();

    $documents = $user->documents()
                     ->orderBy('created_at', 'desc')
                     ->paginate(10);

    // Get submitted case IDs
    $submittedCaseIds = FormDraft::where('user_id', $user->id)
        ->where('status', 'submitted')
        ->pluck('case_id')
        ->toArray();

    // Get draft case IDs (saved but not submitted)
    $draftCaseIds = FormDraft::where('user_id', $user->id)
        ->where('status', 'draft')
        ->pluck('case_id')
        ->toArray();

    return view('doctors.my-cases', [
        'documents' => $documents,
        'submittedCaseIds' => $submittedCaseIds,
        'draftCaseIds' => $draftCaseIds,
        'totalCases' => $documents->total(),
        'completedCases' => count($submittedCaseIds),
        'pendingCases' => $documents->total() - count($submittedCaseIds)
    ]);
}


     
 
public function viewDocument($id)
{
    try {
        $document = Document::findOrFail($id);

        if (!auth()->user()->documents->contains($document)) {
            return redirect()->route('user.myCases')->with('error', 'Unauthorized access.');
        }

        $case_no = $document->case_no;

        // Create or get case detail entry (OPTION 1 approach)
        $caseDetail = \App\Models\CaseDetail::firstOrCreate(
            ['case_no' => $case_no],
            ['submitted_at' => null]
        );

        $case_id = $caseDetail->id;
        $isSubmitted = $caseDetail->submitted_at !== null;

        $formIds = [
            'form1mdaat', 'form2mmt8', 'form3cdasi', 'form4cdasidamange',
            'form5', 'form6pgda', 'form7mdaatfollowup', 'form8followupmmt8',
            'form9cdasiactivity', 'form10cdasidamage', 'form11', 'form12pgda'
        ];

        // Fallback check for submission
        if (!$isSubmitted) {
            $submittedForms = FormDraft::where('case_id', $case_id)
                ->where('user_id', auth()->id())
                ->where('status', 'submitted')
                ->pluck('form_id')
                ->map('strtolower')
                ->toArray();

            $isSubmitted = empty(array_diff($formIds, $submittedForms));
        }

        $savedScores = [];
        foreach ($formIds as $formId) {
            $formDraft = FormDraft::where('case_id', $case_id)
                ->where('form_id', $formId)
                ->where('user_id', auth()->id())
                ->latest()
                ->first();

            if ($formDraft && $formDraft->form_data) {
                $decoded = json_decode($formDraft->form_data, true);
                $savedScores[$formId] = $decoded;
            }
        }

        $filePath = storage_path("app/public/{$document->file_path}");
        $extension = pathinfo($filePath, PATHINFO_EXTENSION);

        if (!file_exists($filePath)) {
            abort(404, 'File not found');
        }

        if ($extension === 'docx') {
            $phpWord = \PhpOffice\PhpWord\IOFactory::load($filePath);
            $htmlWriter = \PhpOffice\PhpWord\IOFactory::createWriter($phpWord, 'HTML');
            ob_start();
            $htmlWriter->save('php://output');
            $htmlContent = ob_get_clean();

            return view('doctors.view-doc', compact('htmlContent', 'document', 'case_no', 'case_id', 'savedScores', 'isSubmitted'));
        }

        if (in_array($extension, ['xlsx', 'xls'])) {
            $spreadsheet = \PhpOffice\PhpSpreadsheet\IOFactory::load($filePath);
            $data = $spreadsheet->getActiveSheet()->toArray();
            return view('doctors.view-doc', compact('data', 'document', 'case_no', 'case_id', 'savedScores', 'isSubmitted'));
        }

        if ($extension === 'pdf') {
            return view('doctors.view-doc', compact('document', 'case_no', 'case_id', 'savedScores', 'isSubmitted'));
        }

        return response()->download($filePath);
    } catch (\Exception $e) {
        \Log::error("Error in viewDocument: " . $e->getMessage());
        return redirect()->route('user.myCases')->with('error', 'Something went wrong.');
    }
}


     
     

public function downloadDocument(Document $document)
{
    if (!$document) {
        abort(404, 'Document not found');
    }

    if (!auth()->user()->documents->contains($document)) {
        return redirect()->route('user.myCases')->with('error', 'Unauthorized access.');
    }

    $filePath = storage_path("app/public/{$document->file_path}");

    if (!file_exists($filePath)) {
        abort(404, 'File not found');
    }

    $extension = pathinfo($filePath, PATHINFO_EXTENSION);

    // If it's a .docx file, convert to PDF first
    if (strtolower($extension) === 'docx') {
        // Load Word Document
        $phpWord = IOFactory::load($filePath);

        // Save as HTML temporarily
        $tempHtmlPath = storage_path('app/temp_html_' . time() . '.html');
        $htmlWriter = IOFactory::createWriter($phpWord, 'HTML');
        $htmlWriter->save($tempHtmlPath);

        // Load HTML into Dompdf
        $dompdf = new Dompdf();
        $options = new Options();
        $options->set('isHtml5ParserEnabled', true);
        $dompdf->setOptions($options);

        $dompdf->loadHtml(file_get_contents($tempHtmlPath));
        $dompdf->setPaper('A4', 'portrait');
        $dompdf->render();

        // Set filename
        $safeTitle = Str::slug($document->title);
        $pdfFileName = $safeTitle . '.pdf';

        // Output PDF
        return response($dompdf->output(), 200)
            ->header('Content-Type', 'application/pdf')
            ->header('Content-Disposition', "attachment; filename={$pdfFileName}");
    }

    // If not Word file, return original file
    $safeTitle = Str::slug($document->title);
    $downloadFileName = "{$safeTitle}.{$extension}";

    return response()->download($filePath, $downloadFileName);
}




    public function index()
    {
        $users = User::where('role', '!=', 'admin')->orderBy('created_at', 'desc')->paginate(10);
        return view('users.index', compact('users'));
    }

     
    public function toggleStatus($id)
    {
        $user = User::findOrFail($id);
        $user->is_active = !$user->is_active;  
        $user->save();

        return redirect()->route('users.index')->with('success', 'User status updated successfully.');
    }
 


}