<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class CheckUserStatus
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        if (Auth::check() && !Auth::user()->is_active) {
            Auth::logout(); // ✅ Logout the user
            return redirect()->route('login')->withErrors(['email' => 'Your account has been deactivated. Contact admin.']);
        }

        return $next($request);
    }
}
