<?php

namespace App\Mail;

use App\Models\Document;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CaseAssignedMail extends Mailable
{
    use Queueable, SerializesModels;

    public $user;
    public $document;

    public function __construct($user, Document $document)
    {
        $this->user = $user;
        $this->document = $document;
    }

    public function build()
    {
        return $this->subject('You have been assigned a new case')
                    ->view('emails.case_assigned');
    }
}
