<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class FinalFormSubmitted extends Mailable
{
    use Queueable, SerializesModels;

    public $username;
    public $caseNo;

    public function __construct($username, $caseNo)
    {
        $this->username = $username;
        $this->caseNo = $caseNo;
    }

    public function build()
    {
        return $this->subject("📝 New Case Submission by {$this->username}")
                    ->view('emails.final-submission');
    }
}
