<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Document extends Model
{
    use HasFactory;

    protected $fillable = ['title', 'file_path', 'uploaded_by','case_no'];

    public function users()
    {
        return $this->belongsToMany(User::class, 'document_user')
                    ->withPivot('assigned_at')
                    ->withTimestamps();
    }
    
    public function caseDetail()
{
    return $this->hasOne(\App\Models\CaseDetail::class, 'case_no', 'case_no');
}


    

    public function uploader()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }
    
    

    
     // Relationships with all form models
     public function form1MdaatData()
     {
         return $this->hasOne(Form1MdaatData::class, 'case_id');
     }
 
     public function form2Mmt8Data()
     {
         return $this->hasOne(Form2Mmt8Data::class, 'case_id');
     }
 
     public function form3CdasiData()
     {
         return $this->hasOne(Form3CdasiData::class, 'case_id');
     }
 
     public function form4CdasiDamageData()
     {
         return $this->hasOne(Form4CdasiDamageData::class, 'case_id');
     }
     
 
     public function form5Data()
     {
         return $this->hasOne(Form5Data::class, 'case_id');
     }
 
     public function form6PgdaData()
     {
         return $this->hasOne(Form6PgdaData::class, 'case_id');
     }
 
     public function form7MdaatFollowupData()
     {
         return $this->hasOne(Form7MdaatFollowupData::class, 'case_id');
     }
 
     public function form8FollowupMmt8Data()
     {
         return $this->hasOne(Form8FollowupMmt8Data::class, 'case_id');
     }
 
     public function form9CdasiActivityData()
     {
         return $this->hasOne(Form9CdasiActivityData::class, 'case_id');
     }
 
     public function form10CdasiDamageData()
     {
         return $this->hasOne(Form10CdasiDamageData::class, 'case_id');
     }
 
     public function form11Data()
     {
         return $this->hasOne(Form11Data::class, 'case_id');
     }
 
     public function form12PgdaData()
     {
         return $this->hasOne(Form12PgdaData::class, 'case_id');
     }
 
}
