<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FormDraft extends Model
{
    use HasFactory;
    
    protected $fillable = [
        'user_id', 'form_id', 'case_id', 'form_data', 'status'
    ];

    protected $casts = [
        'form_data' => 'array',
    ];
    // FormDraft.php Model

public function user()
{
    return $this->belongsTo(User::class);
}

public function case()
{
    return $this->belongsTo(CaseModel::class, 'case_id');
}

}
