<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('documents', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('case_no')->unique(); 
            $table->string('title'); 
            $table->string('file_path'); 
            $table->unsignedBigInteger('uploaded_by'); 
            $table->timestamps();
            $table->foreign('uploaded_by')
                  ->references('id')->on('users')
                  ->onDelete('cascade')
                  ->onUpdate('cascade');
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('documents');
    }
};
