@extends('layouts.app')

@section('content')<br><br><br>
 <!-- Include the single header for Admin & User -->

<br><br><br>

<div class="container">
    <h2 class="text-center">Assign Cases to Users</h2>
    
    <!-- Search Bar -->
    <div class="row mb-3">
        <div class="col-md-6">
            <input type="text" id="searchInput" class="form-control" placeholder="Search Cases...">
        </div>
    </div>

    <!-- Cases Table -->
    <table class="table table-striped" id="casesTable">
        <thead>
            <tr>
                <th>Title</th>
               <!-- Updated column name -->
                <th>Date</th>
                <th>Time</th>
                <th>Assign</th>
            </tr>
        </thead>
        <tbody>
            @foreach($documents as $document)
                <tr>
                    <td>{{ $document->title }}</td>
                     <!-- Show logged-in admin's name -->
                    <td>{{ $document->created_at->format('Y-m-d') }}</td>
                    <td>{{ $document->created_at->format('H:i:s') }}</td>
                    <td>
                        <a href="{{ route('documents.assignForm', ['document' => $document->id]) }}" class="btn btn-warning btn-sm">
                            Assign
                        </a>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>

    <!-- Pagination -->
    <div class="d-flex justify-content-center">
        {{ $documents->links() }}
    </div>
</div>

<!-- jQuery for Search -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
$(document).ready(function(){
    $("#searchInput").on("keyup", function() {
        var value = $(this).val().toLowerCase();
        $("#casesTable tbody tr").filter(function() {
            $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1);
        });
    });
});
</script>

@endsection
