@extends('layouts.app')

@section('content') 
<br><br><br>

<div class="container">
    <h2 class="text-center">Assigned Cases</h2>
    
    <table class="table table-bordered table-hover">
        <thead class="table-dark text-center">
            <tr>
                <th>#</th>
                <th>Assigned Users</th>
                <th>Case Title</th>
                <th>Assigned Date & Time</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($assignedCases as $key => $case)
                <tr>
                    <td class="text-center">{{ $key + 1 }}</td>

                    <!-- ✅ Display multiple assigned users in one row -->
                    <td class="fw-bold">
                        @if($case->users->isNotEmpty())
                            {{ $case->users->pluck('username')->join(', ') }}
                        @else
                            <span class="text-danger">No Users Assigned</span>
                        @endif
                    </td>

                    <td>{{ $case->title }}</td>

                    <!-- ✅ Show assigned date if available -->
                    <td class="text-center">
                        @if($case->users->isNotEmpty())
                            {{ \Carbon\Carbon::parse($case->users->first()->pivot->assigned_at)->format('d M Y, h:i A') }}
                        @else
                            N/A
                        @endif
                    </td>

                    <!-- ✅ Status -->
                    <td class="text-center">
                        @if($case->users->isNotEmpty())
                            <span class="text-success fw-bold">✅ Assigned</span>
                        @else
                            <span class="text-danger fw-bold">❌ Unassigned</span>
                        @endif
                    </td>
                </tr>
            @endforeach

            @if($assignedCases->isEmpty())
                <tr>
                    <td colspan="5" class="text-center text-muted">No assigned cases found</td>
                </tr>
            @endif
        </tbody>
    </table>
</div>

@endsection
