@extends('layouts.app')

@section('content')
<br><br><br>

<div class="container">
    <h2 class="text-center text-primary">Edit Document</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <form action="{{ route('documents.update', $document->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label class="form-label">Title:</label>
            <input type="text" name="title" class="form-control" value="{{ $document->title }}" required>
        </div>

        <div class="mb-3">
            <label class="form-label">Current File:</label><br>
            <a href="{{ asset('storage/' . $document->file_path) }}" target="_blank" class="btn btn-sm btn-info">
                View Current File
            </a>
        </div>

        <div class="mb-3">
            <label class="form-label">Upload New File (Optional):</label>
            <input type="file" name="file" class="form-control" accept=".doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf">
            <small class="text-muted">Leave this empty if you don't want to change the file.</small>
        </div>

        <button type="submit" class="btn btn-success">Update Document</button>
        <a href="{{ route('documents.list') }}" class="btn btn-secondary">Cancel</a>
    </form>
</div>
@endsection
