@php
    // Retrieve the saved scores for form5
    $formData = $savedScores['form5']['scores'] ?? [];
    $erythema = $formData['erythema'] ?? 'N/A';
    $erythema_final_score = $formData['erythema_final_score'] ?? 'N/A';
    $damage = $formData['damage'] ?? 'N/A';
    $papulePresent = $formData['papule_present'] ?? 'N/A';
    $periunguals = $formData['periunguals'] ?? 'N/A';
    $alopecias = $formData['alopecias'] ?? 'N/A';
    $form5 = $savedScores['form5'] ?? [];
    $scores = $form5['scores'] ?? [];

    $totalActivityScore = $scores['total_activity_score'] ?? 'N/A';
    $totalDamageScore = $scores['total_damage_score'] ?? 'N/A';
@endphp

<!-- Admin Read-Only Version for form5 -->
<form id="form5Readonly" class="scoring-form">
    <br>
    <hr>

    {{-- Gottron’s – Hands --}}
    <div class="table-container">
        <table class="table table-striped table-bordered mediaTable table-1">
            <thead>
                <tr>
                    <th colspan="5" style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px; color: #000;">
                        Gottron’s – Hands
                    </th>
                </tr>
                <tr>
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left; font-size: 16px; color: #000;">
                        Examine the patient’s hands and double score if papules are present
                    </th>
                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;"></th>
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left; font-size: 16px; color: #000;">
                        Examine patient’s hands and score if damage is present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr >
                    <td class="alltext" style="border: 1px solid black; padding: 12px; font-weight: bold; color: #000;">
                        0 - absent <br> 1 - pink; faint erythema <br> 2 - red erythema <br> 3 - dark red
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <input type="text" class="form-control" value="{{ $erythema_final_score }}" readonly>
                    </td>
                    <td style="background-color: #4a4a4a; width: 15px;"></td>
                    <td class="alltext" style="border: 1px solid black; padding: 12px; font-weight: bold; color: #000;">
                        0 - absent <br> 1 - dyspigmentation <br> 2 - scarring
                    </td>
                    <td style="border: 1px solid black; padding: 12px; text-align: center;">
                        <input type="text" class="form-control" value="{{ $damage }}" readonly>
                    </td>
                </tr>

                {{-- Papule Present --}}
                <tr style="text-align: center; background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                    <td class="alltext" style="border: 1px solid black; padding: 12px; text-align: left; font-size: 18px;">
                        Papule Present
                    </td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <input type="text" class="form-control" value="{{ $papulePresent }}" readonly>
                    </td>
                    <td style="background-color: #4a4a4a;" colspan="3"></td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- Periungual --}}
    <br>
    <hr>
    <hr>
    <div class="table-container">
        <table class="table table-striped table-bordered mediaTable table-1">
            <thead>
                <tr>
                    <th colspan="2" style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px;">
                        Periungual
                    </th>
                </tr>
                <tr >
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left; color: #000;">
                        Periungual changes (examine)
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr >
                    <td class="alltext" style="border: 1px solid black; padding: 12px;">
                        0 - absent <br> 1 - pink/red erythema / microscopic telangiectasias<br> 2 - visible telangiectasias
                    </td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <input type="text" class="form-control" value="{{ $periunguals }}" readonly>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

    {{-- Alopecia --}}
    <br>
    <hr>
    <div class="table-container">
        <table class="table table-striped table-bordered mediaTable table-1">
            <thead>
                <tr>
                    <th colspan="3" style="border: 1px solid black; padding: 15px; text-align: center; font-size: 18px;">
                        Alopecia
                    </th>
                </tr>
                <tr >
                    <th colspan="2" style="border: 1px solid black; padding: 12px; text-align: left;">Recent Hair loss (within last 30 days as reported by the patient)</th>
                    <th style="background-color: #4a4a4a; width: 15px;"></th>
                </tr>
            </thead>
            <tbody>
                <tr >
                    <td class="alltext" style="border: 1px solid black; padding: 12px;">0 - absent <br> 1 - present</td>
                    <td style="border: 1px solid black; padding: 12px;">
                        <input type="text" class="form-control" value="{{ $alopecias }}" readonly>
                    </td>
                    <td style="background-color: #4a4a4a;"></td>
                </tr>
            </tbody>
        </table>
    </div>

    <table class="table table-bordered table-striped" style="margin-top: 30px;">
    <thead>
        <tr  >
            <th colspan="2" class="text-center" style="font-size: 20px;">
                🔍 <strong>Overall Score Summary</strong>
            </th>
        </tr>
    </thead>
    <tbody>
        
        <tr>
            <td style="font-weight: bold; background-color: #ecf0f1;">Total Activity Score</td>
            <td class="text-center" style="font-size: 22px; font-weight: bold; background-color: #dff9fb;">
                {{ $totalActivityScore }}
            </td>
        </tr>
        <tr>
            <td colspan="2" style="background-color: #f8f9fa; padding: 12px;">
                Add up the scores: Erythema, Scale, Excoriation, Ulceration, Gottron's, Periungual, Alopecia
            </td>
        </tr>
        <tr>
            <td style="font-weight: bold; background-color: #f2dede; color: #a94442;">Total Damage Score</td>
            <td class="text-center" style="font-size: 22px; font-weight: bold; background-color: #f2dede; color: #a94442;">
                {{ $totalDamageScore }}
            </td>
        </tr>
        <tr>
            <td colspan="2" style="background-color: #f8f9fa; padding: 12px;">
                Add up the scores: Poikiloderma, Calcinosis
            </td>
        </tr>
    </tbody>
</table>


</form>
<!-- Physician Global Disease Activity Readonly End -->
