@php
$formData = $savedScores['form7MdaatFollowUp']['scores'] ?? [];
@endphp

<div class="panel panel-default" id="form7MdaatFollowUp">
    <div class="panel-heading"><strong>Form 7: MDAAT Follow-Up (Readonly)</strong></div>
    <div class="panel-body">
        <div class="table-container">
            <h3>Case Presentation: Follow up
                <br>
                <hr>
                Myositis Disease Activity Assessment Tool (MDAAT)
            </h3>
            <h5 style="font-size:15px;">
                Readonly version of the submitted form
            </h5>
            <table class="table table-striped table-bordered mediaTable table-1">
                <thead>
                    <tr>
                        <th class="optional fixed-id">S/N</th>
                        <th class="essential persist">Disease Activity</th>
                        <th class="optional" style="width: 150px;">Overall Organ Disease Activity (0-10 cm) VAS</th>
                        <th class="optional" style="width: 200px;">Clinical Features (0,1,2,3,4, NA: Not Assessed)</th>
                    </tr>
                </thead>
                <tbody>
                    <tr >
                        <td class="fixed-id"></td>
                        <td>Constitutional Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_1_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">1</td>
                        <td>Pyrexia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_1_1_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">2</td>
                        <td>Weight Loss</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_1_2_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">3</td>
                        <td>Fatigue</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_1_3_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Cutaneous Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_2_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">4</td>
                        <td>Cutaneous Ulceration</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_1_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">5</td>
                        <td>Erythroderma</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_2_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">6</td>
                        <td>Panniculitis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_3_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>7</strong></td>
                        <td><strong>Erythematous Rash</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. with secondary changes (e.g. accompanied by erosions, vesiculobullous change or necrosis)</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_4a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. without secondary changes</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_4b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">8</td>
                        <td>Heliotrope rash</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_5_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">9</td>
                        <td>Gottron's papules/sign</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_6_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">10</td>
                        <td>Periungual capillary changes</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_7_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">11</td>
                        <td>Alopecia</td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Diffuse hair loss</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_8a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Focal, patchy with erythema</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_8b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">12</td>
                        <td>Mechanics Hand</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_2_9_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Skeletal Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_3_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">13</td>
                        <td><strong>Arthritis</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe active polyarthritis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_3_1a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Moderately active arthritis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_3_1b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Mild arthritis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_3_1c_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">14</td>
                        <td>Arthralgia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_3_2_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>GI Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_4_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>15</strong></td>
                        <td><strong>Dysphagia</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Moderate/severe dysphagia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_4_1a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Mild dysphagia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_4_1b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>16</strong></td>
                        <td><strong>Abdominal Pain</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_4_2a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Moderate</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_4_2b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Mild</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_4_2c_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Pulmonary Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_5_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id"><strong>17</strong></td>
                        <td><strong>Resp. Muscle weakness without ILD</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Dyspnea at rest</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_1a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Dyspnea on exertion</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_1b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">18</td>
                        <td><strong>Active Reversible ILD</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Dyspnea or cough due to ILD</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_2a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Parenchymal abnormalities on chest x-ray or high-resolution CT scan (HRCT) and/or ground glass shadowing on HRCT</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_2b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Pulmonary Function Tests: ≥ 10% change in FVC OR ≥ 15% change in DLCO</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_2c_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">19</td>
                        <td><strong>Dysphonia</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Moderate to severe</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_3a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Mild</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_5_3b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Cardiovascular Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_6_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">20</td>
                        <td>Pericarditis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_6_1_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">21</td>
                        <td>Myocarditis</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_6_2_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">22</td>
                        <td><strong>Arrhythmias</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe arrhythmia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_6_3a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Other arrhythmia, except sinus tachycardia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_6_3b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">23</td>
                        <td>Sinus Tachycardia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_6_4_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>
                            Other Disease Activity<br>
                            <input type="text" class="form-control form-control-sm w-25" value="{{ $formData['other_disease_specification'] ?? 'N/A' }}" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_7_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_7_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Extra Muscular Global Assessment</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_8_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr >
                        <td class="fixed-id"></td>
                        <td>Muscle Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['disease_activity_9_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>

                    <tr>
                        <td class="fixed-id">24</td>
                        <td><strong>Myositis</strong></td>
                        <td></td>
                        <td></td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">A. Severe muscle inflammation</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_10a_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">B. Moderate muscle inflammation</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_10b_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td></td>
                        <td class="sub-heading">C. Mild muscle inflammation</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_10c_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id">25</td>
                        <td>Myalgia</td>
                        <td></td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['clinical_features_11_followup'] ?? 'N/A' }}" readonly>
                        </td>
                    </tr>

                    <tr>
                        <td class="fixed-id"></td>
                        <td>Global Disease Activity</td>
                        <td>
                            <input type="text" class="form-control" value="{{ $formData['global_disease_activity_followup'] ?? 'N/A' }}" readonly>
                        </td>
                        <td></td>
                    </tr>
                </tbody>
            </table>
        </div>
    </div>
</div>