@extends('layouts.app')

@section('content')  
<br><br><br>
<div class="container">
    <h2>Uploaded Documents</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table">
        <thead>
            <tr>
                <th>Title</th>
                <th>Date</th>
                <th>Time</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($documents as $document)
                <tr>
                    <td>{{ $document->title }}</td>
                    <td>{{ $document->created_at->format('Y-m-d') }}</td>
                    <td>{{ $document->created_at->format('H:i:s') }}</td>
                    <td>
                        <a href="{{ route('documents.assignForm', ['document' => $document->id]) }}" class="btn btn-warning btn-sm">
                            Assign
                        </a>

                        <!-- Delete Button with Confirmation -->
                        <form action="{{ route('documents.destroy', $document->id) }}" method="POST" style="display:inline;" onsubmit="return confirmDelete();">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>

<!-- Delete Confirmation Script -->
<script>
    function confirmDelete() {
        return confirm("⚠️ Are you sure you want to delete this document? This action cannot be undone.");
    }
</script>
@endsection
