@extends('layouts.app')
@section('content') <br><br><br>
<div class="container">
    <h3 class="mb-4"><i class="fa fa-clipboard"></i> Submitted Cases</h3>

    <div class="table-responsive">
        <table class="table table-bordered table-striped">
            <thead>
                <tr>
                    
                    <th>Submitted By</th>
                    <th>Case ID</th>
                    <th>Date</th>
                    <th>Time</th>
                    <th>Actions</th>
                </tr> 
            </thead>
            <tbody>
                @foreach($formCases as $index => $submission)
                    <tr>
                      
                        <td>{{ $submission->user->username ?? $submission->user->name ?? 'N/A' }}</td>
                        <td>{{ $submission->case_id }}</td>
                        <td>{{ \Carbon\Carbon::parse($submission->submitted_at)->format('m/d/Y') }}</td>
                        <td>{{ \Carbon\Carbon::parse($submission->submitted_at)->format('h:i A') }}</td>
                        <td>
                        <a href="{{ route('admin.view.submission', [$submission->case_id, $submission->user_id]) }}" class="btn btn-info btn-sm">View</a>
                        <a href="{{ route('admin.download', [$submission->case_id, $submission->user_id]) }}" class="btn btn-success btn-sm">
    Download PDF
</a>


                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
</div>
@endsection
