@extends('layouts.app')

@section('content') <br><br><br>
<div class="container">
    <h2>Upload Document</h2>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
    @if($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif


    <form action="{{ route('documents.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="mb-3">
            <label>Case No:</label>
            <input type="number" name="case_no"
            min="1"
            value="{{ old('case_no') }}"
            class="form-control form-control-sm"
            required>
     
            </div>

        <div class="mb-3">
            <label>Title:</label>
            <input type="text" name="title"   value="{{ old('title') }}"class="form-control" required>
        </div>

        <div class="mb-3">
            <label>File:</label>
            <input type="file" name="file" class="form-control" accept=".doc,.docx,.xls,.xlsx,.ppt,.pptx,.pdf" required>
        </div>

        <button type="submit" class="btn btn-primary">Upload</button>
    </form>
</div>
<script>
    document.querySelector('input[name="case_no"]').addEventListener('input', function () {
        if (this.value < 1) {
            this.value = '';
        }
    });
    </script>
    
@endsection
