@extends('layouts.app')

@section('content') <br><br><br>

<!-- Custom Styles -->
<style>
    body {
        background-color: #f8f9fa;
        font-family: 'Poppins', sans-serif;
    }

    .container {
        max-width: 1000px;
        margin: auto;
        padding: 20px;
        background: white;
        border-radius: 8px;
        box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
    }

    .header-title {
        text-align: center;
        font-size: 22px;
        font-weight: bold;
        margin-bottom: 20px;
    }

    .table-container {
        overflow-x: auto;
    }

    .table thead th {
        background-color: #1f4e78;
        color: white;
        text-align: center;
        padding: 10px;
    }

    .table td {
        text-align: center;
        vertical-align: middle;
    }

    .btn-action {
        padding: 5px 10px;
        font-size: 14px;
    }

    .btn-edit {
        background-color: #28a745;
        color: white;
        border-radius: 4px;
    }

    .btn-delete {
        background-color: #dc3545;
        color: white;
        border-radius: 4px;
    }
</style>

<div class="container">
    <h2 class="header-title">All Users</h2>

    <div class="table-container">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th style="color:black" >#</th>
                    <th style="color:black" >Name</th>
                    <th style="color:black" >Email</th>
                    <th style="color:black" >Phone</th>
                    <th style="color:black" >Role</th>
                    <th style="color:black" >Actions</th>
                </tr>
            </thead>
            <tbody>
                @foreach($users as $key => $user)
                <tr>
                    <td>{{ $key + 1 }}</td>
                    <td>{{ $user->username }}</td>
                    <td>{{ $user->email }}</td>
                    <td>{{ $user->phone }}</td>
                    <td>{{ ucfirst($user->role) }}</td>
                    <td>
                         <form action="{{ route('admin.user.delete', $user->id) }}" method="POST" style="display:inline;">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="btn btn-sm btn-delete" onclick="return confirm('Are you sure?')">Delete</button>
                        </form>
                    </td>
                </tr>
                @endforeach

                @if($users->isEmpty())
                <tr>
                    <td colspan="6" class="text-center">No users found</td>
                </tr>
                @endif
            </tbody>
        </table>
    </div>
</div>

@endsection
