@extends('layouts.app')

@section('content')
<br><br><br>

<div class="container">
    <div class="panel panel-primary shadow-box">
        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="glyphicon glyphicon-file"></i> Viewing Case File: {{ $document->title }}
            </h3>
        </div>
        <div class="panel-body">

            <!-- ✅ If the document is a Word file, render as HTML -->
            @if(isset($htmlContent))
                <div class="word-content">
                    {!! $htmlContent !!}
                </div>

            <!-- ✅ If the document is an Excel file, render as a table -->
            @elseif(isset($data))
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            @foreach($data[0] as $header)
                                <th>{{ $header }}</th>
                            @endforeach
                        </tr>
                    </thead>
                    <tbody>
                        @foreach(array_slice($data, 1) as $row)
                            <tr>
                                @foreach($row as $cell)
                                    <td>{{ $cell }}</td>
                                @endforeach
                            </tr>
                        @endforeach
                    </tbody>
                </table>

            <!-- ✅ If the document is a PDF, render in iframe -->
            @elseif(pathinfo($document->file_path, PATHINFO_EXTENSION) === 'pdf')
                <iframe src="{{ asset('storage/' . $document->file_path) }}" width="100%" height="600px"></iframe>

            @else
                <p class="text-center text-muted"><i class="glyphicon glyphicon-info-sign"></i> Unable to preview this file.</p>
            @endif

            <!-- ✅ Download Button -->
            <div class="text-center mt-3">
                <a href="{{ asset('storage/' . $document->file_path) }}" class="btn btn-primary" download>
                    <i class="glyphicon glyphicon-download"></i> Download File
                </a>
            </div>

        </div>
    </div>
</div>
@endsection
