<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GuruKool Hub | Case Management</title>

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
    
    <!-- Custom CSS -->
    <style>
        body {
            background: linear-gradient(135deg, #317c81, #a31660);
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            max-width: 400px;
            padding: 30px;
            background: #ffffff;
            box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);
            border-radius: 12px;
            text-align: center;
        }
        .form-control {
            border-radius: 8px;
            border: 1px solid #a31660;
        }
        .btn-primary {
            background: #a31660;
            border: none;
            border-radius: 8px;
        }
        .btn-primary:hover {
            background: #8c124f;
        }
        .error {
            color: red;
            font-size: 14px;
        }
        .logo {
            display: block;
            margin: 0 auto 20px;
            max-width: 120px;
        }
        a {
            color: #317c81;
            font-weight: bold;
        }
        a:hover {
            color: #a31660;
        }
        .input-group-text {
            cursor: pointer;
            background: #fff;
            border: 1px solid #a31660;
            border-radius: 8px;
        }
    </style>
</head>
<body>

<div class="container">
    <img src="{{ asset('logo.png') }}" alt="GuruKool Logo" class="logo">
    <h2 class="mb-4" style="color: #a31660; font-weight: bold;">Login</h2>

    <!-- ✅ Success Message -->
    @if (session('success'))
        <div class="alert alert-success">
            {{ session('success') }}
        </div>
    @endif

    <!-- ✅ Error Messages -->
    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('login') }}" method="POST">
        @csrf

        <!-- Email Input -->
        <div class="mb-3">
            <input type="email" class="form-control" name="email" placeholder="Email" value="{{ old('email') }}" required>
        </div>

        <!-- Password Input with Show/Hide Toggle -->
        <div class="mb-3">
            <div class="input-group">
                <input type="password" class="form-control" name="password" id="passwordInput" placeholder="Password" value="{{ old('password') }}" required>
                <span class="input-group-text" onclick="togglePassword()">
                    <i id="toggleIcon" class="fa fa-eye"></i>
                </span>
            </div>
        </div>

        <button type="submit" class="btn btn-primary w-100">Login</button>

        <div class="text-center mt-3">
            <a href="{{ route('register') }}">Don't have an account? Register</a>
        </div>
        
        <div class="text-center mt-2">
            <a href="{{ route('password.request') }}">Forgot Password?</a>
        </div>

    </form>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- ✅ Show/Hide Password JavaScript -->
<script>
    function togglePassword() {
        var passwordField = document.getElementById("passwordInput");
        var toggleIcon = document.getElementById("toggleIcon");

        if (passwordField.type === "password") {
            passwordField.type = "text";
            toggleIcon.classList.remove("fa-eye");
            toggleIcon.classList.add("fa-eye-slash");
        } else {
            passwordField.type = "password";
            toggleIcon.classList.remove("fa-eye-slash");
            toggleIcon.classList.add("fa-eye");
        }
    }
</script>

</body>
</html>