<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>GuruKool Hub | Reset Password</title>

    <!-- Bootstrap 5 CDN -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <!-- Font Awesome for Icons -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">

    <!-- Custom CSS (Same as Login) -->
    <style>
        body {
            background: linear-gradient(135deg, #317c81, #a31660);
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .container {
            max-width: 400px;
            padding: 30px;
            background: #ffffff;
            box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);
            border-radius: 12px;
            text-align: center;
        }
        .form-control {
            border-radius: 8px;
            border: 1px solid #a31660;
        }
        .btn-primary {
            background: #a31660;
            border: none;
            border-radius: 8px;
        }
        .btn-primary:hover {
            background: #8c124f;
        }
        .error {
            color: red;
            font-size: 14px;
        }
        .logo {
            display: block;
            margin: 0 auto 20px;
            max-width: 120px;
        }
        a {
            color: #317c81;
            font-weight: bold;
        }
        a:hover {
            color: #a31660;
        }
    </style>
</head>
<body>

<div class="container">
    <img src="{{ asset('logo.png') }}" alt="GuruKool Logo" class="logo">
    <h2 class="mb-4" style="color: #a31660; font-weight: bold;">Reset Password</h2>

    @if ($errors->any())
        <div class="alert alert-danger">
            <ul class="mb-0">
                @foreach ($errors->all() as $error)
                    <li>{{ $error }}</li>
                @endforeach
            </ul>
        </div>
    @endif

    <form action="{{ route('password.update') }}" method="POST">
        @csrf
        <input type="hidden" name="token" value="{{ $token }}">

        <!-- Email Input -->
        <div class="mb-3">
            <input type="email" class="form-control" name="email" placeholder="Enter your email" required>
        </div>

        <!-- New Password Input -->
        <div class="mb-3">
            <input type="password" class="form-control" name="password" placeholder="New password" required>
        </div>

        <!-- Confirm Password Input -->
        <div class="mb-3">
            <input type="password" class="form-control" name="password_confirmation" placeholder="Confirm password" required>
        </div>

        <button type="submit" class="btn btn-primary w-100">Reset Password</button>

        <div class="text-center mt-3">
            <a href="{{ route('login') }}">← Back to Login</a>
        </div>
    </form>
</div>

</body>
</html>
