@extends('layouts.app')

@section('content') <br><br><br>
<div class="container mt-4">
    <h2 class="text-center mb-4">User Dashboard</h2>

    <!-- Case Summary -->
    <div class="row text-center">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Cases</h5>
                    <h3>{{ $totalCases }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Completed Cases</h5>
                    <h3>{{ $completedCases }}</h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Pending Cases</h5>
                    <h3>{{ $pendingCases }}</h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Assigned Cases Table -->
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">Assigned Cases</h4>
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead class="table-dark">
                        <tr>
                            
                            <th>Case No.</th>
                            <th>Title</th>
                            <th>Assigned Date</th>
                            <th>Assigned Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse ($assignedCases as $key => $case)
                        <tr>
                          
                            <td>{{ $case->case_no }}</td>
                            <td>{{ $case->title }}</td>
                            <td>{{ $case->created_at->setTimezone('America/Los_Angeles')->format('Y-m-d') }}</td>
                            <td>{{ $case->created_at->setTimezone('America/Los_Angeles')->format('h:i A') }}</td>
                            
                            <td>
                                @if(in_array($case->case_no, $submittedCaseIds))
                                    <button class="btn btn-sm" style="background: linear-gradient(135deg, #00c9a7, #92fe9d); color: #fff; border: none;">
                                        <i class="fas fa-check-circle"></i> Submitted
                                    </button>
                                    <a href="{{ route('user.viewDocument', $case->id) }}" class="btn btn-sm" style="background: linear-gradient(135deg, #2193b0, #6dd5ed); color: #fff; border: none;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                @elseif(in_array($case->case_no, $draftCaseIds))
                                    <a href="{{ route('user.viewDocument', $case->id) }}" class="btn btn-sm" style="background: linear-gradient(135deg, #f7971e, #ffd200); color: #fff; border: none;">
                                        <i class="fas fa-sync-alt"></i> Resume
                                    </a>
                                @else
                                    <a href="{{ route('user.viewDocument', $case->id) }}" class="btn btn-sm" style="background: linear-gradient(135deg, #ff6a00, #ee0979); color: #fff; border: none;">
                                        <i class="fas fa-play"></i> Begin
                                    </a>
                                @endif
                            </td>
                            

                        </tr>
                        @empty
                        <tr>
                            <td colspan="5" class="text-center">No cases assigned.</td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
