<!-- LOTTIE PLAYER SCRIPT (Only once on page) -->
<script src="https://unpkg.com/@lottiefiles/lottie-player@latest/dist/lottie-player.js"></script>

<!-- FOLLOW-UP SECTION -->
<div class="followup-section-compact text-center">
    <h3 class="followup-heading-compact">🚀 FOLLOW-UP SCORING SECTION</h3>
    <p class="followup-subtext-compact">You are now entering the follow-up phase. Please scroll down to begin scoring.</p>

    <!-- 👇 Correct Downward Arrow Animation (No icons, just arrow) -->
    <lottie-player
        src="https://assets2.lottiefiles.com/packages/lf20_puciaact.json"
        background="transparent"
        speed="1"
        style="width: 60px; height: 60px; margin: 10px auto 0;"
        loop autoplay>
    </lottie-player>

    <div class="scroll-down-text">Scroll down to begin ↓</div>
</div>

<!-- CSS -->
<style>
.followup-section-compact {
    background: linear-gradient(to right, #283e51, #485563);
    padding: 25px 15px 30px;
    margin: 50px 0 30px 0;
    border-radius: 10px;
    color: #ffffff;
    box-shadow: 0 5px 20px rgba(0, 0, 0, 0.25);
    animation: fadeInCompact 1s ease-in-out;
}

.followup-heading-compact {
    font-size: 22px;
    font-weight: 600;
    margin-bottom: 10px;
    color: #ffffff;
    text-shadow: 1px 1px 2px rgba(0,0,0,0.4);
    animation: fadeInUp 1s ease;
}

.followup-subtext-compact {
    font-size: 14px;
    font-style: italic;
    color: #f1f1f1;
    animation: fadeInUp 1.2s ease;
    margin-bottom: 10px;
}

.scroll-down-text {
    font-size: 13px;
    color: #cccccc;
    font-style: italic;
    margin-top: 5px;
    animation: fadeInUp 1.4s ease;
}

@keyframes fadeInCompact {
    from {
        opacity: 0;
        transform: translateY(30px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}

@keyframes fadeInUp {
    from {
        opacity: 0;
        transform: translateY(10px);
    }
    to {
        opacity: 1;
        transform: translateY(0);
    }
}
</style>
