@php
use App\Models\FormDraft;

$formData = FormDraft::where('user_id', auth()->id())
->where('form_id', 'form7mdaatfollowup')
->where('case_id', $case_no)

->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded ?? [];
}
@endphp

<form id="form7mdaatfollowup" class="scoring-form" data-form-id="form7mdaatfollowup">
    <div class="table-container1">
        <h3>Case  Presentation: Follow up
            <br>
            <hr>
            Myositis Disease Activity Assessment Tool (MDAAT)
        </h3>
        <h5 style="font-size:15px;">
            Provide answers with the most appropriate responses based on the case review. Answer all questions.
        </h5>
        <table class="table table-striped table-bordered mediaTable table-2">
            <thead>
                <tr>
                    <th class="optional fixed-id"><strong>S/N</strong></th>
                    <th class="essential persist"><strong>Disease Activity</strong></th>
                    <th class="optional" style="width: 150px;"><strong>Overall Organ Disease Activity (0-10 cm) VAS</strong></th>
                    <th class="optional" style="width: 200px;"><strong>Clinical Features (0,1,2,3,4, NA: Not Assessed)</strong></th>
                </tr>
            </thead>
            <tbody>
                <!-- Section 1 - Constitutional -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Constitutional Disease Activity</strong></td> 
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_1_followup'] ?? '' }}"
                                name="scores[disease_activity_1_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_1_followup'] ?? '' }}"
                                name="input_types[disease_activity_1_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">1</td>
                    <td><strong>Pyrexia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_1_1_followup']) && $savedScores['scores']['clinical_features_1_1_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_1_1_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">2</td>
                    <td><strong>Weight Loss</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_1_2_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_1_2_followup']) && $savedScores['scores']['clinical_features_1_2_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_1_2_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">3</td>
                    <td><strong>Fatigue</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_1_3_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_1_3_followup']) && $savedScores['scores']['clinical_features_1_3_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_1_3_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 2 - Cutaneous -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Cutaneous Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_2_followup'] ?? '' }}"
                                name="scores[disease_activity_2_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_2_followup'] ?? '' }}"
                                name="input_types[disease_activity_2_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">4</td>
                    <td><strong>Cutaneous Ulceration</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_1_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_1_followup']) && $savedScores['scores']['clinical_features_2_1_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_1_followup]" value="radio">
                        </div>
                    </td>
                </tr>
                <tr class="section-2-sub">
                    <td class="fixed-id">5</td>
                    <td><strong>Erythroderma</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_2_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_2_followup']) && $savedScores['scores']['clinical_features_2_2_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_2_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">6</td>
                    <td><strong>Panniculitis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_3_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_3_followup']) && $savedScores['scores']['clinical_features_2_3_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_3_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub" style="background-color: #83a8dc !important;">
                    <td>7</td>
                    <td><strong>Erythematous Rash</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. with secondary changes (e.g. accompanied by erosions,
                        vesiculobullous change or necrosis)</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_4a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_4a_followup']) && $savedScores['scores']['clinical_features_2_4a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_4a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. without secondary changes</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_4b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_4b_followup']) && $savedScores['scores']['clinical_features_2_4b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_4b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">8</td>
                    <td><strong>Heliotrope rash</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_5_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_5_followup']) && $savedScores['scores']['clinical_features_2_5_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_5_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">9</td>
                    <td><strong>Gottron's papules/sign</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_6_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_6_followup']) && $savedScores['scores']['clinical_features_2_6_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_6_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">10</td>
                    <td><strong>Periungual capillary changes</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_7_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_7_followup']) && $savedScores['scores']['clinical_features_2_7_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_7_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub" >
                    <td class="fixed-id">11</td>
                    <td><strong>Alopecia</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Diffuse hair loss</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_8a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_8a_followup']) && $savedScores['scores']['clinical_features_2_8a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_8a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Focal, patchy with erythema</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_8b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_8b_followup']) && $savedScores['scores']['clinical_features_2_8b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_8b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">12</td>
                    <td><strong>Mechanics Hand</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_2_9_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_2_9_followup']) && $savedScores['scores']['clinical_features_2_9_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_2_9_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 3 -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Skeletal Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_3_followup'] ?? '' }}"
                                name="scores[disease_activity_3_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_3_followup'] ?? '' }}"
                                name="input_types[disease_activity_3_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">13</td>
                    <td><strong>Arthritis</strong>	</td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe active polyarthritis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_3_1a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_3_1a_followup']) && $savedScores['scores']['clinical_features_3_1a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_3_1a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Moderately active arthritis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_3_1b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_3_1b_followup']) && $savedScores['scores']['clinical_features_3_1b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_3_1b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Mild arthritis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_3_1c_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_3_1c_followup']) && $savedScores['scores']['clinical_features_3_1c_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_3_1c_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">14</td>
                    <td><strong>Arthralgia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_3_2_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_3_2_followup']) && $savedScores['scores']['clinical_features_3_2_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_3_2_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 4 -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>GI Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_4_followup'] ?? '' }}"
                                name="scores[disease_activity_4_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_4_followup'] ?? '' }}"
                                name="input_types[disease_activity_4_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">15</td>
                    <td><strong>Dysphagia</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Moderate/severe dysphagia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_4_1a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_4_1a_followup']) && $savedScores['scores']['clinical_features_4_1a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_4_1a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Mild dysphagia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_4_1b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_4_1b_followup']) && $savedScores['scores']['clinical_features_4_1b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_4_1b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id"><strong>16</strong></td>
                    <td><strong>Abdominal Pain</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_4_2a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_4_2a_followup']) && $savedScores['scores']['clinical_features_4_2a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_4_2a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Moderate</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_4_2b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_4_2b_followup']) && $savedScores['scores']['clinical_features_4_2b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_4_2b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Mild</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_4_2c_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_4_2c_followup']) && $savedScores['scores']['clinical_features_4_2c_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_4_2c_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 5 -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Pulmonary Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_5_followup'] ?? '' }}"
                                name="scores[disease_activity_5_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_5_followup'] ?? '' }}"
                                name="input_types[disease_activity_5_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>
                <tr class="section-2-sub">
                    <td class="fixed-id">17</td>
                    <td><strong>Resp. Muscle weakness without ILD</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Dyspnea at rest</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_1a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_1a_followup']) && $savedScores['scores']['clinical_features_5_1a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_1a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Dyspnea on exertion</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_1b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_1b_followup']) && $savedScores['scores']['clinical_features_5_1b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_1b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">18</td>
                    <td><strong>Active Reversible ILD</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Dyspnea or cough due to ILD</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_2a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_2a_followup']) && $savedScores['scores']['clinical_features_5_2a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_2a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Parenchymal abnormalities on chest x-ray or high-resolution CT scan
                        (HRCT) and/or ground glass shadowing on HRCT</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_2b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_2b_followup']) && $savedScores['scores']['clinical_features_5_2b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_2b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Pulmonary Function Tests: ≥ 10% change in FVC OR ≥ 15% change in DLCO</strong>
                    </td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_2c_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_2c_followup']) && $savedScores['scores']['clinical_features_5_2c_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_2c_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">19</td>
                    <td><strong>Dysphonia</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Moderate to severe</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_3a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_3a_followup']) && $savedScores['scores']['clinical_features_5_3a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_3a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Mild</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_5_3b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_5_3b_followup']) && $savedScores['scores']['clinical_features_5_3b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_5_3b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 6 -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Cardiovascular Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_6_followup'] ?? '' }}"
                                name="scores[disease_activity_6_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_6_followup'] ?? '' }}"
                                name="input_types[disease_activity_6_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">20</td>
                    <td><strong>Pericarditis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_6_1_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_6_1_followup']) && $savedScores['scores']['clinical_features_6_1_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_6_1_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">21</td>
                    <td><strong>Myocarditis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_6_2_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_6_2_followup']) && $savedScores['scores']['clinical_features_6_2_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_6_2_followup]" value="radio">
                        </div>
                    </td>
                </tr>
                <tr class="section-2-sub">
                    <td class="fixed-id">22</td>
                    <td><strong>Arrhythmias</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe arrhythmia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_6_3a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_6_3a_followup']) && $savedScores['scores']['clinical_features_6_3a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_6_3a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Other arrhythmia, except sinus tachycardia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_6_3b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_6_3b_followup']) && $savedScores['scores']['clinical_features_6_3b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_6_3b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td class="fixed-id">23</td>
                    <td><strong>Sinus Tachycardia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_6_4_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_6_4_followup']) && $savedScores['scores']['clinical_features_6_4_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_6_4_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 7 -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Other Disease Activity</strong><br>
                        <input type="text" class="form-control form-control-sm w-25" placeholder="Specify_____"
                            name="scores[other_disease_specification]"
                            value="{{ $savedScores['scores']['other_disease_specification'] ?? '' }}" />
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_7_followup'] ?? '' }}"
                                name="scores[disease_activity_7_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_7_followup'] ?? '' }}"
                                name="input_types[disease_activity_7_followup]" readonly>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_7_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_7_followup']) && $savedScores['scores']['clinical_features_7_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_7_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 8 -->
                <tr class="section-2">
                    <td class="fixed-id"></td>
                    <td><strong>Extra Muscular Global Assessment</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_8_followup'] ?? '' }}"
                                name="scores[disease_activity_8_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_8_followup'] ?? '' }}"
                                name="input_types[disease_activity_8_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <!-- Section 9 -->
                <tr class="section-2">
                    <td class="fixed-id"></td>
                    <td><strong>Muscle Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['disease_activity_9_followup'] ?? '' }}"
                                name="scores[disease_activity_9_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['disease_activity_9_followup'] ?? '' }}"
                                name="input_types[disease_activity_9_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <!-- Section 10 -->
                <tr class="section-2-sub">
                    <td class="fixed-id">24</td>
                    <td><strong>Myositis</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe muscle inflammation</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_10a_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_10a_followup']) && $savedScores['scores']['clinical_features_10a_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_10a_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Moderate muscle inflammation</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_10b_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_10b_followup']) && $savedScores['scores']['clinical_features_10b_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_10b_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Mild muscle inflammation</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_10c_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_10c_followup']) && $savedScores['scores']['clinical_features_10c_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_10c_followup]" value="radio">
                        </div>
                    </td>
                </tr>

                <!-- Section 11 -->
                <tr class="section-2-sub">
                    <td class="fixed-id">25</td>
                    <td><strong>Myalgia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            @foreach(['0','1','2','3','4','NA'] as $val)
                            <label>
                                <input type="radio" name="scores[clinical_features_11_followup]" value="{{ $val }}"
                                    {{ isset($savedScores['scores']['clinical_features_11_followup']) && $savedScores['scores']['clinical_features_11_followup'] == $val ? 'checked' : '' }}>
                                {{ $val }}
                            </label>
                            @endforeach
                            <input type="hidden" name="input_types[clinical_features_11_followup]" value="radio">
                        </div>
                    </td>
                </tr>


                <!-- Continue with all sections exactly as in your initial form -->
                <!-- Each section follows the same pattern with "_followup" suffix added to field names -->

                <!-- Section 12 - Global -->
                <tr class="section-2" style="background-color: #83a8dc !important;">
                    <td class="fixed-id"></td>
                    <td><strong>Global Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="{{ $savedScores['scores']['global_disease_activity_followup'] ?? '' }}"
                                name="scores[global_disease_activity_followup]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="{{ $savedScores['scores']['global_disease_activity_followup'] ?? '' }}"
                                name="input_types[global_disease_activity_followup]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>
            </tbody>
        </table>
       <!--  <button type="button" class="btn btn-success save-btn" data-form-id="form7mdaatfollowup">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span> -->
    </div>


</form>

<br>
<hr>