@extends('layouts.app')

@section('content')
<br><br><br>
<div class="container">
    

    <h2 class="text-center">My Assigned Cases</h2>
    
   

    <!-- Cases Table -->
    <div class="card">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-striped table-bordered" id="casesTable">
                    <thead class="table-dark">
                        <tr>
                            <th>Case No.</th>
                            <th>Title</th>
                            <th>Assigned Date</th>
                            <th>Assigned Time</th>
                            
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($documents as $document)
                        <tr>
                            <td>{{ $document->case_no }}</td>
                            <td>{{ $document->title }}</td>
                            <td>{{ $document->created_at->setTimezone('America/Los_Angeles')->format('Y-m-d') }}</td>
                            <td>{{ $document->created_at->setTimezone('America/Los_Angeles')->format('h:i A') }}</td>
                            
                            <td>
                                @if(in_array($document->case_no, $submittedCaseIds))
                                    <button class="btn btn-sm" style="background: linear-gradient(135deg, #00c9a7, #92fe9d); color: #fff; border: none;">
                                        <i class="fas fa-check-circle"></i> Submitted
                                    </button>
                                    <a href="{{ route('user.viewDocument', $document->id) }}" class="btn btn-sm" style="background: linear-gradient(135deg, #2193b0, #6dd5ed); color: #fff; border: none;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                @elseif(in_array($document->case_no, $draftCaseIds))
                                    <a href="{{ route('user.viewDocument', $document->id) }}" class="btn btn-sm" style="background: linear-gradient(135deg, #f7971e, #ffd200); color: #fff; border: none;">
                                        <i class="fas fa-sync-alt"></i> Resume
                                    </a>
                                @else
                                    <a href="{{ route('user.viewDocument', $document->id) }}" class="btn btn-sm" style="background: linear-gradient(135deg, #ff6a00, #ee0979); color: #fff; border: none;">
                                        <i class="fas fa-play"></i> Begin
                                    </a>
                                @endif
                            </td>
                            
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Pagination -->
    <div class="d-flex justify-content-center mt-3">
        {{ $documents->links() }}
    </div>
</div>

 
@endsection