@extends('layouts.app')

@section('content') <br><br><br><br><br>
<div class="container mt-4">
    <div class="row">
        <div class="col-md-4">
            <!-- Profile Card -->
            <div class="card">
                <div class="card-body text-center">
                    <img src="{{ asset('img/user_avatar.png') }}" class="rounded-circle img-fluid" alt="User Avatar" width="120">
                    <h4 class="mt-3">{{ auth()->user()->username }}</h4>
                    <p class="text-muted">{{ auth()->user()->role == 'admin' ? 'Administrator' : 'User' }}</p>
                  
                </div>
            </div>

            <!-- Quick Links -->
            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title">Quick Actions</h5>
                    <ul class="list-group">
                        <li class="list-group-item"><a href="{{ route('user.myCases') }}">My Cases</a></li>
                        @if(auth()->user()->role == 'admin')
                        <li class="list-group-item"><a href="{{ route('users.index') }}">Manage Users</a></li>
                        @endif
                        <li class="list-group-item">
                            <form action="{{ route('logout') }}" method="POST">
                                @csrf
                                <button type="submit" class="btn btn-danger btn-block">Logout</button>
                            </form>
                        </li>
                    </ul>
                </div>
            </div>
        </div>

        <!-- User Details -->
        <div class="col-md-8">
            <div class="card">
                <div class="card-body">
                    <h5 class="card-title">Personal Details</h5>
                    <table class="table table-borderless">
                        <tr>
                            <th>Full Name:</th>
                            <td>{{ auth()->user()->username ?? 'user' }}</td>
                        </tr>
                        <tr> 
                            <th>Email:</th>
                            <td>{{ auth()->user()->email }}</td>
                        </tr>
                        
                        
                        <tr>
                            <th>Joined On:</th>
                            <td>{{ auth()->user()->created_at->format('d M Y') }}</td>
                        </tr>
                        <tr>
    <th>Status:</th>
    <td>
        @if(auth()->user()->is_active)
            <span class="badge badge-success">Active</span>
        @else
            <span class="badge badge-danger">Inactive</span>
        @endif
    </td>
</tr>

                    </table>
                </div>
            </div>

            <!-- Account Settings -->
            <div class="card mt-3">
                <div class="card-body">
                    <h5 class="card-title">Account Settings</h5>
                    <p>Manage your account details.</p>
                    <a href="{{route('password.request')}}" class="btn btn-warning btn-sm">Change Password</a>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
