@extends('layouts.app')



@section('content') <br><br><br>



<!-- Custom CSS -->

<style>
    html,

    body {

        overflow: hidden;

        height: 100%;

        background: linear-gradient(135deg, #317c81, #a31660, #ff5f6d);

        font-family: 'Poppins', sans-serif;

    }



    .main-container {

        display: flex;

        flex-direction: column;

        gap: 15px;

        padding: 15px;

        height: 100vh;

    }



    .content-wrapper {

        display: flex;

        gap: 15px;

        flex-grow: 1;

        overflow-y: auto;

        height: calc(100vh - 100px);

        margin-top: 100px;

        margin-top: 0px !important;

        /* Removed margin to push content to the top */

        padding-top: 0px !important;

    }



    .document-container,

    .scrollable-section {

        background: #ffffff;

        padding: 12px;

        border-radius: 10px;

        box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);

        flex: 1;

        overflow-y: auto;

        height: 100%;

        transition: all 0.3s ease-in-out;

        position: relative;



    }



    .document-container .header-bar,

    .scrollable-section .header-bar {

        position: sticky;

        top: 0;

        background: linear-gradient(135deg, #1B1F24, #2A4B7C);



        z-index: 10;

        padding: 10px 15px;

        display: flex;

        justify-content: space-between;

        align-items: center;

        border-radius: 8px 8px 0 0;

    }



    .header-bar h4 {

        margin: 0;

        font-weight: 600;

        font-size: 18px;

        color: white;

    }



    .scrollable {

        overflow-y: auto;

        height: calc(100% - 50px);

    }



    .fullscreen {

        position: fixed;

        top: 0;

        left: 0;

        width: 100%;

        height: 100%;

        z-index: 10000;

        background: #ffffff;

        box-shadow: 0px 6px 20px rgba(0, 0, 0, 0.3);

    }



    .horizontal-list {

        list-style-type: none;

        padding: 0;

        display: flex;

        flex-wrap: wrap;

    }



    .horizontal-list li {

        margin-right: 20px;

        font-size: 14px;



    }
</style>



<div class="main-container">





    <div class="content-wrapper">

        <div class="document-container" id="docViewer">

            <div class="header-bar">

                <h4><i class="fa fa-file-alt"></i> {{$document->title}} </h4>

                <div>

                    <a href="{{ route('user.downloadDocument', $document->id) }}" class="btn btn-success btn-custom">

                        <i class="fa fa-download"></i> Download

                    </a>

                    <button class="btn btn-primary btn-custom expand-btn" data-target="docViewer">

                        <i class="fa fa-expand"></i> Expand

                    </button>

                    <button class="btn btn-danger btn-custom minimize-btn" data-target="docViewer"
                        style="display: none;">

                        <i class="fa fa-compress"></i> Minimize

                    </button>

                </div>

            </div>

            <div class="scrollable" id="docViewerScroll">

                @if(isset($htmlContent))

                <div class="word-content">

                    {!! $htmlContent !!}

                </div>

                @elseif(isset($document->file_path))

                <iframe src="{{ asset($document->file_path) }}" width="100%" height="600px"></iframe>

                @else

                <p class="alert alert-warning">No content available.</p>

                @endif

            </div>





        </div>



        <div class="scrollable-section" id="caseScoringSheet">

            <div class="header-bar" style=" background: linear-gradient(135deg, #1B1F24, #2A4B7C)" ;>

                <h4><i class=" fa fa-bars"></i> Myositis Case Scoring Sheet</h4>

                <div>

                    <button class="btn btn-primary btn-custom expand-btn" data-target="caseScoringSheet">

                        <i class="fa fa-expand"></i> Expand

                    </button>

                    <button class="btn btn-danger btn-custom minimize-btn" data-target="caseScoringSheet"
                        style="display: none;">

                        <i class="fa fa-compress"></i> Minimize

                    </button>

                </div>

            </div>

            <div class="scrollable" id="caseScoringSheetScroll">



                <div class="row">

                    <div class="col-sm-12 col-lg-12">

                        <div class="heading clearfix">

                            <div class="row header-container">

                                <div class="col-sm-4 col-md-4">

                                    <label class="header-label">Investigator Name:</label>

                                    <input class="input-sm form-control header-input"
                                        value="{{ auth()->user()->username }}" type="text" readonly>

                                </div>



                                <div class="col-sm-4 col-md-4">

                                    <label class="header-label">Case No:</label>

                                    <input class="input-sm form-control header-input" value="{{ $case_no }}" type="text"
                                        readonly>

                                </div>



                                <div class="col-sm-4 col-md-4">

                                    <label class="header-label">Date:</label>

                                    <input class="input-sm form-control header-input"
                                        value="{{ \Carbon\Carbon::now()->format('m/d/Y') }}" type="text" readonly>

                                </div>



                            </div>

                        </div>





                        <input type="hidden" name="case_no" value="{{ $case_no }}">



                        <!--  Case 1 Presentation: Initial -->

                        <div class="table-container">

                            <h4>Case 1 Presentation: Initial </h4>

                            <hr>

                            <h5 style="font-size:15px;">Myositis Disease Activity Assessment Tool (MDAAT) <br>

                                Answers with possible correct responses based on case review:</h5>

                            <form method="post" action="{{route('scoring.sheet.store')}}">

                                @csrf

                                <table class="table table-striped table-bordered mediaTable table-1">

                                    <thead>

                                        <tr>

                                            <th class="optional fixed-id">S/N</th>

                                            <th class="essential persist">Disease Activity</th>

                                            <th class="optional" style="width: 150px;">Overall Organ Disease Activity

                                                (0-10 cm) VAS

                                            </th>

                                            <th class="optional" style="width: 200px;">Clinical Features (0,1,2,3,4, NA)

                                            </th>

                                        </tr>

                                    </thead>

                                    <tbody>

                                        <!-- Section 1 -->

                                        <tr class="section-1">

                                            <td class="fixed-id">1</td>

                                            <td>Constitutional Disease Activity</td>

                                            <td>

                                                <div class="slider-container">

                                                    <input type="range" min="0" max="10" value="0" class="slider"
                                                        name="scores[disease_activity_1]"
                                                        oninput="this.nextElementSibling.value = this.value">

                                                    <input type="text" class="slider-value form-control"
                                                        name="input_types[disease_activity_1]" value="0" readonly>

                                                </div>

                                            </td>

                                            <td></td>

                                        </tr>



                                        <!-- Section 1 Subsections -->

                                        <tr class="section-1-sub">

                                            <td class="fixed-id">1.1</td>

                                            <td>Pyrexia</td>

                                            <td></td>

                                            <td>

                                                <div class="radio-container">

                                                    <label><input type="radio" name="scores[clinical_features_1_1]"
                                                            value="0"> 0</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_1]"
                                                            value="1"> 1</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_1]"
                                                            value="2"> 2</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_1]"
                                                            value="3"> 3</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_1]"
                                                            value="4"> 4</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_1]"
                                                            value="NA"> NA</label>

                                                    <input type="hidden" name="input_types[clinical_features_1_1]"
                                                        value="radio">

                                                </div>

                                            </td>

                                        </tr>



                                        <tr class="section-1-sub">

                                            <td class="fixed-id">1.2</td>

                                            <td>Weight Loss</td>

                                            <td></td>

                                            <td>

                                                <div class="radio-container">

                                                    <label><input type="radio" name="scores[clinical_features_1_2]"
                                                            value="0"> 0</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_2]"
                                                            value="1"> 1</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_2]"
                                                            value="2"> 2</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_2]"
                                                            value="3"> 3</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_2]"
                                                            value="4"> 4</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_2]"
                                                            value="NA"> NA</label>

                                                    <input type="hidden" name="input_types[clinical_features_1_2]"
                                                        value="radio">

                                                </div>

                                            </td>

                                        </tr>



                                        <tr class="section-1-sub">

                                            <td class="fixed-id">1.3</td>

                                            <td>Fatigue</td>

                                            <td></td>

                                            <td>

                                                <div class="radio-container">

                                                    <label><input type="radio" name="scores[clinical_features_1_3]"
                                                            value="0"> 0</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_3]"
                                                            value="1"> 1</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_3]"
                                                            value="2"> 2</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_3]"
                                                            value="3"> 3</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_3]"
                                                            value="4"> 4</label>

                                                    <label><input type="radio" name="scores[clinical_features_1_3]"
                                                            value="NA"> NA</label>

                                                    <input type="hidden" name="input_types[clinical_features_1_3]"
                                                        value="radio">

                                                </div>

                                            </td>

                                        </tr>



                                        <button type="submit">Save & Continue</button>

                            </form>

                            <!-- Section 2 -->

                            <tr class="section-1">

                                <td class="fixed-id">2</td>

                                <td>Cutaneous Disease Activity</td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td></td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.1</td>

                                <td>Cutaneous Ulceration </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="scores[clinical_features_2_1]" value="0">
                                            0</label>

                                        <label><input type="radio" name="scores[clinical_features_2_1]" value="1">
                                            1</label>

                                        <label><input type="radio" name="scores[clinical_features_2_1]" value="2">
                                            2</label>

                                        <label><input type="radio" name="scores[clinical_features_2_1]" value="3">
                                            3</label>

                                        <label><input type="radio" name="scores[clinical_features_2_1]" value="4">
                                            4</label>

                                        <label><input type="radio" name="scores[clinical_features_2_1]" value="NA">
                                            NA</label>

                                        <input type="hidden" name="input_types[clinical_features_2_1]" value="radio">

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.2</td>

                                <td>Erythroderma </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="scores[clinical_features_2_2]" value="0">
                                            0</label>

                                        <label><input type="radio" name="scores[clinical_features_2_2]" value="1">
                                            1</label>

                                        <label><input type="radio" name="scores[clinical_features_2_2]" value="2">
                                            2</label>

                                        <label><input type="radio" name="scores[clinical_features_2_2]" value="3">
                                            3</label>

                                        <label><input type="radio" name="scores[clinical_features_2_2]" value="4">
                                            4</label>

                                        <label><input type="radio" name="scores[clinical_features_2_2]" value="NA">
                                            NA</label>

                                        <input type="hidden" name="input_types[clinical_features_2_2]" value="radio">

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.3</td>

                                <td>Panniculitis </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="scores[clinical_features_2_3]" value="0">
                                            0</label>

                                        <label><input type="radio" name="scores[clinical_features_2_3]" value="1">
                                            1</label>

                                        <label><input type="radio" name="scores[clinical_features_2_3]" value="2">
                                            2</label>

                                        <label><input type="radio" name="scores[clinical_features_2_3]" value="3">
                                            3</label>

                                        <label><input type="radio" name="scores[clinical_features_2_3]" value="4">
                                            4</label>

                                        <label><input type="radio" name="scores[clinical_features_2_3]" value="NA">
                                            NA</label>

                                        <input type="hidden" name="input_types[clinical_features_2_3]" value="radio">

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>2.4</strong></td>

                                <td><strong>Erythematous Rash</strong></td>

                                <td></td>

                                <td></td>

                            </tr>



                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. with secondary changes (e.g. accompanied by erosions,
                                    vesiculobullous change or necrosis)</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="erythematous_rash_a" value="0"> 0</label>

                                        <label><input type="radio" name="erythematous_rash_a" value="1"> 1</label>

                                        <label><input type="radio" name="erythematous_rash_a" value="2"> 2</label>

                                        <label><input type="radio" name="erythematous_rash_a" value="3"> 3</label>

                                        <label><input type="radio" name="erythematous_rash_a" value="4"> 4</label>

                                        <label><input type="radio" name="erythematous_rash_a" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. without secondary changes</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="erythematous_rash_b" value="0"> 0</label>

                                        <label><input type="radio" name="erythematous_rash_b" value="1"> 1</label>

                                        <label><input type="radio" name="erythematous_rash_b" value="2"> 2</label>

                                        <label><input type="radio" name="erythematous_rash_b" value="3"> 3</label>

                                        <label><input type="radio" name="erythematous_rash_b" value="4"> 4</label>

                                        <label><input type="radio" name="erythematous_rash_b" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.5</td>

                                <td>Heliotrope rash </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="scores[clinical_features_2_5]" value="0">
                                            0</label>

                                        <label><input type="radio" name="scores[clinical_features_2_5]" value="1">
                                            1</label>

                                        <label><input type="radio" name="scores[clinical_features_2_5]" value="2">
                                            2</label>

                                        <label><input type="radio" name="scores[clinical_features_2_5]" value="3">
                                            3</label>

                                        <label><input type="radio" name="scores[clinical_features_2_5]" value="4">
                                            4</label>

                                        <label><input type="radio" name="scores[clinical_features_2_5]" value="NA">
                                            NA</label>

                                        <input type="hidden" name="input_types[clinical_features_2_5]" value="radio">

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.6</td>

                                <td>Gottron’s papules/sign </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="scores[clinical_features_2_6]" value="0">
                                            0</label>

                                        <label><input type="radio" name="scores[clinical_features_2_6]" value="1">
                                            1</label>

                                        <label><input type="radio" name="scores[clinical_features_2_6]" value="2">
                                            2</label>

                                        <label><input type="radio" name="scores[clinical_features_2_6]" value="3">
                                            3</label>

                                        <label><input type="radio" name="scores[clinical_features_2_6]" value="4">
                                            4</label>

                                        <label><input type="radio" name="scores[clinical_features_2_6]" value="NA">
                                            NA</label>

                                        <input type="hidden" name="input_types[clinical_features_2_6]" value="radio">

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.7</td>

                                <td>Periungual capillary changes </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="scores[clinical_features_2_7]" value="0">
                                            0</label>

                                        <label><input type="radio" name="scores[clinical_features_2_7]" value="1">
                                            1</label>

                                        <label><input type="radio" name="scores[clinical_features_2_7]" value="2">
                                            2</label>

                                        <label><input type="radio" name="scores[clinical_features_2_7]" value="3">
                                            3</label>

                                        <label><input type="radio" name="scores[clinical_features_2_7]" value="4">
                                            4</label>

                                        <label><input type="radio" name="scores[clinical_features_2_7]" value="NA">
                                            NA</label>

                                        <input type="hidden" name="input_types[clinical_features_2_7]" value="radio">

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td>2.8</td>

                                <td>Alopecia</td>

                                <td></td>

                                <td></td>

                            </tr>



                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Diffuse hair Loss</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="alopecia-a" value="0"> 0</label>

                                        <label><input type="radio" name="alopecia-a" value="1"> 1</label>

                                        <label><input type="radio" name="alopecia-a" value="2"> 2</label>

                                        <label><input type="radio" name="alopecia-a" value="3"> 3</label>

                                        <label><input type="radio" name="alopecia-a" value="4"> 4</label>

                                        <label><input type="radio" name="alopecia-a" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Focal, Patchy with Erythema </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="alopecia-b" value="0"> 0</label>

                                        <label><input type="radio" name="alopecia-b" value="1"> 1</label>

                                        <label><input type="radio" name="alopecia-b" value="2"> 2</label>

                                        <label><input type="radio" name="alopecia-b" value="3"> 3</label>

                                        <label><input type="radio" name="alopecia-b" value="4"> 4</label>

                                        <label><input type="radio" name="alopecia-b" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">2.9</td>

                                <td>Mechanics Hand </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="mechanics_hand" value="0"> 0</label>

                                        <label><input type="radio" name="mechanics_hand" value="1"> 1</label>

                                        <label><input type="radio" name="mechanics_hand" value="2"> 2</label>

                                        <label><input type="radio" name="mechanics_hand" value="3"> 3</label>

                                        <label><input type="radio" name="mechanics_hand" value="4"> 4</label>

                                        <label><input type="radio" name="mechanics_hand" value="NA"> NA</label>


                                    </div>

                                </td>

                            </tr>


                            <!-- Section 3 -->

                            <tr class="section-1">

                                <td class="fixed-id">3</td>

                                <td>Skeletal Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>

                            </tr>





                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>3.1</strong></td>

                                <td><strong>Arthritis</strong></td>

                                <td></td>

                                <td></td>



                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Severe active polyarthritis</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="polyarthritis_a" value="0">

                                            0</label>

                                        <label><input type="radio" name="polyarthritis_a" value="0">

                                            1</label>

                                        <label><input type="radio" name="polyarthritis_a" value="2">

                                            2</label>

                                        <label><input type="radio" name="polyarthritis_a" value="3">

                                            3</label>

                                        <label><input type="radio" name="polyarthritis_a" value="4">

                                            4</label>

                                        <label><input type="radio" name="polyarthritis_a" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>
                            <tr class="section-1-sub">

<td></td>

<td class="sub-heading">B. Moderately active arthritis</td>

<td></td>

<td>

    <div class="radio-container">

        <label><input type="radio" name="moderately_active_arthritis_b" value="0">

            0</label>

        <label><input type="radio" name="moderately_active_arthritis_b" value="0">

            1</label>

        <label><input type="radio" name="moderately_active_arthritis_b" value="2">

            2</label>

        <label><input type="radio" name="moderately_active_arthritis_b" value="3">

            3</label>

        <label><input type="radio" name="moderately_active_arthritis_b" value="4">

            4</label>

        <label><input type="radio" name="moderately_active_arthritis_b" value="NA">

            NA</label>

    </div>

</td>

</tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">C. Mild arthritis</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="milarth_c" value="0">

                                            0</label>

                                        <label><input type="radio" name="milarth_c" value="0">

                                            1</label>

                                        <label><input type="radio" name="milarth_c" value="2">

                                            2</label>

                                        <label><input type="radio" name="milarth_c" value="3">

                                            3</label>

                                        <label><input type="radio" name="milarth_c" value="4">

                                            4</label>

                                        <label><input type="radio" name="milarth_c" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>





                            <tr class="section-1-sub">

                                <td class="fixed-id">3.2</td>

                                <td>Arthralgia </td>

                                <td>



                                </td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="clinical_features_1_3" value="0">

                                            0</label>

                                        <label><input type="radio" name="clinical_features_1_3" value="0">

                                            1</label>

                                        <label><input type="radio" name="clinical_features_1_3" value="2">

                                            2</label>

                                        <label><input type="radio" name="clinical_features_1_3" value="3">

                                            3</label>

                                        <label><input type="radio" name="clinical_features_1_3" value="4">

                                            4</label>

                                        <label><input type="radio" name="clinical_features_1_3" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>







                            <!-- Section 4 -->

                            <tr class="section-1">

                                <td class="fixed-id">4</td>

                                <td>GI Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>

                            </tr>





                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>4.1</strong></td>

                                <td><strong>Dysphagia</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Moderate/severe dysphagia</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="dysphagia_a" value="0"> 0</label>

                                        <label><input type="radio" name="dysphagia_a" value="0"> 1</label>

                                        <label><input type="radio" name="dysphagia_a" value="2"> 2</label>

                                        <label><input type="radio" name="dysphagia_a" value="3"> 3</label>

                                        <label><input type="radio" name="dysphagia_a" value="4"> 4</label>

                                        <label><input type="radio" name="dysphagia_a" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Mild dysphagia</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="dysphagia_b" value="0"> 0</label>

                                        <label><input type="radio" name="dysphagia_b" value="0"> 1</label>

                                        <label><input type="radio" name="dysphagia_b" value="2"> 2</label>

                                        <label><input type="radio" name="dysphagia_b" value="3"> 3</label>

                                        <label><input type="radio" name="dysphagia_b" value="4"> 4</label>

                                        <label><input type="radio" name="dysphagia_b" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>







                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>4.2</strong></td>

                                <td><strong>Abdominal Pain</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Severe</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="abdominal_pain_a" value="0">

                                            0</label>

                                        <label><input type="radio" name="abdominal_pain_a" value="0">

                                            1</label>

                                        <label><input type="radio" name="abdominal_pain_a" value="2">

                                            2</label>

                                        <label><input type="radio" name="abdominal_pain_a" value="3">

                                            3</label>

                                        <label><input type="radio" name="abdominal_pain_a" value="4">

                                            4</label>

                                        <label><input type="radio" name="abdominal_pain_a" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Moderate</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="abdominal_pain_b" value="0">

                                            0</label>

                                        <label><input type="radio" name="abdominal_pain_b" value="0">

                                            1</label>

                                        <label><input type="radio" name="abdominal_pain_b" value="2">

                                            2</label>

                                        <label><input type="radio" name="abdominal_pain_b" value="3">

                                            3</label>

                                        <label><input type="radio" name="abdominal_pain_b" value="4">

                                            4</label>

                                        <label><input type="radio" name="abdominal_pain_b" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">C. Mild</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="abdominal_pain_c" value="0">

                                            0</label>

                                        <label><input type="radio" name="abdominal_pain_c" value="0">

                                            1</label>

                                        <label><input type="radio" name="abdominal_pain_c" value="2">

                                            2</label>

                                        <label><input type="radio" name="abdominal_pain_c" value="3">

                                            3</label>

                                        <label><input type="radio" name="abdominal_pain_c" value="4">

                                            4</label>

                                        <label><input type="radio" name="abdominal_pain_c" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>





                            <!-- Section 5 -->

                            <tr class="section-1">

                                <td class="fixed-id">5</td>

                                <td>Pulmonary Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>5.1</strong></td>

                                <td><strong>Resp. Muscle weakness without ILD</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Dyspnea at rest</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="resp_muscle_weakness_a" value="0">

                                            0</label>

                                        <label><input type="radio" name="resp_muscle_weakness_a" value="0">

                                            1</label>

                                        <label><input type="radio" name="resp_muscle_weakness_a" value="2">

                                            2</label>

                                        <label><input type="radio" name="resp_muscle_weakness_a" value="3">

                                            3</label>

                                        <label><input type="radio" name="resp_muscle_weakness_a" value="4">

                                            4</label>

                                        <label><input type="radio" name="resp_muscle_weakness_a" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Dyspnea on exertion</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="resp_muscle_weakness_b" value="0">

                                            0</label>

                                        <label><input type="radio" name="resp_muscle_weakness_b" value="0">

                                            1</label>

                                        <label><input type="radio" name="resp_muscle_weakness_b" value="2">

                                            2</label>

                                        <label><input type="radio" name="resp_muscle_weakness_b" value="3">

                                            3</label>

                                        <label><input type="radio" name="resp_muscle_weakness_b" value="4">

                                            4</label>

                                        <label><input type="radio" name="resp_muscle_weakness_b" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>





                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>5.2</strong></td>

                                <td><strong>Active Reversible ILD</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Dyspnea or cough due to ILD</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="active_ild_a" value="0"> 0</label>

                                        <label><input type="radio" name="active_ild_a" value="0"> 1</label>

                                        <label><input type="radio" name="active_ild_a" value="2"> 2</label>

                                        <label><input type="radio" name="active_ild_a" value="3"> 3</label>

                                        <label><input type="radio" name="active_ild_a" value="4"> 4</label>

                                        <label><input type="radio" name="active_ild_a" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Parenchymal abnormalities on chest x-ray or

                                    high-resolution CT scan (HRCT) and/or ground glass shadowing on HRCT

                                </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="active_ild_b" value="0"> 0</label>

                                        <label><input type="radio" name="active_ild_b" value="0"> 1</label>

                                        <label><input type="radio" name="active_ild_b" value="2"> 2</label>

                                        <label><input type="radio" name="active_ild_b" value="3"> 3</label>

                                        <label><input type="radio" name="active_ild_b" value="4"> 4</label>

                                        <label><input type="radio" name="active_ild_b" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">C. Pulmonary Function Tests: ≥ 10% change in FVC OR

                                    ≥

                                    15% change in DLCO</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="active_ild_c" value="0"> 0</label>

                                        <label><input type="radio" name="active_ild_c" value="0"> 1</label>

                                        <label><input type="radio" name="active_ild_c" value="2"> 2</label>

                                        <label><input type="radio" name="active_ild_c" value="3"> 3</label>

                                        <label><input type="radio" name="active_ild_c" value="4"> 4</label>

                                        <label><input type="radio" name="active_ild_c" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>





                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>5.3</strong></td>

                                <td><strong>Dysphonia</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Moderate to severe</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="dysphonia_a" value="0"> 0</label>

                                        <label><input type="radio" name="dysphonia_a" value="0"> 1</label>

                                        <label><input type="radio" name="dysphonia_a" value="2"> 2</label>

                                        <label><input type="radio" name="dysphonia_a" value="3"> 3</label>

                                        <label><input type="radio" name="dysphonia_a" value="4"> 4</label>

                                        <label><input type="radio" name="dysphonia_a" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Mild</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="dysphonia_b" value="0"> 0</label>

                                        <label><input type="radio" name="dysphonia_b" value="0"> 1</label>

                                        <label><input type="radio" name="dysphonia_b" value="2"> 2</label>

                                        <label><input type="radio" name="dysphonia_b" value="3"> 3</label>

                                        <label><input type="radio" name="dysphonia_b" value="4"> 4</label>

                                        <label><input type="radio" name="dysphonia_b" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>





                            <!-- Section 6 -->

                            <tr class="section-1">

                                <td class="fixed-id">6</td>

                                <td>Cardiovascular Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>



                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">6.1</td>

                                <td>Pericarditis</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="clinical_features_6_1" value="0"> 0</label>

                                        <label><input type="radio" name="clinical_features_6_1" value="1"> 1</label>

                                        <label><input type="radio" name="clinical_features_6_1" value="2"> 2</label>

                                        <label><input type="radio" name="clinical_features_6_1" value="3"> 3</label>

                                        <label><input type="radio" name="clinical_features_6_1" value="4"> 4</label>

                                        <label><input type="radio" name="clinical_features_6_1" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id">6.2</td>

                                <td>Myocarditis</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="clinical_features_6_2" value="0"> 0</label>

                                        <label><input type="radio" name="clinical_features_6_2" value="1"> 1</label>

                                        <label><input type="radio" name="clinical_features_6_2" value="2"> 2</label>

                                        <label><input type="radio" name="clinical_features_6_2" value="3"> 3</label>

                                        <label><input type="radio" name="clinical_features_6_2" value="4"> 4</label>

                                        <label><input type="radio" name="clinical_features_6_2" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>



                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>6.3</strong></td>

                                <td><strong>Arrhythmias</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Severe arrhythmia</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="arrhythmia_a" value="0"> 0</label>

                                        <label><input type="radio" name="arrhythmia_a" value="0"> 1</label>

                                        <label><input type="radio" name="arrhythmia_a" value="2"> 2</label>

                                        <label><input type="radio" name="arrhythmia_a" value="3"> 3</label>

                                        <label><input type="radio" name="arrhythmia_a" value="4"> 4</label>

                                        <label><input type="radio" name="arrhythmia_a" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Other arrhythmia, except sinus tachycardia</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="arrhythmia_b" value="0"> 0</label>

                                        <label><input type="radio" name="arrhythmia_b" value="0"> 1</label>

                                        <label><input type="radio" name="arrhythmia_b" value="2"> 2</label>

                                        <label><input type="radio" name="arrhythmia_b" value="3"> 3</label>

                                        <label><input type="radio" name="arrhythmia_b" value="4"> 4</label>

                                        <label><input type="radio" name="arrhythmia_b" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>







                            <tr class="section-1-sub">

                                <td class="fixed-id">6.4</td>

                                <td>Sinus Tachycardia </td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="clinical_featuress_1_3" value="0">

                                            0</label>

                                        <label><input type="radio" name="clinical_featuress_1_3" value="0">

                                            1</label>

                                        <label><input type="radio" name="clinical_featuress_1_3" value="2">

                                            2</label>

                                        <label><input type="radio" name="clinical_featuress_1_3" value="3">

                                            3</label>

                                        <label><input type="radio" name="clinical_featuress_1_3" value="4">

                                            4</label>

                                        <label><input type="radio" name="clinical_featuress_1_3" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>



                            <!-- Section 7 -->



                            <tr class="section-1">

                                <td class="fixed-id">7</td>

                                <td>Other Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="myositis_otheractivity" value="0"> 0</label>

                                        <label><input type="radio" name="myositis_otheractivity" value="0"> 1</label>

                                        <label><input type="radio" name="myositis_otheractivity" value="2"> 2</label>

                                        <label><input type="radio" name="myositis_otheractivity" value="3"> 3</label>

                                        <label><input type="radio" name="myositis_otheractivity" value="4"> 4</label>

                                        <label><input type="radio" name="myositis_otheractivity" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>

                            <!-- Section 8 -->



                            <tr class="section-1">

                                <td class="fixed-id">8</td>

                                <td>Extra Muscular Global Assessment </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>

                            </tr>



                            <!-- Section 9 -->



                            <tr class="section-1">

                                <td class="fixed-id">9</td>

                                <td>Muscle Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>

                            </tr>





                            <!-- 10 -->





                            <tr class="section-1-sub">

                                <td class="fixed-id"><strong>10</strong></td>

                                <td><strong>Myositis</strong></td>

                                <td></td>

                                <td></td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">A. Severe muscle inflammation</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="myositis_a" value="0"> 0</label>

                                        <label><input type="radio" name="myositis_a" value="0"> 1</label>

                                        <label><input type="radio" name="myositis_a" value="2"> 2</label>

                                        <label><input type="radio" name="myositis_a" value="3"> 3</label>

                                        <label><input type="radio" name="myositis_a" value="4"> 4</label>

                                        <label><input type="radio" name="myositis_a" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">B. Moderate muscle inflammation</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="myositis_b" value="0"> 0</label>

                                        <label><input type="radio" name="myositis_b" value="0"> 1</label>

                                        <label><input type="radio" name="myositis_b" value="2"> 2</label>

                                        <label><input type="radio" name="myositis_b" value="3"> 3</label>

                                        <label><input type="radio" name="myositis_b" value="4"> 4</label>

                                        <label><input type="radio" name="myositis_b" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>

                            <tr class="section-1-sub">

                                <td></td>

                                <td class="sub-heading">C. Mild muscle inflammation</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="myositis_c" value="0"> 0</label>

                                        <label><input type="radio" name="myositis_c" value="0"> 1</label>

                                        <label><input type="radio" name="myositis_c" value="2"> 2</label>

                                        <label><input type="radio" name="myositis_c" value="3"> 3</label>

                                        <label><input type="radio" name="myositis_c" value="4"> 4</label>

                                        <label><input type="radio" name="myositis_c" value="NA"> NA</label>

                                    </div>

                                </td>

                            </tr>





                            <!-- Section 11 -->



                            <tr class="section-1-sub">

                                <td class="fixed-id">11</td>

                                <td>Myalgia</td>

                                <td></td>

                                <td>

                                    <div class="radio-container">

                                        <label><input type="radio" name="Myalgia" value="0">

                                            0</label>

                                        <label><input type="radio" name="Myalgia" value="0">

                                            1</label>

                                        <label><input type="radio" name="Myalgia" value="2">

                                            2</label>

                                        <label><input type="radio" name="Myalgia" value="3">

                                            3</label>

                                        <label><input type="radio" name="Myalgia" value="4">

                                            4</label>

                                        <label><input type="radio" name="Myalgia" value="NA">

                                            NA</label>

                                    </div>

                                </td>

                            </tr>



                            <!-- Section 12 -->



                            <tr class="section-1-sub">

                                <td class="fixed-id">12</td>

                                <td>Global Disease Activity </td>

                                <td>

                                    <div class="slider-container">

                                        <input type="range" min="0" max="10" value="0" class="slider"
                                            oninput="this.nextElementSibling.value = this.value">

                                        <input type="text" class="slider-value form-control" value="0" readonly>

                                    </div>

                                </td>

                                <td>



                                </td>

                            </tr>





                            </tbody>

                            </table>

                        </div>

                        <br>

                        <hr>

                        <!-- Case 1 Presentation: Follow up Manual Muscle Testing-8 (MMT-8)-->

                        <div class="table-container">

                            <h3>

                                Case 1 Presentation: Initial <br>

                                <hr>

                                Manual Muscle Testing-8 (MMT-8)



                            </h3>

                            <span>

                                Answers with possible correct responses based on patient’s examination

                            </span>





                            <table class="table table-striped table-bordered mediaTable table-1">





                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Muscle Groups </th>

                                        <th class="optional" style="width: 200px; ">Right (0-10)

                                        </th>

                                        <th class="optional" style="width: 200px;">Left (0-10) </th>

                                        <th class="optional" style="width: 200px;">Axial (0-10) </th>



                                    </tr>

                                </thead>

                                <tr class="section-1">

                                    <td colspan="5"
                                        style="border: none; background-color: transparent; text-align: center;">

                                        <strong>Axial Muscle</strong>

                                    </td>

                                </tr>

                                <tbody>

                                    <!-- Section 1 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">1</td>

                                        <td>Neck Flexor </td>

                                        <td>

                                        </td>

                                        <td>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1">

                                        <th colspan="5" class="text-center">Proximal Muscles</th>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.1</td>

                                        <td>Deltoid </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>









                                    <tr class="section-1">

                                        <td class="fixed-id">1.2</td>

                                        <td>Biceps </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>



                                    <tr class="section-1">

                                        <td class="fixed-id">1.3</td>

                                        <td>Quadriceps </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.4</td>

                                        <td>Gluteus Medius </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.5</td>

                                        <td>Gluteus Maximus </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <th colspan="5" class="text-center" style="background-color: aliceblue;">Distal
                                            Muscles </th>

                                    </tr>



                                    <tr class="section-1">

                                        <td class="fixed-id">1.6</td>

                                        <td>Wrist Extensor </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.7</td>

                                        <td>Ankle Dorsiflexion</td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>







                                    <tr class="section-1">

                                        <th colspan="5" class="text-center" style="background-color: aliceblue;">MMT-8
                                            Scoring </th>

                                    </tr>



                                    <tr class="section-1 total-individual-score">

                                        <td class="fixed-id">1.8</td>

                                        <td>Total Individual Score</td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="text" class="form-control" readonly>
                                                <!-- Axial (0-10) total -->

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="text" class="form-control" readonly>
                                                <!-- Right (0-10) total -->

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="text" class="form-control" readonly>
                                                <!-- Left (0-10) total -->

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1 total-scoring">

                                        <td class="fixed-id"></td>

                                        <td>Total Scoring</td>

                                        <td colspan="3">

                                            <input type="text" class="form-control" readonly> <!-- Grand total -->

                                        </td>

                                    </tr>















                                </tbody>

                                <script>

                                    function calculateTotalsForTable(table) {

                                        let columnTotals = {}; // Store totals based on correct column index



                                        // Get all rows inside this table except "Total Individual Score" & "Total Scoring"

                                        let rows = table.querySelectorAll("tr.section-1:not(.total-individual-score):not(.total-scoring)");



                                        rows.forEach((row) => {

                                            let tds = row.querySelectorAll("td"); // Get all table columns (td)



                                            tds.forEach((td, colIndex) => {

                                                let input = td.querySelector(".slider-value"); // Find slider value input inside this column



                                                if (input) {

                                                    let value = parseFloat(input.value) || 0;



                                                    if (!columnTotals[colIndex]) {

                                                        columnTotals[colIndex] = 0;

                                                    }



                                                    columnTotals[colIndex] += value;

                                                }

                                            });

                                        });



                                        // Update "Total Individual Score" row in the correct columns

                                        let totalScoreRow = table.querySelector("tr.total-individual-score");

                                        if (totalScoreRow) {

                                            let totalInputs = totalScoreRow.querySelectorAll("td .form-control");



                                            totalInputs.forEach((input, index) => {

                                                if (columnTotals[index + 2] !== undefined) {  // Adjust index to match table structure

                                                    input.value = columnTotals[index + 2]; // Assign correct column totals

                                                } else {

                                                    input.value = ""; // Leave blank if no values exist

                                                }

                                            });

                                        }



                                        // Compute the grand total for "Total Scoring" row

                                        let grandTotal = Object.values(columnTotals).reduce((sum, num) => sum + num, 0);

                                        let totalScoringInput = table.querySelector("tr.total-scoring input.form-control");

                                        if (totalScoringInput) {

                                            totalScoringInput.value = grandTotal;

                                        }

                                    }



                                    function attachEventListeners() {

                                        document.querySelectorAll("table").forEach((table) => {

                                            table.querySelectorAll(".slider").forEach((slider) => {

                                                slider.addEventListener("input", () => calculateTotalsForTable(table));

                                            });



                                            // Run calculation on page load for each table

                                            calculateTotalsForTable(table);

                                        });

                                    }



                                    window.onload = attachEventListeners;

                                </script>







                            </table>

                        </div>



                        <!-- Case 1 Presentation: Initial Cutaneous Dermatomyositis Disease Area and Severity Index (CDASI)-->

                        <hr>






                        <!-- Activity updated table -->

                        <div class="table-container">

                            <h3>Case 1 Presentation: Initial <br> Cutaneous Dermatomyositis Disease Area and Severity

                                Index

                                (CDASI)

                            </h3>

                            <hr>

                            <span>Select the score in each anatomical location that describes the most severely

                                affected

                                dermatomyositis-associated skin lesion</span>

                            <table id="activity-table" class="table table-striped table-bordered mediaTable table-1">

                                <h2
                                    style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">

                                    Activity

                                </h2>

                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Anatomical Location</th>

                                        <th class="optional" style="width: 150px;">Erythema

                                            0 - absent



                                            1 - pink; faint erythema



                                            2 - red



                                            3 - dark red

                                        </th>

                                        <th class="optional" style="width: 200px;">Scale

                                            0 - absent



                                            1 - scale



                                            2 - crust; lichenification

                                        </th>

                                        <th>Erosion/Ulceration

                                            0 - absent



                                            1 - present</th>

                                    </tr>

                                </thead>

                                <tbody>

                                    <!-- Section 1 Subsections -->

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1</td>

                                        <td>Scalp</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="activity-radio1" value="0"> 0</label>

                                                <label><input type="radio" name="activity-radio1" value="1"> 1</label>

                                                <label><input type="radio" name="activity-radio1" value="2"> 2</label>

                                                <label><input type="radio" name="activity-radio1" value="3"> 3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="activity-radio2" value="0"> 0</label>

                                                <label><input type="radio" name="activity-radio2" value="1"> 1</label>

                                                <label><input type="radio" name="activity-radio2" value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="activity-radio3" value="0"> 0</label>

                                                <label><input type="radio" name="activity-radio3" value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2</td>

                                        <td>Malar Area</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="activity-radio4" value="0"> 0</label>

                                                <label><input type="radio" name="activity-radio4" value="1"> 1</label>

                                                <label><input type="radio" name="activity-radio4" value="2"> 2</label>

                                                <label><input type="radio" name="activity-radio4" value="3"> 3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="malar_middle_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="malar_middle_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="malar_middle_initia_cdasi" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="malar_right_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="malar_right_initia_cdasi" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">3</td>

                                        <td>Periorbital</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="Periorbital_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="Periorbital_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="Periorbital_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="Periorbital_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="Periorbital_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="Periorbital_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="Periorbital_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="Periorbital_right_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="Periorbital_right_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">4</td>

                                        <td>Rest of the Face</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restofface_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="restofface_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="restofface_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="restofface_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restofface_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="restofface_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="restofface_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restofface_right_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="restofface_right_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">5</td>

                                        <td>V-area Neck (Frontal)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="vareaneck_left_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="vareaneck_left_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="vareaneck_left_initia_cdasi" value="2">
                                                    2</label>

                                                <label><input type="radio" name="vareaneck_left_initia_cdasi" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="vareaneck_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="vareaneck_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="vareaneck_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="vareaneck_right_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="vareaneck_right_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6</td>

                                        <td>Posterior Neck</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="posterior_left_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="posterior_left_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="posterior_left_initia_cdasi" value="2">
                                                    2</label>

                                                <label><input type="radio" name="posterior_left_initia_cdasi" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="posterior_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="posterior_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="posterior_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="posterior_right_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="posterior_right_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">7</td>

                                        <td>Upper Back & Shoulders</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="upperbackshoulder_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="upperbackshoulder_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="upperbackshoulder_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="upperbackshoulder_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="upperbackshoulder_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="upperbackshoulder_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="upperbackshoulder_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="upperbackshoulder_right_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="upperbackshoulder_right_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">8</td>

                                        <td>Rest of Back & Buttocks</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restofbackbuttocks_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="restofbackbuttocks_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="restofbackbuttocks_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="restofbackbuttocks_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restofbackbuttocks_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="restofbackbuttocks_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="restofbackbuttocks_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restofbackbuttocks_ritgh_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="restofbackbuttocks_ritgh_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">9</td>

                                        <td>Abdomen</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="abdomen_left_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="abdomen_left_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="abdomen_left_initia_cdasi" value="2">
                                                    2</label>

                                                <label><input type="radio" name="abdomen_left_initia_cdasi" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="abdomen_middle_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="abdomen_middle_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="abdomen_middle_initia_cdasi" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="abdomen_right_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="abdomen_right_initia_cdasi" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">10</td>

                                        <td>Lateral Upper Thigh</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="lateralupperthigh_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="lateralupperthigh_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="lateralupperthigh_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="lateralupperthigh_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="lateralupperthigh_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="lateralupperthigh_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="lateralupperthigh_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="lateralupperthigh_right_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="lateralupperthigh_right_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">11</td>

                                        <td>Rest of Leg & Feet</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restoflegfeet_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="restoflegfeet_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="restoflegfeet_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="restoflegfeet_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restoflegfeet_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="restoflegfeet_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="restoflegfeet_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="restoflegfeet_right_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="restoflegfeet_right_initia_cdasi"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">12</td>

                                        <td>Arm</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="arm_left_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="arm_left_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="arm_left_initia_cdasi" value="2">
                                                    2</label>

                                                <label><input type="radio" name="arm_left_initia_cdasi" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="arm_middle_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="arm_middle_initia_cdasi" value="1">
                                                    1</label>

                                                <label><input type="radio" name="arm_middle_initia_cdasi" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="arm_right_initia_cdasi" value="0">
                                                    0</label>

                                                <label><input type="radio" name="arm_right_initia_cdasi" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">13</td>

                                        <td>Mechanic's Hand</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="mechanichand_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="mechanichand_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="mechanichand_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="mechanichand_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="mechanichand_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="mechanichand_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="mechanichand_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="mechanichand_right_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="mechanichand_right_initia_cdasi"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">14</td>

                                        <td>Dorsum of Hands (Not Over Joints)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dorsumofhands_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="dorsumofhands_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="dorsumofhands_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="dorsumofhands_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dorsumofhands_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="dorsumofhands_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="dorsumofhands_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dorsumofhands_right_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="dorsumofhands_right_initia_cdasi"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">15</td>

                                        <td>Gottron's - Not on Hands</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="gottronNotonHands_left_initia_cdasi"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="gottronNotonHands_left_initia_cdasi"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="gottronNotonHands_left_initia_cdasi"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="gottronNotonHands_left_initia_cdasi"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="gottronNotonHands_middle_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="gottronNotonHands_middle_initia_cdasi"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="gottronNotonHands_middle_initia_cdasi"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="gottronNotonHands_right_initia_cdasi"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="gottronNotonHands_right_initia_cdasi"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                </tbody>

                            </table>

                        </div>

                        <!-- Activity Updated Table End -->




                        <!-- Damage Updated Table Start -->

                        <div class="table-container">

                            <h3>Case 1 Presentation: Initial <br> Cutaneous Dermatomyositis Disease Area and Severity

                                Index

                                (CDASI)

                            </h3>

                            <hr>

                            <span>Select the score in each anatomical location that describes the most severely

                                affected

                                dermatomyositis-associated skin lesion</span>

                            <table id="cdasi_damage-table"
                                class="table table-striped table-bordered mediaTable table-1">

                                <h2
                                    style="background-color: red; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">

                                    Damage

                                </h2>

                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Anatomical Location</th>

                                        <th class="optional" style="width: 150px;">Calcinosis

                                            0 - absent

                                            1 - present

                                        </th>

                                        <th class="optional" style="width: 200px;">Poikiloderma (Dyspigmentation or

                                            Telangiectasia)

                                            0 - absent

                                            1 - present

                                        </th>



                                    </tr>

                                </thead>

                                <tbody>

                                    <!-- Section 1 Subsections -->

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1</td>

                                        <td>Scalp</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_scalp_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_scalp_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_scalp_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_scalp_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2</td>

                                        <td>Malar Area</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_malar_area_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_malar_area_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_malar_area_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_malar_area_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">3</td>

                                        <td>Periorbital</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Periorbital_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Periorbital_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Periorbital_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Periorbital_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">4</td>

                                        <td>Rest of the Face</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Rest_of_the_face_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Rest_of_the_face_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Rest_of_the_face_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Rest_of_the_face_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">5</td>

                                        <td>V-area Neck (Frontal)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_v_area_neck_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_v_area_neck_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_v_area_neck_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_v_area_neck_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6</td>

                                        <td>Posterior Neck</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_posterior_neck_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_posterior_neck_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_posterior_neck_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_posterior_neck_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">7</td>

                                        <td>Upper Back & Shoulders</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_upper_back_&_shoulders_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_upper_back_&_shoulders_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_upper_back_&_shoulders_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_upper_back_&_shoulders_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">8</td>

                                        <td>Rest of Back & Buttocks</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_Rest_of_back_&_shoulder_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_Rest_of_back_&_shoulder_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_Rest_of_back_&_shoulder_2" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_Rest_of_back_&_shoulder_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">9</td>

                                        <td>Abdomen</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Abdomen_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Abdomen_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Abdomen_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Abdomen_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">10</td>

                                        <td>Lateral Upper Thigh</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Lateral_upper_thigh_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Lateral_upper_thigh_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Lateral_upper_thigh_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Lateral_upper_thigh_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">11</td>

                                        <td>Rest of Leg and feet</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Rest_of_leg_and_feet_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Rest_of_leg_and_feet_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Rest_of_leg_and_feet_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Rest_of_leg_and_feet_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">12</td>

                                        <td>Arm</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Arm_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Arm_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Arm_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Arm_2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>







                                    <tr class="section-1-sub">

                                        <td class="fixed-id">13</td>

                                        <td>Mechanic's Hand</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Mechanic_hand_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Mechanic_hand_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Mechanic_hand_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Mechanic_hand_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">14</td>

                                        <td>Dorsums of hands(Not Over Joints)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Dorums_of_hands_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Dorums_of_hands_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Dorums_of_hands_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Dorums_of_hands_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">15</td>

                                        <td>Gottron's - Not on Hands

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Gottrons_not_on_hand_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Gottrons_not_on_hand_1"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Gottrons_not_on_hand_2"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Gottrons_not_on_hand_2"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                </tbody>





                            </table>

                        </div>

                        <!-- Damage Updated Table End -->



                        <br>

                        <hr>

                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #007bff;">

                            <thead>

                                <tr>

                                    <th colspan="5"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background-color: #2e4e71; color: white; font-size: 18px;">

                                        Gottron’s – Hands

                                    </th>

                                </tr>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background-color: #cce5ff; font-size: 16px;">

                                        Examine the patient’s hands and double score if papules are present

                                    </th>

                                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </th>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background-color: #cce5ff; font-size: 16px;">

                                        Examine patient’s hands and score if damage is present

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        0 - absent <br> 1 - pink; faint erythema <br> 2 - red erythema <br> 3 - dark

                                        red

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: center; background-color: #e6f7ff;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="erythema" value="0"> 0</label>

                                            <label><input type="radio" name="erythema" value="1"> 1</label>

                                            <label><input type="radio" name="erythema" value="2"> 2</label>

                                            <label><input type="radio" name="erythema" value="3"> 3</label>

                                        </div>

                                    </td>

                                    <td style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #ffe6e6;">

                                        0 - absent <br> 1 - dyspigmentation <br> 2 - scarring

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: center; background-color: #ffe6e6;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="damage" value="0"> 0</label>

                                            <label><input type="radio" name="damage" value="0"> 1</label>

                                            <label><input type="radio" name="damage" value="2"> 2</label>

                                        </div>

                                    </td>

                                </tr>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 16px; background-color: #e6f7ff;">

                                        Doubled Score:

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: center; background-color: #e6f7ff;">

                                        <input type="text" id="doubled-score" class="form-control" readonly value="0">

                                    </td>

                                </tr>

                            </tbody>

                            <script>

                                document.addEventListener("DOMContentLoaded", function () {

                                    function updateDoubledScore() {

                                        let selectedRadio = document.querySelector('input[name="erythema"]:checked');

                                        let resultField = document.getElementById("doubled-score");



                                        if (selectedRadio) {

                                            let value = parseInt(selectedRadio.value) || 0;

                                            resultField.value = value > 0 ? value * 2 : 0;

                                        }

                                    }



                                    // Attach event listeners to all "erythema" radio buttons

                                    document.querySelectorAll('input[name="erythema"]').forEach(radio => {

                                        radio.addEventListener("change", updateDoubledScore);

                                    });



                                    // Run once on page load to set the default value

                                    updateDoubledScore();

                                });

                            </script>



                        </table>

                        <br>

                        <hr>

                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #000;">

                            <thead>

                                <tr>

                                    <th colspan="3"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background: linear-gradient(90deg, #2e4e71, #4a6fa5); color: white; font-size: 18px;">

                                        Papule Present

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr style="text-align: center;">

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        Papule Present

                                    </td>

                                    <td style="border: 1px solid black; padding: 12px; background-color: #e6f7ff;">

                                        <div style="display: flex; flex-direction: column; align-items: center;">

                                            <label style="display: flex; align-items: center;">

                                                <input type="radio" name="papule_present" value="yes"
                                                    style="margin-right: 5px;"> Yes

                                            </label>

                                            <label style="display: flex; align-items: center; margin-top: 5px;">

                                                <input type="radio" name="papule_present" value="no"
                                                    style="margin-right: 9px;"> No

                                            </label>

                                        </div>

                                    </td>

                                    <td style="background-color: #4a4a4a; width: 15px; border: 1px solid black;"></td>

                                </tr>

                            </tbody>

                        </table>



                        <hr>



                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #000;">

                            <thead>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background-color: #2e4e71; color: white; font-size: 18px;">

                                        Penungual

                                    </th>

                                </tr>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background-color: #cce5ff; font-size: 16px;">

                                        Periungual changes (examine)

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        0 - absent <br>

                                        1 - pink; red erythema / microscopic

                                        telangiectasias<br>

                                        2 - visible telangiectasias

                                    </td>

                                    <td style="border: 1px solid black; padding: 12px; background-color: #e6f7ff;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="periunguals" value="0"> 0</label>

                                            <label><input type="radio" name="periunguals" value="0"> 1</label>

                                            <label><input type="radio" name="periunguals" value="2"> 2</label>

                                        </div>

                                    </td>

                                </tr>

                            </tbody>

                        </table>

                        <br>

                        <hr>

                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #000;">

                            <thead>

                                <tr>

                                    <th colspan="3"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background: linear-gradient(90deg, #2e4e71, #4a6fa5); color: white; font-size: 18px;">

                                        Alopecia

                                    </th>

                                </tr>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background: linear-gradient(90deg, #cce5ff, #a3c2e1); font-size: 16px;">

                                        Recent Hair loss (within last 30 days as reported by the patient)

                                    </th>

                                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        0 - absent <br> 1 - present

                                    </td>

                                    <td style="border: 1px solid black; padding: 12px; background-color: #e6f7ff;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="alopecias" value="0"> 0</label>

                                            <label><input type="radio" name="alopecias" value="0"> 1</label>

                                        </div>

                                    </td>

                                    <td style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </td>

                                </tr>

                            </tbody>

                        </table>



                        <br><br>

                        <table style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif;">

                            <tbody>

                                <!-- Total Activity Score Section -->

                                <tr>

                                    <td colspan="2"
                                        style="border: 2px solid #007bff; background-color: #e6f7ff; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">

                                        Total Activity Score

                                    </td>

                                </tr>


                                <tr>

                                    <td
                                        style="border: 2px solid #007bff; padding: 15px; text-align: left; font-size: 16px; background-color: #f8f9fa;">

                                        (For the activity score, please add up the scores of the left side,

                                        i.e.

                                        Erythema, Scale, Excoriation, Ulceration, Gottron’s, Periungual,

                                        Alopecia)

                                    </td>

                                    <td colspan="3" id="total-activity-score"
                                        style="border: 2px solid #007bff; background-color: #e6f7ff; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">
                                        0
                                    </td>

                                </tr>



                                <!-- Total Damage Score Section -->

                                <tr>


                                </tr>

                                <tr>

                                    <td
                                        style="border: 2px solid #dc3545; padding: 15px; text-align: left; font-size: 16px; background-color: #f8f9fa;">

                                        (For the damage score, add up the scores of the right side, i.e.

                                        Poikiloderma,

                                        Calcinosis)

                                    </td>

                                    <td colspan="3" id="total-damage-score"
                                        style="border: 2px solid red; background-color: #ffe6e6; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">
                                        0
                                    </td>


                                </tr>

                            </tbody>

                        </table>

                        <br>

                        <hr>

                        <!-- box form 0-10 -->

                        <section class="disease-activity">

                            <h2 class="title">Case 1 Presentation: Initial</h2>

                            <h2 class="subtitle">Physician Global Disease Activity</h2>

                            <p class="question"><strong>Patient’s Myositis at this time is:</strong></p>

                            <p class="instruction">(Please select a number below)</p>



                            <div class="scale-container">

                                <div class="scale">

                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num0" class="scale-radio">

                                        <label for="num0" class="scale-btn">0</label>

                                        <div class="vertical-line"></div>

                                        <span class="scale-label">No Evidence of Disease Activity</span>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num1" class="scale-radio">

                                        <label for="num1" class="scale-btn">1</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num2" class="scale-radio">

                                        <label for="num2" class="scale-btn">2</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num3" class="scale-radio">

                                        <label for="num3" class="scale-btn">3</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num4" class="scale-radio">

                                        <label for="num4" class="scale-btn">4</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num5" class="scale-radio">

                                        <label for="num5" class="scale-btn">5</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num6" class="scale-radio">

                                        <label for="num6" class="scale-btn">6</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num7" class="scale-radio">

                                        <label for="num7" class="scale-btn">7</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num8" class="scale-radio">

                                        <label for="num8" class="scale-btn">8</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num9" class="scale-radio">

                                        <label for="num9" class="scale-btn">9</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale" id="num10" class="scale-radio">

                                        <label for="num10" class="scale-btn">10</label>

                                        <div class="vertical-line"></div>

                                        <span class="scale-label">Extremely Active or Severe Disease Activity</span>

                                    </div>

                                </div>

                            </div>

                        </section>









                        <br>

                        <hr style="border:3px solid #1B3A57; color:#1B3A57">



                        <!--     Case 1 Presentation: Follow up -->

                        <div class="table-container">

                            <h5>Case 1 Presentation: Follow up</h5>

                            <hr>

                            <h5 style="font-size:15px;">Myositis Disease Activity Assessment Tool (MDAAT) <br> Answers

                                with possible correct

                                responses based on case review:

                            </h5>

                            <table class="table table-striped table-bordered mediaTable table-1">

                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Disease Activity</th>

                                        <th class="optional" style="width: 150px;">Overall Organ Disease Activity

                                            (0-10 cm) VAS

                                        </th>

                                        <th class="optional" style="width: 200px;">Clinical Features (0,1,2,3,4, NA)

                                        </th>

                                    </tr>

                                </thead>

                                <tbody>

                                    <!-- Section 1 -->
                                    <tr class="section-1">

                                        <td class="fixed-id">1</td>

                                        <td>Constitutional Disease Activity</td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    name="scoresfollowup"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control"
                                                    name="input_types[disease_activity_1]" value="0" readonly>

                                            </div>

                                        </td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1.1</td>

                                        <td>Pyrexia</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="pyrexia" value="0"> 0</label>

                                                <label><input type="radio" name="pyrexia" value="1"> 1</label>

                                                <label><input type="radio" name="pyrexia" value="2"> 2</label>

                                                <label><input type="radio" name="pyrexia" value="3"> 3</label>

                                                <label><input type="radio" name="pyrexia" value="4"> 4</label>

                                                <label><input type="radio" name="pyrexia" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1.2</td>

                                        <td>Weight Loss</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="weight_loss" value="0"> 0</label>

                                                <label><input type="radio" name="weight_loss" value="1"> 1</label>

                                                <label><input type="radio" name="weight_loss" value="2"> 2</label>

                                                <label><input type="radio" name="weight_loss" value="3"> 3</label>

                                                <label><input type="radio" name="weight_loss" value="4"> 4</label>

                                                <label><input type="radio" name="weight_loss" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1.3</td>

                                        <td>Fatigue</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="fatigue" value="0"> 0</label>

                                                <label><input type="radio" name="fatigue" value="1"> 1</label>

                                                <label><input type="radio" name="fatigue" value="2"> 2</label>

                                                <label><input type="radio" name="fatigue" value="3"> 3</label>

                                                <label><input type="radio" name="fatigue" value="4"> 4</label>

                                                <label><input type="radio" name="fatigue" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>









                                    <!-- Section 2 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">2</td>

                                        <td>Cutaneous Disease Activity</td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td></td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.1</td>

                                        <td>Cutaneous Ulceration</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cutaneous_ulceration" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cutaneous_ulceration" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cutaneous_ulceration" value="2">
                                                    2</label>

                                                <label><input type="radio" name="cutaneous_ulceration" value="3">
                                                    3</label>

                                                <label><input type="radio" name="cutaneous_ulceration" value="4">
                                                    4</label>

                                                <label><input type="radio" name="cutaneous_ulceration" value="NA">
                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.2</td>

                                        <td>Erythroderma</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="erythroderma" value="0"> 0</label>

                                                <label><input type="radio" name="erythroderma" value="1"> 1</label>

                                                <label><input type="radio" name="erythroderma" value="2"> 2</label>

                                                <label><input type="radio" name="erythroderma" value="3"> 3</label>

                                                <label><input type="radio" name="erythroderma" value="4"> 4</label>

                                                <label><input type="radio" name="erythroderma" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.3</td>

                                        <td>Panniculitis</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="panniculitis" value="0"> 0</label>

                                                <label><input type="radio" name="panniculitis" value="1"> 1</label>

                                                <label><input type="radio" name="panniculitis" value="2"> 2</label>

                                                <label><input type="radio" name="panniculitis" value="3"> 3</label>

                                                <label><input type="radio" name="panniculitis" value="4"> 4</label>

                                                <label><input type="radio" name="panniculitis" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td>2.4</td>

                                        <td>Erythematous Rash</td>

                                        <td></td>

                                        <td></td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. with secondary changes (e.g. accompanied by erosions,
                                            vesiculobullous change or necrosis)</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="erythematous_rash_a" value="0">
                                                    0</label>

                                                <label><input type="radio" name="erythematous_rash_a" value="1">
                                                    1</label>

                                                <label><input type="radio" name="erythematous_rash_a" value="2">
                                                    2</label>

                                                <label><input type="radio" name="erythematous_rash_a" value="3">
                                                    3</label>

                                                <label><input type="radio" name="erythematous_rash_a" value="4">
                                                    4</label>

                                                <label><input type="radio" name="erythematous_rash_a" value="NA">
                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. without secondary changes</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="erythematous_rash_b" value="0">
                                                    0</label>

                                                <label><input type="radio" name="erythematous_rash_b" value="1">
                                                    1</label>

                                                <label><input type="radio" name="erythematous_rash_b" value="2">
                                                    2</label>

                                                <label><input type="radio" name="erythematous_rash_b" value="3">
                                                    3</label>

                                                <label><input type="radio" name="erythematous_rash_b" value="4">
                                                    4</label>

                                                <label><input type="radio" name="erythematous_rash_b" value="NA">
                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.5</td>

                                        <td>Heliotrope rash</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="heliotrope_rash" value="0"> 0</label>

                                                <label><input type="radio" name="heliotrope_rash" value="1"> 1</label>

                                                <label><input type="radio" name="heliotrope_rash" value="2"> 2</label>

                                                <label><input type="radio" name="heliotrope_rash" value="3"> 3</label>

                                                <label><input type="radio" name="heliotrope_rash" value="4"> 4</label>

                                                <label><input type="radio" name="heliotrope_rash" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.6</td>

                                        <td>Gottron’s papules/sign</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="gottrons_papules" value="0"> 0</label>

                                                <label><input type="radio" name="gottrons_papules" value="1"> 1</label>

                                                <label><input type="radio" name="gottrons_papules" value="2"> 2</label>

                                                <label><input type="radio" name="gottrons_papules" value="3"> 3</label>

                                                <label><input type="radio" name="gottrons_papules" value="4"> 4</label>

                                                <label><input type="radio" name="gottrons_papules" value="NA">
                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.7</td>

                                        <td>Periungual capillary changes</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="periungual_capillary_changes"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="periungual_capillary_changes"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="periungual_capillary_changes"
                                                        value="2"> 2</label>

                                                <label><input type="radio" name="periungual_capillary_changes"
                                                        value="3"> 3</label>

                                                <label><input type="radio" name="periungual_capillary_changes"
                                                        value="4"> 4</label>

                                                <label><input type="radio" name="periungual_capillary_changes"
                                                        value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>2.8</strong></td>

                                        <td><strong>Alopecia</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Diffuse hair loss</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="alopecia_a" value="0"> 0</label>

                                                <label><input type="radio" name="alopecia_a" value="1"> 1</label>

                                                <label><input type="radio" name="alopecia_a" value="2"> 2</label>

                                                <label><input type="radio" name="alopecia_a" value="3"> 3</label>

                                                <label><input type="radio" name="alopecia_a" value="4"> 4</label>

                                                <label><input type="radio" name="alopecia_a" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Focal, patchy with erythema</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="alopecia_b" value="0"> 0</label>

                                                <label><input type="radio" name="alopecia_b" value="1"> 1</label>

                                                <label><input type="radio" name="alopecia_b" value="2"> 2</label>

                                                <label><input type="radio" name="alopecia_b" value="3"> 3</label>

                                                <label><input type="radio" name="alopecia_b" value="4"> 4</label>

                                                <label><input type="radio" name="alopecia_b" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2.9</td>

                                        <td>Mechanics Hand</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="mechanics_hand" value="0"> 0</label>

                                                <label><input type="radio" name="mechanics_hand" value="1"> 1</label>

                                                <label><input type="radio" name="mechanics_hand" value="2"> 2</label>

                                                <label><input type="radio" name="mechanics_hand" value="3"> 3</label>

                                                <label><input type="radio" name="mechanics_hand" value="4"> 4</label>

                                                <label><input type="radio" name="mechanics_hand" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <!-- Section 3 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">3</td>

                                        <td>Skeletal Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>





                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>3.1</strong></td>

                                        <td><strong>Erythematous Rash</strong></td>

                                        <td></td>

                                        <td></td>



                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Severe active polyarthritis</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="serveactivepolyarthritis_a" value="0">

                                                    0</label>

                                                <label><input type="radio" name="serveactivepolyarthritis_a" value="0">

                                                    1</label>

                                                <label><input type="radio" name="serveactivepolyarthritis_a" value="2">

                                                    2</label>

                                                <label><input type="radio" name="serveactivepolyarthritis_a" value="3">

                                                    3</label>

                                                <label><input type="radio" name="serveactivepolyarthritis_a" value="4">

                                                    4</label>

                                                <label><input type="radio" name="serveactivepolyarthritis_a" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Moderately active arthritis</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="moderately_active_arthritis_b" value="0">

                                                    0</label>

                                                <label><input type="radio" name="moderately_active_arthritis_b" value="0">

                                                    1</label>

                                                <label><input type="radio" name="moderately_active_arthritis_b" value="2">

                                                    2</label>

                                                <label><input type="radio" name="moderately_active_arthritis_b" value="3">

                                                    3</label>

                                                <label><input type="radio" name="moderately_active_arthritis_b" value="4">

                                                    4</label>

                                                <label><input type="radio" name="moderately_active_arthritis_b" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">C. Mild arthritis</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="mildarthritis_c" value="0">

                                                    0</label>

                                                <label><input type="radio" name="mildarthritis_c" value="0">

                                                    1</label>

                                                <label><input type="radio" name="mildarthritis_c" value="2">

                                                    2</label>

                                                <label><input type="radio" name="mildarthritis_c" value="3">

                                                    3</label>

                                                <label><input type="radio" name="mildarthritis_c" value="4">

                                                    4</label>

                                                <label><input type="radio" name="mildarthritis_c" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <tr class="section-1-sub">

                                        <td class="fixed-id">3.2</td>

                                        <td>Arthralgia </td>

                                        <td>



                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="clinical_arthra" value="0">

                                                    0</label>

                                                <label><input type="radio" name="clinical_arthra" value="0">

                                                    1</label>

                                                <label><input type="radio" name="clinical_arthra" value="2">

                                                    2</label>

                                                <label><input type="radio" name="clinical_arthra" value="3">

                                                    3</label>

                                                <label><input type="radio" name="clinical_arthra" value="4">

                                                    4</label>

                                                <label><input type="radio" name="clinical_arthra" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>







                                    <!-- Section 4 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">4</td>

                                        <td>GI Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>





                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>4.1</strong></td>

                                        <td><strong>Dysphagia</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Moderate/severe dysphagia</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dysphagia_a" value="0"> 0</label>

                                                <label><input type="radio" name="dysphagia_a" value="0"> 1</label>

                                                <label><input type="radio" name="dysphagia_a" value="2"> 2</label>

                                                <label><input type="radio" name="dysphagia_a" value="3"> 3</label>

                                                <label><input type="radio" name="dysphagia_a" value="4"> 4</label>

                                                <label><input type="radio" name="dysphagia_a" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Mild dysphagia</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dysphagia_b" value="0"> 0</label>

                                                <label><input type="radio" name="dysphagia_b" value="0"> 1</label>

                                                <label><input type="radio" name="dysphagia_b" value="2"> 2</label>

                                                <label><input type="radio" name="dysphagia_b" value="3"> 3</label>

                                                <label><input type="radio" name="dysphagia_b" value="4"> 4</label>

                                                <label><input type="radio" name="dysphagia_b" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>







                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>4.2</strong></td>

                                        <td><strong>Abdominal Pain</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Severe</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="abdominal_pain_a" value="0">

                                                    0</label>

                                                <label><input type="radio" name="abdominal_pain_a" value="0">

                                                    1</label>

                                                <label><input type="radio" name="abdominal_pain_a" value="2">

                                                    2</label>

                                                <label><input type="radio" name="abdominal_pain_a" value="3">

                                                    3</label>

                                                <label><input type="radio" name="abdominal_pain_a" value="4">

                                                    4</label>

                                                <label><input type="radio" name="abdominal_pain_a" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Moderate</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="abdominal_pain_b" value="0">

                                                    0</label>

                                                <label><input type="radio" name="abdominal_pain_b" value="0">

                                                    1</label>

                                                <label><input type="radio" name="abdominal_pain_b" value="2">

                                                    2</label>

                                                <label><input type="radio" name="abdominal_pain_b" value="3">

                                                    3</label>

                                                <label><input type="radio" name="abdominal_pain_b" value="4">

                                                    4</label>

                                                <label><input type="radio" name="abdominal_pain_b" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">C. Mild</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="abdominal_pain_c" value="0">

                                                    0</label>

                                                <label><input type="radio" name="abdominal_pain_c" value="0">

                                                    1</label>

                                                <label><input type="radio" name="abdominal_pain_c" value="2">

                                                    2</label>

                                                <label><input type="radio" name="abdominal_pain_c" value="3">

                                                    3</label>

                                                <label><input type="radio" name="abdominal_pain_c" value="4">

                                                    4</label>

                                                <label><input type="radio" name="abdominal_pain_c" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <!-- Section 5 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">5</td>

                                        <td>Pulmonary Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>5.1</strong></td>

                                        <td><strong>Resp. Muscle weakness without ILD</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Dyspnea at rest</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="resp_muscle_weakness_a" value="0">

                                                    0</label>

                                                <label><input type="radio" name="resp_muscle_weakness_a" value="0">

                                                    1</label>

                                                <label><input type="radio" name="resp_muscle_weakness_a" value="2">

                                                    2</label>

                                                <label><input type="radio" name="resp_muscle_weakness_a" value="3">

                                                    3</label>

                                                <label><input type="radio" name="resp_muscle_weakness_a" value="4">

                                                    4</label>

                                                <label><input type="radio" name="resp_muscle_weakness_a" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Dyspnea on exertion</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="resp_muscle_weakness_b" value="0">

                                                    0</label>

                                                <label><input type="radio" name="resp_muscle_weakness_b" value="0">

                                                    1</label>

                                                <label><input type="radio" name="resp_muscle_weakness_b" value="2">

                                                    2</label>

                                                <label><input type="radio" name="resp_muscle_weakness_b" value="3">

                                                    3</label>

                                                <label><input type="radio" name="resp_muscle_weakness_b" value="4">

                                                    4</label>

                                                <label><input type="radio" name="resp_muscle_weakness_b" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>5.2</strong></td>

                                        <td><strong>Active Reversible ILD</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Dyspnea or cough due to ILD</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="active_ild_a" value="0"> 0</label>

                                                <label><input type="radio" name="active_ild_a" value="0"> 1</label>

                                                <label><input type="radio" name="active_ild_a" value="2"> 2</label>

                                                <label><input type="radio" name="active_ild_a" value="3"> 3</label>

                                                <label><input type="radio" name="active_ild_a" value="4"> 4</label>

                                                <label><input type="radio" name="active_ild_a" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Parenchymal abnormalities on chest x-ray or

                                            high-resolution CT scan (HRCT) and/or ground glass shadowing on HRCT

                                        </td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="active_ild_b" value="0"> 0</label>

                                                <label><input type="radio" name="active_ild_b" value="0"> 1</label>

                                                <label><input type="radio" name="active_ild_b" value="2"> 2</label>

                                                <label><input type="radio" name="active_ild_b" value="3"> 3</label>

                                                <label><input type="radio" name="active_ild_b" value="4"> 4</label>

                                                <label><input type="radio" name="active_ild_b" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">C. Pulmonary Function Tests: ≥ 10% change in FVC OR

                                            ≥

                                            15% change in DLCO</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="active_ild_c" value="0"> 0</label>

                                                <label><input type="radio" name="active_ild_c" value="0"> 1</label>

                                                <label><input type="radio" name="active_ild_c" value="2"> 2</label>

                                                <label><input type="radio" name="active_ild_c" value="3"> 3</label>

                                                <label><input type="radio" name="active_ild_c" value="4"> 4</label>

                                                <label><input type="radio" name="active_ild_c" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>5.3</strong></td>

                                        <td><strong>Dysphonia</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Moderate to severe</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dysphonia_a" value="0"> 0</label>

                                                <label><input type="radio" name="dysphonia_a" value="0"> 1</label>

                                                <label><input type="radio" name="dysphonia_a" value="2"> 2</label>

                                                <label><input type="radio" name="dysphonia_a" value="3"> 3</label>

                                                <label><input type="radio" name="dysphonia_a" value="4"> 4</label>

                                                <label><input type="radio" name="dysphonia_a" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Mild</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="dysphonia_b" value="0"> 0</label>

                                                <label><input type="radio" name="dysphonia_b" value="0"> 1</label>

                                                <label><input type="radio" name="dysphonia_b" value="2"> 2</label>

                                                <label><input type="radio" name="dysphonia_b" value="3"> 3</label>

                                                <label><input type="radio" name="dysphonia_b" value="4"> 4</label>

                                                <label><input type="radio" name="dysphonia_b" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <!-- Section 6 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">6</td>

                                        <td>Cardiovascular Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6.1</td>

                                        <td>Pericarditis</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="clinical_features_6_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="clinical_features_6_1" value="1">
                                                    1</label>

                                                <label><input type="radio" name="clinical_features_6_1" value="2">
                                                    2</label>

                                                <label><input type="radio" name="clinical_features_6_1" value="3">
                                                    3</label>

                                                <label><input type="radio" name="clinical_features_6_1" value="4">
                                                    4</label>

                                                <label><input type="radio" name="clinical_features_6_1" value="NA">
                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6.2</td>

                                        <td>Myocarditis</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="clinical_features_6_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="clinical_features_6_2" value="1">
                                                    1</label>

                                                <label><input type="radio" name="clinical_features_6_2" value="2">
                                                    2</label>

                                                <label><input type="radio" name="clinical_features_6_2" value="3">
                                                    3</label>

                                                <label><input type="radio" name="clinical_features_6_2" value="4">
                                                    4</label>

                                                <label><input type="radio" name="clinical_features_6_2" value="NA">
                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>6.3</strong></td>

                                        <td><strong>Arrhythmias</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Severe arrhythmia</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="arrhythmia_a" value="0"> 0</label>

                                                <label><input type="radio" name="arrhythmia_a" value="0"> 1</label>

                                                <label><input type="radio" name="arrhythmia_a" value="2"> 2</label>

                                                <label><input type="radio" name="arrhythmia_a" value="3"> 3</label>

                                                <label><input type="radio" name="arrhythmia_a" value="4"> 4</label>

                                                <label><input type="radio" name="arrhythmia_a" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Other arrhythmia, except sinus tachycardia</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="arrhythmia_b" value="0"> 0</label>

                                                <label><input type="radio" name="arrhythmia_b" value="0"> 1</label>

                                                <label><input type="radio" name="arrhythmia_b" value="2"> 2</label>

                                                <label><input type="radio" name="arrhythmia_b" value="3"> 3</label>

                                                <label><input type="radio" name="arrhythmia_b" value="4"> 4</label>

                                                <label><input type="radio" name="arrhythmia_b" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>







                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6.4</td>

                                        <td>Sinus Tachycardia </td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="clinical_features_1_3" value="0">

                                                    0</label>

                                                <label><input type="radio" name="clinical_features_1_3" value="0">

                                                    1</label>

                                                <label><input type="radio" name="clinical_features_1_3" value="2">

                                                    2</label>

                                                <label><input type="radio" name="clinical_features_1_3" value="3">

                                                    3</label>

                                                <label><input type="radio" name="clinical_features_1_3" value="4">

                                                    4</label>

                                                <label><input type="radio" name="clinical_features_1_3" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <!-- Section 7 -->

                                    <tr class="section-1">

                                        <td class="fixed-id">7</td>

                                        <td>Other Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="myositis_otherdisease" value="0"> 0</label>

                                                <label><input type="radio" name="myositis_otherdisease" value="0"> 1</label>

                                                <label><input type="radio" name="myositis_otherdisease" value="2"> 2</label>

                                                <label><input type="radio" name="myositis_otherdisease" value="3"> 3</label>

                                                <label><input type="radio" name="myositis_otherdisease" value="4"> 4</label>

                                                <label><input type="radio" name="myositis_otherdisease" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <!-- Section 8 -->



                                    <tr class="section-1">

                                        <td class="fixed-id">8</td>

                                        <td>Extra Muscular Global Assessment </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>



                                    <!-- Section 9 -->



                                    <tr class="section-1">

                                        <td class="fixed-id">9</td>

                                        <td>Muscle Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>





                                    <!-- 10 -->





                                    <tr class="section-1-sub">

                                        <td class="fixed-id"><strong>10</strong></td>

                                        <td><strong>Myositis</strong></td>

                                        <td></td>

                                        <td></td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">A. Severe muscle inflammation</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="myositis_a" value="0"> 0</label>

                                                <label><input type="radio" name="myositis_a" value="0"> 1</label>

                                                <label><input type="radio" name="myositis_a" value="2"> 2</label>

                                                <label><input type="radio" name="myositis_a" value="3"> 3</label>

                                                <label><input type="radio" name="myositis_a" value="4"> 4</label>

                                                <label><input type="radio" name="myositis_a" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">B. Moderate muscle inflammation</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="myositis_b" value="0"> 0</label>

                                                <label><input type="radio" name="myositis_b" value="0"> 1</label>

                                                <label><input type="radio" name="myositis_b" value="2"> 2</label>

                                                <label><input type="radio" name="myositis_b" value="3"> 3</label>

                                                <label><input type="radio" name="myositis_b" value="4"> 4</label>

                                                <label><input type="radio" name="myositis_b" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td></td>

                                        <td class="sub-heading">C. Mild muscle inflammation</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="myositis_c" value="0"> 0</label>

                                                <label><input type="radio" name="myositis_c" value="0"> 1</label>

                                                <label><input type="radio" name="myositis_c" value="2"> 2</label>

                                                <label><input type="radio" name="myositis_c" value="3"> 3</label>

                                                <label><input type="radio" name="myositis_c" value="4"> 4</label>

                                                <label><input type="radio" name="myositis_c" value="NA"> NA</label>

                                            </div>

                                        </td>

                                    </tr>





                                    <!-- Section 11 -->



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">11</td>

                                        <td>Myalgia</td>

                                        <td></td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="clinical_Myalgia" value="0">

                                                    0</label>

                                                <label><input type="radio" name="clinical_Myalgia" value="0">

                                                    1</label>

                                                <label><input type="radio" name="clinical_Myalgia" value="2">

                                                    2</label>

                                                <label><input type="radio" name="clinical_Myalgia" value="3">

                                                    3</label>

                                                <label><input type="radio" name="clinical_Myalgia" value="4">

                                                    4</label>

                                                <label><input type="radio" name="clinical_Myalgia" value="NA">

                                                    NA</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <!-- Section 12 -->



                                    <tr class="section-1">

                                        <td class="fixed-id">12</td>

                                        <td>Global Disease Activity </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>



                                        </td>

                                    </tr>





                                </tbody>

                            </table>

                        </div>

                        <br>

                        <hr>



                        <!-- end -->

                        <!-- Case 1 Presentatoin: Follow UP -->

                        <div class="table-container">

                            <h3>

                                Case 1 Presentation: Follow up <br>

                                Manual Muscle Testing-8 (MMT-8)





                            </h3>

                            <span>

                                Answers with possible correct responses based on patient’s examination



                            </span>





                            <table class="table table-striped table-bordered mediaTable table-1">





                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Muscle Groups</th>

                                        <th class="optional" style="width: 200px;">Right (0-10)</th>

                                        <th class="optional" style="width: 200px;">Left (0-10)</th>

                                        <th class="optional" style="width: 200px;">Axial (0-10)</th>

                                    </tr>

                                </thead>

                                <tr class="section-1">

                                    <td colspan="5"
                                        style="border: none; background-color: transparent; text-align: center;">

                                        <strong>Axial Muscle</strong>

                                    </td>

                                </tr>



                                <tbody>

                                    <!-- Section 1 -->



                                    <tr class="section-1">

                                        <td class="fixed-id">1</td>

                                        <td>Neck Flexor </td>

                                        <td>

                                        </td>

                                        <td>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1">

                                        <th colspan="5" class="text-center">Proximal Muscles</th>

                                    </tr>





                                    <!-- Section 1 Subsections -->

                                    <tr class="section-1">

                                        <td class="fixed-id">1.1</td>

                                        <td>Deltoid </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>









                                    <tr class="section-1">

                                        <td class="fixed-id">1.2</td>

                                        <td>Biceps </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>



                                    <tr class="section-1">

                                        <td class="fixed-id">1.3</td>

                                        <td>Quadriceps </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.4</td>

                                        <td>Gluteus Medius </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.5</td>

                                        <td>Gluteus Maximus </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <th colspan="5" class="text-center" style="

    background-color: aliceblue;

">Distal Muscles </th>

                                    </tr>



                                    <tr class="section-1">

                                        <td class="fixed-id">1.6</td>

                                        <td>Wrist Extensor </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>





                                    <tr class="section-1">

                                        <td class="fixed-id">1.7</td>

                                        <td>Ankle Dorsiflexion</td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="slider-container">

                                                <input type="range" min="0" max="10" value="0" class="slider"
                                                    oninput="this.nextElementSibling.value = this.value">

                                                <input type="text" class="slider-value form-control" value="0" readonly>

                                            </div>

                                        </td>

                                        <td>

                                        </td>

                                    </tr>











                                    <!--<tr class="section-1">-->

                                    <!--    <th colspan="5" class="text-center">MMT-8 scoring </th>-->

                                    <!--</tr>-->

                                    <tr>

                                        <td colspan="12"
                                            style="border: 2px solid #007bff; background-color: #e6f7ff; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">

                                            MMT-8 Scoring

                                        </td>

                                    </tr>

                                    <tr class="section-1 total-score-row">

                                        <td class="fixed-id">1.9</td>

                                        <td>Total Individual Score</td>

                                        <td>

                                            <input type="text" class="form-control total-column-score" readonly>
                                            <!-- Axial (0-10) total -->

                                        </td>

                                        <td>

                                            <input type="text" class="form-control total-column-score" readonly>
                                            <!-- Right (0-10) total -->

                                        </td>

                                        <td>

                                            <input type="text" class="form-control total-column-score" readonly>
                                            <!-- Left (0-10) total -->

                                        </td>

                                    </tr>







                                    <tr class="section-1 total-scoring-row">

                                        <td class="fixed-id"></td>

                                        <td>Total Score</td>

                                        <td>

                                            <input type="text" class="form-control total-score" readonly>
                                            <!-- Grand total for this table -->

                                        </td>

                                    </tr>

                                    <script>

                                        document.addEventListener("DOMContentLoaded", function () {

                                            function updateTableTotals(table) {

                                                let columnTotals = {}; // Store column-wise totals for this specific table



                                                // Find all rows except Total Individual Score & Total Scoring rows

                                                let rows = table.querySelectorAll("tr.section-1:not(.total-score-row):not(.total-scoring-row)");



                                                rows.forEach(row => {

                                                    let tds = row.querySelectorAll("td");



                                                    tds.forEach((td, colIndex) => {

                                                        let input = td.querySelector(".slider-value"); // Get slider value input



                                                        if (input) {

                                                            let value = parseFloat(input.value) || 0;



                                                            if (!columnTotals[colIndex]) {

                                                                columnTotals[colIndex] = 0;

                                                            }



                                                            columnTotals[colIndex] += value;

                                                        }

                                                    });

                                                });



                                                // Update the "Total Individual Score" row inside this specific table

                                                let totalScoreRow = table.querySelector(".total-score-row");

                                                if (totalScoreRow) {

                                                    let totalInputs = totalScoreRow.querySelectorAll(".total-column-score");

                                                    totalInputs.forEach((input, index) => {

                                                        if (columnTotals[index + 2] !== undefined) { // +2 to match table column structure

                                                            input.value = columnTotals[index + 2];

                                                        } else {

                                                            input.value = ""; // Keep blank if no value exists

                                                        }

                                                    });

                                                }



                                                // Compute the grand total for "Total Scoring" row (sum of column totals)

                                                let grandTotal = Object.values(columnTotals).reduce((sum, num) => sum + num, 0);

                                                let totalScoringInput = table.querySelector(".total-scoring-row .total-score");

                                                if (totalScoringInput) {

                                                    totalScoringInput.value = grandTotal;

                                                }

                                            }



                                            function attachSliderListeners(table) {

                                                let sliders = table.querySelectorAll(".slider");

                                                sliders.forEach(slider => {

                                                    slider.addEventListener("input", function () {

                                                        updateTableTotals(table);

                                                    });

                                                });

                                            }



                                            // Apply to all tables uniquely

                                            document.querySelectorAll("table").forEach(table => {

                                                attachSliderListeners(table);

                                                updateTableTotals(table); // Initial calculation on page load

                                            });

                                        });

                                    </script>













                                </tbody>







                            </table>

                        </div>

                        <hr>

                        <hr>







                        <!-- Activity updated table -->

                        <div class="table-container">

                            <h3>Case 1 Presentation: Follow up <br> Cutaneous Dermatomyositis Disease Area and Severity

                                Index

                                (CDASI)

                            </h3>

                            <hr>

                            <span>Select the score in each anatomical location that describes the most severely

                                affected

                                dermatomyositis-associated skin lesion</span>

                            <table id="cdasi_follow_up_activity-table"
                                class="table table-striped table-bordered mediaTable table-1">

                                <h2
                                    style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">

                                    Activity

                                </h2>

                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Anatomical Location</th>

                                        <th class="optional" style="width: 150px;">Erythema

                                            0 - absent



                                            1 - pink; faint erythema



                                            2 - red



                                            3 - dark red

                                        </th>

                                        <th class="optional" style="width: 200px;">Scale

                                            0 - absent



                                            1 - scale



                                            2 - crust; lichenification

                                        </th>

                                        <th>Erosion/Ulceration

                                            0 - absent



                                            1 - present</th>

                                    </tr>

                                </thead>

                                <tbody>

                                    <!-- Section 1 Subsections -->

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1</td>

                                        <td>Scalp</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_scalp_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_scalp_1" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_scalp_1" value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_scalp_1" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_scalp_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_scalp_2" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_scalp_2" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_scalp_3" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_scalp_3" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2</td>

                                        <td>Malar Area</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_malar_area_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_malar_area_1" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_malar_area_1" value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_malar_area_1" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_malar_area_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_malar_area_2" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_malar_area_2" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_malar_area_3" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_malar_area_3" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">3</td>

                                        <td>Periorbital</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Periorbital_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Periorbital_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Periorbital_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Periorbital_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Periorbital_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Periorbital_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_Periorbital_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Periorbital_3"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Periorbital_3"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">4</td>

                                        <td>Rest of the Face</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_3"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_the_face_3"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">5</td>

                                        <td>V-area Neck (Frontal)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_3"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_v-neck_frontal_3"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6</td>

                                        <td>Posterior Neck</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_3"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_posterior_neck_3"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">7</td>

                                        <td>Upper Back & Shoulders</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_3"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_upper_back_&_shoulder_3"
                                                        value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">8</td>

                                        <td>Rest of Back & Buttocks</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_1" value="1">
                                                    1</label>

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_1" value="2">
                                                    2</label>

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_1" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_2" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_2" value="1">
                                                    1</label>

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_2" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_3" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_activity_Rest_of_back_&_buttocks_3" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">9</td>

                                        <td>Abdomen</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Abdomen_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Abdomen_1" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Abdomen_1" value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Abdomen_1" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Abdomen_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Abdomen_2" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Abdomen_2" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Abdomen_3" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Abdomen_3" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">10</td>

                                        <td>Lateral Upper Thigh</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_3
lateralupperfollowe1
lateralupperfollowe2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Lateral_upper_thigh_3
lateralupperfollowe1
lateralupperfollowe2" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>






                                    <tr class="section-1-sub">

                                        <td class="fixed-id">11</td>

                                        <td>Rest of Leg & Feet</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_3"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Rest_of_leg_&_feet_3"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">12</td>

                                        <td>Arm</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Arm_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Arm_1" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Arm_1" value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Arm_1" value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Arm_2" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Arm_2" value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Arm_2" value="2">
                                                    2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Arm_3" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Arm_3" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">13</td>

                                        <td>Mechanic's Hand</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_3"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Mechanic_hand_3"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">14</td>

                                        <td>Dorsum of Hands (Not Over Joints)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="ccdasi_activity_Dorsum_of_hand_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_3"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Dorsum_of_hand_3"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">15</td>

                                        <td>Gottron's - Not on Hands</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_1"
                                                        value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_1"
                                                        value="1">
                                                    1</label>

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_1"
                                                        value="2">
                                                    2</label>

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_1"
                                                        value="3">
                                                    3</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_2"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_2"
                                                        value="1"> 1</label>

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_2"
                                                        value="2"> 2</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_3"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_activity_Gottrons_not_on_hand_3"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                </tbody>

                            </table>

                        </div>

                        <!-- Activity Updated Table End -->





                        <!-- Damage Updated Table Start -->

                        <div class="table-container">

                            <h3>Case 1 Presentation: Follow up <br> Cutaneous Dermatomyositis Disease Area and Severity

                                Index

                                (CDASI)

                            </h3>

                            <hr>

                            <span>Select the score in each anatomical location that describes the most severely

                                affected

                                dermatomyositis-associated skin lesion</span>

                            <table id="cdasi_follow_up_damange-table"
                                class="table table-striped table-bordered mediaTable table-1">

                                <h2
                                    style="background-color: red; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">

                                    Damage

                                </h2>

                                <thead>

                                    <tr>

                                        <th class="optional fixed-id">S/N</th>

                                        <th class="essential persist">Anatomical Location</th>

                                        <th class="optional" style="width: 150px;">Calcinosis

                                            0 - absent

                                            1 - present

                                        </th>

                                        <th class="optional" style="width: 200px;">Poikiloderma (Dyspigmentation or

                                            Telangiectasia)

                                            0 - absent

                                            1 - present

                                        </th>



                                    </tr>

                                </thead>

                                <tbody>

                                    <!-- Section 1 Subsections -->

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">1</td>

                                        <td>Scalprr</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_scalp_left_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_scalp_left_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_scalp_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_scalp_right_1" value="1">
                                                    1</label>
                                            </div>
                                        </td>
                                    </tr>

                                    <tr class="section-1-sub">

                                        <td class="fixed-id">2</td>

                                        <td>Malar Area</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_malar_left_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_malar_left_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_malar_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_malar_right_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">3</td>

                                        <td>Periorbital</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Periorbital_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Periorbital_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Periorbital_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Periorbital_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">4</td>

                                        <td>Rest of the Face</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_restofface_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_restofface_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_restofface_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_restofface_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">5</td>

                                        <td>V-area Neck (Frontal)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_vareaneck_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_vareaneck_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_vareaneck_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_vareaneck_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">6</td>

                                        <td>Posterior Neck</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Posterior_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Posterior_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Posterior_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Posterior_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">7</td>

                                        <td>Upper Back & Shoulders</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_upperback&shoulder_left_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_upperback&shoulder_left_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_upperback&shoulder_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_upperback&shoulder_right_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">8</td>

                                        <td>Rest of Back & Buttocks</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_restofback&buttocks_left_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_restofback&buttocks_left_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_restofback&buttocks_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_restofback&buttocks_right_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">9</td>

                                        <td>Abdomen</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Abdomen_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Abdomen_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Abdomen_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Abdomen_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">10</td>

                                        <td>Lateral Upper Thigh</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Lateralupperthigh_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_Lateralupperthigh_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_Lateralupperthigh_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_Lateralupperthigh_right_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">11</td>

                                        <td>Rest of Leg & Feet</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_restofleg&feet_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_restofleg&feet_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_restofleg&feet_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_restofleg&feet_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">12</td>

                                        <td>Arm</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Arm_left_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Arm_left_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_Arm_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio" name="cdasi_damange_Arm_right_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">13</td>

                                        <td>Mechanic's Hand</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_mechanicshand_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_mechanicshand_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_mechanicshand_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_mechanicshand_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">14</td>

                                        <td>Dorsum of Hands (Not Over Joints)</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_dursumofhand_left_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_dursumofhand_left_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio" name="cdasi_damange_dursumofhand_right_1"
                                                        value="0"> 0</label>

                                                <label><input type="radio" name="cdasi_damange_dursumofhand_right_1"
                                                        value="1"> 1</label>

                                            </div>

                                        </td>

                                    </tr>



                                    <tr class="section-1-sub">

                                        <td class="fixed-id">15</td>

                                        <td>Gottron's - Not on Hands</td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_gottronsnotonhands_left_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_gottronsnotonhands_left_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                        <td>

                                            <div class="radio-container">

                                                <label><input type="radio"
                                                        name="cdasi_damange_gottronsnotonhands_right_1" value="0">
                                                    0</label>

                                                <label><input type="radio"
                                                        name="cdasi_damange_gottronsnotonhands_right_1" value="1">
                                                    1</label>

                                            </div>

                                        </td>

                                    </tr>

                                </tbody>



                            </table>

                        </div>

                        <!-- Damage Updated Table End -->



                        <br>

                        <hr>

                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #007bff;">

                            <thead>

                                <tr>

                                    <th colspan="5"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background-color: #2e4e71; color: white; font-size: 18px;">

                                        Gottron’s – Hands

                                    </th>

                                </tr>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background-color: #cce5ff; font-size: 16px;">

                                        Examine the patient’s hands and double score if papules are present

                                    </th>

                                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </th>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background-color: #cce5ff; font-size: 16px;">

                                        Examine patient’s hands and score if damage is present

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        0 - absent <br> 1 - pink; faint erythema <br> 2 - red erythema <br> 3 - dark red

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: center; background-color: #e6f7ff;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="erythema2" value="0"> 0</label>

                                            <label><input type="radio" name="erythema2" value="1"> 1</label>

                                            <label><input type="radio" name="erythema2" value="2"> 2</label>

                                            <label><input type="radio" name="erythema2" value="3"> 3</label>

                                        </div>

                                    </td>

                                    <td style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #ffe6e6;">

                                        0 - absent <br> 1 - dyspigmentation <br> 2 - scarring

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: center; background-color: #ffe6e6;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="damage2" value="0"> 0</label>

                                            <label><input type="radio" name="damage2" value="1"> 1</label>

                                            <label><input type="radio" name="damage2" value="2"> 2</label>

                                        </div>

                                    </td>

                                </tr>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 16px; background-color: #e6f7ff;">

                                        Doubled Score:

                                    </td>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: center; background-color: #e6f7ff;">

                                        <input type="text" id="doubled-score2" class="form-control" readonly value="0">

                                    </td>

                                </tr>
                                <script>
                                    document.addEventListener("DOMContentLoaded", function () {
                                
                                        function updateDoubledScore() {
                                            let selectedRadio = document.querySelector('input[name="erythema2"]:checked');
                                            let resultField = document.getElementById("doubled-score2");
                                
                                            if (selectedRadio) {
                                                let value = parseInt(selectedRadio.value) || 0;
                                                resultField.value = value > 0 ? value * 2 : 0;
                                            }
                                        }
                                
                                        // Attach event listeners to all "erythema2" radio buttons
                                        document.querySelectorAll('input[name="erythema2"]').forEach(radio => {
                                            radio.addEventListener("change", updateDoubledScore);
                                        });
                                
                                        // Run once on page load to set the default value
                                        updateDoubledScore();
                                    });
                                </script>
                                

                            </tbody>

                        </table>



                        <br>

                        <hr>





                        <!--  -->





                        <hr>





                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #000;">

                            <thead>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background-color: #2e4e71; color: white; font-size: 18px;">

                                        Penungual

                                    </th>

                                </tr>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background-color: #cce5ff; font-size: 16px;">

                                        Periungual changes (examine)

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        0 - absent <br>

                                        1 - pink; red erythema / microscopic

                                        telangiectasias <br>

                                        2 - visible telangiectasias

                                    </td>

                                    <td style="border: 1px solid black; padding: 12px; background-color: #e6f7ff;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="periungual" value="0"> 0</label>

                                            <label><input type="radio" name="periungual" value="0"> 1</label>

                                            <label><input type="radio" name="periungual" value="2"> 2</label>

                                        </div>

                                    </td>

                                </tr>

                            </tbody>

                        </table>

                        <br>

                        <hr>

                        <table
                            style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif; background-color: #f8f9fa; border: 2px solid #000;">

                            <thead>

                                <tr>

                                    <th colspan="3"
                                        style="border: 1px solid black; padding: 15px; text-align: center; background: linear-gradient(90deg, #2e4e71, #4a6fa5); color: white; font-size: 18px;">

                                        Alopecia

                                    </th>

                                </tr>

                                <tr>

                                    <th colspan="2"
                                        style="border: 1px solid black; padding: 12px; text-align: left; background: linear-gradient(90deg, #cce5ff, #a3c2e1); font-size: 16px;">

                                        Recent Hair loss (within last 30 days as reported by the patient)

                                    </th>

                                    <th style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </th>

                                </tr>

                            </thead>

                            <tbody>

                                <tr>

                                    <td
                                        style="border: 1px solid black; padding: 12px; text-align: left; font-size: 14px; background-color: #e6f7ff;">

                                        0 - absent <br> 1 - present

                                    </td>

                                    <td style="border: 1px solid black; padding: 12px; background-color: #e6f7ff;">

                                        <div class="radio-container-vertical">

                                            <label><input type="radio" name="alopecia" value="0"> 0</label>

                                            <label><input type="radio" name="alopecia" value="0"> 1</label>

                                        </div>

                                    </td>

                                    <td style="background-color: #4a4a4a; width: 15px; border: 1px solid black;">

                                    </td>

                                </tr>

                            </tbody>

                        </table>



                        <br><br>

                        <table style="width: 100%; border-collapse: collapse; font-family: Arial, sans-serif;">

                            <tbody>

                                <!-- Total Activity Score Section -->

                                <tr>

                                    <td colspan="2"
                                        style="border: 2px solid #007bff; background-color: #e6f7ff; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">

                                        Total Activity Score

                                    </td>

                                </tr>

                                <tr>

                                    <td
                                        style="border: 2px solid #007bff; padding: 15px; text-align: left; font-size: 16px; background-color: #f8f9fa;">

                                        (For the activity score, please add up the scores of the left side,

                                        i.e.

                                        Erythema, Scale, Excoriation, Ulceration, Gottron’s, Periungual,

                                        Alopecia)

                                    </td>

                                    <td colspan="3" id="total-followup-activity-score"
                                        style="border: 2px solid #28a745; background-color: #e6f7ff; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">
                                        0
                                    </td>

                                </tr>



                                <!-- Total Damage Score Section -->

                                <tr>

                                    <td colspan="2"
                                        style="border: 2px solid #dc3545; background-color: #ffe6e6; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">

                                        Total Damage Score

                                    </td>

                                </tr>

                                <tr>

                                    <td
                                        style="border: 2px solid #dc3545; padding: 15px; text-align: left; font-size: 16px; background-color: #f8f9fa;">

                                        (For the damage score, add up the scores of the right side, i.e.

                                        Poikiloderma,

                                        Calcinosis)

                                    </td>

                                    <td colspan="3" id="total-followup-damage-score"
                                        style="border: 2px solid red; background-color: #ffe6e6; padding: 15px; text-align: center; font-size: 18px; font-weight: bold; color: #000;">
                                        0
                                    </td>

                                </tr>

                            </tbody>

                        </table>

                        <br>

                        <hr>

                        <!-- box form 0-10 -->

                        <!--                        <section class="disease-activity" id="section1">-->

                        <!--    <h2 class="title">Case 1 Presentation: Initial</h2>-->

                        <!--    <h2 class="subtitle">Physician Global Disease Activity</h2>-->

                        <!--    <p class="question"><strong>Patient’s Myositis at this time is:</strong></p>-->

                        <!--    <p class="instruction">(Please select a number below)</p>-->



                        <!--    <div class="scale-container">-->

                        <!--        <div class="scale">-->

                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num0" class="scale-radio">-->

                        <!--                <label for="num0" class="scale-btn">0</label>-->

                        <!--                <div class="vertical-line"></div>-->

                        <!--                <span class="scale-label">No Evidence of Disease Activity</span>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num1" class="scale-radio">-->

                        <!--                <label for="num1" class="scale-btn">1</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num2" class="scale-radio">-->

                        <!--                <label for="num2" class="scale-btn">2</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num3" class="scale-radio">-->

                        <!--                <label for="num3" class="scale-btn">3</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num4" class="scale-radio">-->

                        <!--                <label for="num4" class="scale-btn">4</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num5" class="scale-radio">-->

                        <!--                <label for="num5" class="scale-btn">5</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num6" class="scale-radio">-->

                        <!--                <label for="num6" class="scale-btn">6</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num7" class="scale-radio">-->

                        <!--                <label for="num7" class="scale-btn">7</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num8" class="scale-radio">-->

                        <!--                <label for="num8" class="scale-btn">8</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num9" class="scale-radio">-->

                        <!--                <label for="num9" class="scale-btn">9</label>-->

                        <!--            </div>-->



                        <!--            <div class="num-container">-->

                        <!--                <input type="radio" name="scale1" id="num10" class="scale-radio">-->

                        <!--                <label for="num10" class="scale-btn">10</label>-->

                        <!--                <div class="vertical-line"></div>-->

                        <!--                <span class="scale-label">Extremely Active or Severe Disease Activity</span>-->

                        <!--            </div>-->

                        <!--        </div>-->

                        <!--    </div>-->

                        <!--</section>-->



                        <section class="disease-activity" id="section2">

                            <h2 class="title">Case 1 Presentation: Follow Up</h2>

                            <h2 class="subtitle">Physician Global Disease Activity</h2>

                            <p class="question"><strong>Patient’s Myositis at this time is:</strong></p>

                            <p class="instruction">(Please select a number below)</p>



                            <div class="scale-container">

                                <div class="scale">

                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num0b" class="scale-radio">

                                        <label for="num0b" class="scale-btn">0</label>

                                        <div class="vertical-line"></div>

                                        <span class="scale-label">No Evidence of Disease Activity</span>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num1b" class="scale-radio">

                                        <label for="num1b" class="scale-btn">1</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num2b" class="scale-radio">

                                        <label for="num2b" class="scale-btn">2</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num3b" class="scale-radio">

                                        <label for="num3b" class="scale-btn">3</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num4b" class="scale-radio">

                                        <label for="num4b" class="scale-btn">4</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num5b" class="scale-radio">

                                        <label for="num5b" class="scale-btn">5</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num6b" class="scale-radio">

                                        <label for="num6b" class="scale-btn">6</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num7b" class="scale-radio">

                                        <label for="num7b" class="scale-btn">7</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num8b" class="scale-radio">

                                        <label for="num8b" class="scale-btn">8</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num9b" class="scale-radio">

                                        <label for="num9b" class="scale-btn">9</label>

                                    </div>



                                    <div class="num-container">

                                        <input type="radio" name="scale2" id="num10b" class="scale-radio">

                                        <label for="num10b" class="scale-btn">10</label>

                                        <div class="vertical-line"></div>

                                        <span class="scale-label">Extremely Active or Severe Disease Activity</span>

                                    </div>

                                </div>

                            </div>

                        </section>



                        <!-- JavaScript to change the color -->

                        <script>

                            const radios = document.querySelectorAll('.scale-radio');



                            radios.forEach(radio => {

                                radio.addEventListener('change', function () {

                                    const parent = this.closest('.scale');

                                    const labels = parent.querySelectorAll('.scale-btn');



                                    // Reset colors

                                    labels.forEach(label => {

                                        label.style.backgroundColor = ''; // Reset all labels to default color

                                    });



                                    // Apply color to selected label

                                    if (this.checked) {

                                        this.nextElementSibling.style.backgroundColor = '#4CAF50'; // Change to green

                                    }

                                });

                            });

                        </script>
                        <script>document.addEventListener("DOMContentLoaded", function () {

                                function updateDoubledScore(section) {

                                    let selectedRadioErythema = document.querySelector(input[name = "erythema${section}"]: checked);

                                    let selectedRadioDamage = document.querySelector(input[name = "damage${section}"]: checked);

                                    let resultField = document.getElementById(doubled - score${ section });



                                    if (selectedRadioErythema) {

                                        let value = parseInt(selectedRadioErythema.value) || 0;

                                        resultField.value = value > 0 ? value * 2 : 0;

                                    }

                                }



                                // Attach event listeners to all radio buttons for Section 1 and Section 2

                                document.querySelectorAll('input[name="erythema1"], input[name="damage1"]').forEach(radio => {

                                    radio.addEventListener("change", function () { updateDoubledScore(1); });

                                });

                                document.querySelectorAll('input[name="erythema2"], input[name="damage2"]').forEach(radio => {

                                    radio.addEventListener("change", function () { updateDoubledScore(2); });

                                });



                                // Run once on page load to set the default value

                                updateDoubledScore(1);

                                updateDoubledScore(2);

                            });

                        </script>

                        <script>

                            document.querySelectorAll('.expand-btn').forEach(button => {

                                button.addEventListener('click', function () {

                                    let target = document.getElementById(this.dataset.target);

                                    target.classList.add('fullscreen');

                                    this.style.display = 'none';

                                    target.querySelector('.minimize-btn').style.display = 'inline-block';

                                });

                            });



                            document.querySelectorAll('.minimize-btn').forEach(button => {

                                button.addEventListener('click', function () {

                                    let target = document.getElementById(this.dataset.target);

                                    target.classList.remove('fullscreen');

                                    this.style.display = 'none';

                                    target.querySelector('.expand-btn').style.display = 'inline-block';

                                });

                            });

                        </script>






                        <!-- Submit Button -->

                        <section class="submit-section">

                            <div class="col-12 text-center">

                                <button class="btn btn-primary btn-lg w-100" data-toggle="modal"
                                    data-target="#successModal">

                                    Submit Now!

                                </button>

                            </div>



                            <!-- Success Modal (Bootstrap 3) -->

                            <div id="successModal" class="modal fade" tabindex="-1" role="dialog">

                                <div class="modal-dialog">

                                    <div class="modal-content">

                                        <div class="modal-header">

                                            <button type="button" class="close" data-dismiss="modal"
                                                aria-label="Close">&times;</button>

                                            <h4 class="modal-title">Submission Status</h4>

                                        </div>

                                        <div class="modal-body text-center">

                                            <p class="text-success"><strong>Successfully Submitted!</strong></p>

                                        </div>

                                        <div class="modal-footer">

                                            <button type="button" class="btn btn-default"
                                                data-dismiss="modal">Close</button>

                                        </div>

                                    </div>

                                </div>

                            </div>

                        </section>



                        </form>



                    </div>



                </div>

                <br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>

            </div>

        </div>

    </div>

</div>





@endsection