@extends('layouts.app')



@section('content') <br><br><br>



<!-- Custom CSS -->

<style>
    html,

    body {

        overflow: hidden;

        height: 100%;

        background: linear-gradient(135deg, #317c81, #a31660, #ff5f6d);

        font-family: 'Poppins', sans-serif;

    }



    .main-container {

        display: flex;

        flex-direction: column;

        gap: 15px;

        padding: 15px;

        height: 100vh;

    }



    .content-wrapper {

        display: flex;

        gap: 15px;

        flex-grow: 1;

        overflow-y: auto;

        height: calc(100vh - 100px);

        margin-top: 100px;

        margin-top: 0px !important;

        /* Removed margin to push content to the top */

        padding-top: 0px !important;

    }



    .document-container,

    .scrollable-section {

        background: #ffffff;

        padding: 12px;

        border-radius: 10px;

        box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);

        flex: 1;

        overflow-y: auto;

        height: 100%;

        transition: all 0.3s ease-in-out;

        position: relative;



    }



    .document-container .header-bar,

    .scrollable-section .header-bar {

        position: sticky;

        top: 0;

        background: linear-gradient(135deg, #1B1F24, #2A4B7C);



        z-index: 10;

        padding: 10px 15px;

        display: flex;

        justify-content: space-between;

        align-items: center;

        border-radius: 8px 8px 0 0;

    }



    .header-bar h4 {

        margin: 0;

        font-weight: 600;

        font-size: 18px;

        color: white;

    }



    .scrollable {

        overflow-y: auto;

        height: calc(100% - 50px);

    }



    .fullscreen {

        position: fixed;

        top: 0;

        left: 0;

        width: 100%;

        height: 100%;

        z-index: 10000;

        background: #ffffff;

        box-shadow: 0px 6px 20px rgba(0, 0, 0, 0.3);

    }



    .horizontal-list {

        list-style-type: none;

        padding: 0;

        display: flex;

        flex-wrap: wrap;

    }



    .horizontal-list li {

        margin-right: 20px;

        font-size: 14px;



    }
</style>



<div class="main-container">





    <div class="content-wrapper">

        <div class="document-container" id="docViewer">

            <div class="header-bar">

                <h4><i class="fa fa-file-alt"></i> {{$document->title}} </h4>

                <div>

                    <a href="{{ route('user.downloadDocument', $document->id) }}" class="btn btn-success btn-custom">

                        <i class="fa fa-download"></i> Download

                    </a>

                    <button class="btn btn-primary btn-custom expand-btn" data-target="docViewer">

                        <i class="fa fa-expand"></i> Expand

                    </button>

                    <button class="btn btn-danger btn-custom minimize-btn" data-target="docViewer"
                        style="display: none;">

                        <i class="fa fa-compress"></i> Minimize

                    </button>

                </div>

            </div>

            <div class="scrollable" id="docViewerScroll">

                @if(isset($htmlContent))

                <div class="word-content">

                    {!! $htmlContent !!}

                </div>

                @elseif(isset($document->file_path))

                <iframe src="{{ asset($document->file_path) }}" width="100%" height="600px"></iframe>

                @else

                <p class="alert alert-warning">No content available.</p>

                @endif

            </div>





        </div>



        <div class="scrollable-section" id="caseScoringSheet">

            <div class="header-bar" style=" background: linear-gradient(135deg, #1B1F24, #2A4B7C)" ;>

                <h4><i class=" fa fa-bars"></i> Myositis Case Scoring Sheet</h4>

                <div>

                    <button class="btn btn-primary btn-custom expand-btn" data-target="caseScoringSheet">

                        <i class="fa fa-expand"></i> Expand

                    </button>

                    <button class="btn btn-danger btn-custom minimize-btn" data-target="caseScoringSheet"
                        style="display: none;">

                        <i class="fa fa-compress"></i> Minimize

                    </button>

                </div>

            </div>

            <div class="scrollable" id="caseScoringSheetScroll">



                <div class="row">

                    <div class="col-sm-12 col-lg-12">

                        <div class="heading clearfix">

                            <div class="row header-container">

                                <div class="col-sm-4 col-md-4">

                                    <label class="header-label">Investigator Name:</label>

                                    <input class="input-sm form-control header-input"
                                        value="{{ auth()->user()->username }}" type="text" readonly>

                                </div>



                                <div class="col-sm-4 col-md-4">

                                    <label class="header-label">Case No:</label>

                                    <input class="input-sm form-control header-input" value="{{ $case_no }}" type="text"
                                        readonly>

                                </div>



                                <div class="col-sm-4 col-md-4">

                                    <label class="header-label">Date:</label>

                                    <input class="input-sm form-control header-input"
                                        value="{{ \Carbon\Carbon::now()->format('m/d/Y') }}" type="text" readonly>

                                </div>



                            </div>

                        </div>





                        <input type="hidden" name="case_no" value="{{ $case_no }}">

                        @include('doctors.forms.form1Mdaat')
                        <br>
                        <hr>
                        @include('doctors.forms.form2MMT8')
                        <hr>
                        @include('doctors.forms.form3CDASI')
                        <hr>
                        @include('doctors.forms.form4CDASIDamange')
                        <br>

                        <hr>
                        @include('doctors.forms.form5')
                        <br>
                        @include('doctors.forms.form6PGDA')

                        <br>

                        <hr style="border:3px solid #1B3A57; color:#1B3A57">

                        <!--     Case 1 Presentation: Follow up -->

                        @include('doctors.forms.form7MdaatFollowUp')

                        <br>

                        <hr>
                        <!-- end -->

                        <!-- Case 1 Presentatoin: Follow UP -->

                      @include('doctors.forms.form8MMT8FollowUp')

                        <hr>

                        <hr>

                        <!-- Activity updated table -->

                      @include('doctors.forms.form9CDASIActivity')
                        <!-- Activity Updated Table End -->

                        <!-- Damage Updated Table Start -->

                      @include('doctors.forms.form10CDASIDamage')
                        <!-- Damage Updated Table End -->

                        @include('doctors.forms.form11')
                       
                        @include('doctors.forms.form12PGDA')


                        <!-- JavaScript to change the color -->

                        <script>

                            const radios = document.querySelectorAll('.scale-radio');



                            radios.forEach(radio => {

                                radio.addEventListener('change', function () {

                                    const parent = this.closest('.scale');

                                    const labels = parent.querySelectorAll('.scale-btn');



                                    // Reset colors

                                    labels.forEach(label => {

                                        label.style.backgroundColor = ''; // Reset all labels to default color

                                    });



                                    // Apply color to selected label

                                    if (this.checked) {

                                        this.nextElementSibling.style.backgroundColor = '#4CAF50'; // Change to green

                                    }

                                });

                            });

                        </script>


                        <!-- Submit Button -->

                        <section class="submit-section">

                            <div class="col-12 text-center">

                                <button class="btn btn-primary btn-lg w-100" data-toggle="modal"
                                    data-target="#successModal">

                                    Submit Now!

                                </button>

                            </div>

 

                        </section>



                        </form>



                    </div>



                </div>

                <br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br><br>

            </div>

        </div>

    </div>

</div>



<script>document.addEventListener("DOMContentLoaded", function () {

        function updateDoubledScore(section) {

            let selectedRadioErythema = document.querySelector(`input[name="erythema${section}"]:checked`);

            let selectedRadioDamage = document.querySelector(`input[name="damage${section}"]:checked`);

            let resultField = document.getElementById(`doubled-score${section}`);



            if (selectedRadioErythema) {

                let value = parseInt(selectedRadioErythema.value) || 0;

                resultField.value = value > 0 ? value * 2 : 0;

            }

        }



        // Attach event listeners to all radio buttons for Section 1 and Section 2

        document.querySelectorAll('input[name="erythema1"], input[name="damage1"]').forEach(radio => {

            radio.addEventListener("change", function () { updateDoubledScore(1); });

        });

        document.querySelectorAll('input[name="erythema2"], input[name="damage2"]').forEach(radio => {

            radio.addEventListener("change", function () { updateDoubledScore(2); });

        });



        // Run once on page load to set the default value

        updateDoubledScore(1);

        updateDoubledScore(2);

    });

</script>

<script>

    document.querySelectorAll('.expand-btn').forEach(button => {

        button.addEventListener('click', function () {

            let target = document.getElementById(this.dataset.target);

            target.classList.add('fullscreen');

            this.style.display = 'none';

            target.querySelector('.minimize-btn').style.display = 'inline-block';

        });

    });



    document.querySelectorAll('.minimize-btn').forEach(button => {

        button.addEventListener('click', function () {

            let target = document.getElementById(this.dataset.target);

            target.classList.remove('fullscreen');

            this.style.display = 'none';

            target.querySelector('.expand-btn').style.display = 'inline-block';

        });

    });

</script>


@endsection