@extends('layouts.app')

@section('content') <br><br><br>

<!-- Custom CSS -->
<style>
    

    .container {
        max-width: 850px;
        margin: auto;
        padding: 20px;
        background: white;
        border-radius: 8px;
        box-shadow: 0px 4px 12px rgba(0, 0, 0, 0.1);
    }

    .header-bar {
        background: #1f4e78;
        padding: 10px;
        color: white;
        font-weight: bold;
        border-radius: 8px 8px 0 0;
        text-align: center;
        font-size: 20px;
    }

    .input-label {
        font-weight: bold;
        font-size: 14px;
        margin-bottom: 5px;
    }

    .editable-input {
        width: 100%;
        border: 1px solid #ccc;
        padding: 6px;
        text-align: center;
        border-radius: 5px;
        font-size: 14px;
    }

    .small-input {
        max-width: 120px;
    }

    .table-container {
        overflow-x: auto;
        max-height: 500px;
        overflow-y: auto;
    }

    .table thead th {
        background-color: #1f4e78;
        color: white;
        text-align: center;
        vertical-align: middle;
        padding: 8px;
    }

    .section-title {
        background: #2c3e50;
        color: white;
        text-align: center;
        font-weight: bold;
    }

    .dark-row {
        background-color: #2c3e50;
        color: white;
        text-align: center;
    }

    .sub-text {
        font-size: 12px;
        font-style: italic;
        text-align: left;
        padding-left: 15px;
    }

</style>

<div class="container">
    <!-- Header -->
    <div class="header-bar">MYOSITIS CASE SCORING SHEET</div>

    <div class="row mt-3">
        <div class="col-sm-6">
            <label class="input-label">Investigator Name:</label>
            <input type="text" class="editable-input" value="{{ $user->name }}">
        </div>
        <div class="col-sm-3">
            <label class="input-label">CASE Number:</label>
            <input type="text" class="editable-input small-input" value="1" readonly>
        </div>
        <div class="col-sm-3">
            <label class="input-label">Date:</label>
            <input type="date" class="editable-input small-input" value="{{ $currentDate }}">
        </div>
    </div>

    <h5 class="text-center mt-3">Case 1 Presentation: Initial</h5>
    <p class="text-center">Myositis Disease Activity Assessment Tool (MDAAT)</p>

    <div class="table-container">
        <!-- Table -->
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th style="color: black">#</th>
                    <th style="color: black">Disease Activity</th>
                    <th style="color: black">Overall Organ Disease Activity VAS (0-10)</th>
                    <th style="color: black">Clinical Features (0,1,2,3,4, NA)</th>
                </tr>
            </thead>
            <tbody>
                <!-- Section: Constitutional Disease Activity -->
                <tr>
                    <td class="section-title">1.</td>
                    <td class="section-title">Constitutional Disease Activity</td>
                    <td > <input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>1.1</td>
                    <td>Pyrexia</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>1.2</td>
                    <td>Weight loss</td>
                    <td  class="dark-row"> </td>
                    <td><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>1.3</td>
                    <td>Fatigue</td>
                    <td class="dark-row"></td>
                    <td><input type="text" class="editable-input"></td>
                </tr>

                <!-- Section: Cutaneous Disease Activity -->
                <tr>
                    <td class="section-title">2.</td>
                    <td class="section-title">Cutaneous Disease Activity</td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>2.1</td>
                    <td>Cutaneous Ulceration</td>
                    <td class="dark-row"></td>
                    <td><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>2.2</td>
                    <td>Erythroderma</td>
                    <td  class="dark-row"> </td>
                    <td><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>2.3</td>
                    <td>Panniculitis</td>
                    <td class="dark-row"></td>
                    <td><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>2.4</td>
                    <td>
                        Erythematous Rash
                        <div class="sub-text">a. with secondary changes (e.g. accompanied by erosions, vesiculobullous change or necrosis)</div>
                        <div class="sub-text">b. without secondary changes</div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                    </td>
                </tr>
                <tr>
                    <td>2.5</td>
                    <td>Heliotrope rash</td>
                    <td class="dark-row"></td>
                    <td  ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>2.6</td>
                    <td>Gottron’s papules/sign</td>
                    <td class="dark-row"></td>
                    <td  ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>2.7</td>
                    <td>Periungual capillary changes</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>2.8</td>
                    <td>
                        Alopecia
                        <div class="sub-text">a. Diffuse hair loss</div>
                        <div class="sub-text">b. Focal, patchy with erythema</div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                    </td>
                </tr>
                <tr>
                    <td>2.9</td>
                    <td>Mechanics Hand</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td class="section-title">3.</td>
                    <td class="section-title">Skeletal Disease Activity</td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>

                <tr>
                    <td>3.1</td>
                    <td>
                    	Arthritis
                        <div class="sub-text">a.	Severe active polyarthritis </div>
                        <div class="sub-text">b.	Moderately active arthritis </div>
                        <div class="sub-text">c.	Mild arthritis </div>

                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                        <div class="sub-text">c. <input type="text" class="editable-input"></div>

                    </td>

                </tr>
                <tr>
                    <td>3.2</td>
                    <td>	Arthralgia</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td class="section-title">4.</td>
                    <td class="section-title"> Git Disease Activity</td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>4.1</td>
                    <td>
                    Dysphagia
                        <div class="sub-text">a.	Moderate/severe dysphagia  </div>
                        <div class="sub-text">b.	Mild dysphagia </div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                    </td>
                </tr>
                <tr>
                    <td>4.2</td>
                    <td>
                    Abdominal Pain
                        <div class="sub-text">a.	Severe  </div>
                        <div class="sub-text">b.	Moderate </div>
                        <div class="sub-text">c.	Mild  </div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                        <div class="sub-text">c. <input type="text" class="editable-input"></div>
                    </td>
                </tr>
                <tr>
                    <td class="section-title">5.</td>
                    <td class="section-title">Pulmonary Disease Activity</td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>

                <tr>
                    <td>5.1</td>
                    <td>
                    Resp. Muscle weakness without ILD                       
                     <div class="sub-text">a.	Dyspnea at rest </div>
                        <div class="sub-text">b.	Dyspnea on exertion </div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                    </td>
                </tr>
                <tr>
                    <td>5.2</td>
                    <td>
                    Active Reversible ILD
                        <div class="sub-text">a.	Dyspnea or cough due to ILD  </div>
                        <div class="sub-text">b.	Parenchymal abnormalities on chest x-ray or high-resolution CT scan (HRCT) and/or ground glass shadowing on HRCT  </div>
                        <div class="sub-text">c.	Pulmonary Function Tests: ≥ 10% change in FVC OR ≥ 15% change in DLCO </div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                        <div class="sub-text">c. <input type="text" class="editable-input"></div>
                    </td>
                </tr>


                   <tr>
                    <td>5.3</td>
                    <td>
                    	Dysphonia                     
                     <div class="sub-text">a.	Moderate to severe  </div>
                        <div class="sub-text">b.	Mild</div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                    </td>
                </tr>

                <tr>
                    <td class="section-title">6.</td>
                    <td class="section-title">Cardiovascular Disease Activity</td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>

                <tr>
                    <td>6.1</td>
                    <td>	Pericarditis</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>
                <tr>
                    <td>6.2</td>
                    <td>	Myocarditis</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>

                
                <tr>
                    <td>6.3</td>
                    <td>
                    Arrhythmias                     
                     <div class="sub-text">a.	Severe arrhythmia  </div>
                        <div class="sub-text">b.	Other arrhythmia, except sinus tachycardia </div>
                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                    </td>
                </tr>

                <tr>
                    <td>6.4</td>
                    <td>		Sinus Tachycardia</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>

                <tr>
                    <td class="section-title">7.</td>
                    <td class="section-title">Other Disease Activity </td>
                    <td><input type="text" class="editable-input" placeholder="(Specify_______________)"></td>
                    <td ><input type="text" class="editable-input" placeholder="Specify"></td>
                </tr>

                <tr>
                    <td class="section-title">8.</td>
                    <td class="section-title">Extra Muscular Global Assessment </td>
                    <td><input type="text" class="editable-input" ></td>
                    <td class="dark-row"> </td>
                </tr>

                <tr>
                    <td class="section-title">8.</td>
                    <td class="section-title">Muscle Disease Activity</td>
                    <td><input type="text" class="editable-input" ></td>
                    <td class="dark-row"> </td>
                </tr>


                <tr>
                    <td>9</td>
                    <td>
                    	Myositis                     
                     <div class="sub-text">a.	Severe muscle inflammation   </div>
                        <div class="sub-text">b.	Moderate muscle inflammation </div>
                        <div class="sub-text">c.	Mild muscle inflammation</div>

                    </td>
                    <td class="dark-row"></td>
                    <td>
                        <div class="sub-text">a. <input type="text" class="editable-input"></div>
                        <div class="sub-text">b. <input type="text" class="editable-input"></div>
                        <div class="sub-text">c. <input type="text" class="editable-input"></div>

                    </td>
                </tr>

                <tr>
                    <td>10</td>
                    <td>	Myalgia</td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>


                <tr>
                    <td class="section-title">11.</td>
                    <td class="section-title">Global Disease Activity</td>
                    <td><input type="text" class="editable-input" ></td>
                    <td class="dark-row"> </td>
                </tr>





            </tbody>
            
        </table>
        
        <h5 class="text-center mt-3">            Case 1 Presentation: Follow up
Manual Muscle Testing-8 (MMT-8) 
</h5>
                <p class="text-center">Answers with possible correct responses based on patient’s examination</p>

               
        <!-- Table -->
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th style="color: black">Muscle Groups</th>
                    <th style="color: black">Right (0-10)</th>
                    <th style="color: black">Left (0-10)</th>
                    <th style="color: black">Axial (0-10)</th>
                </tr>
            </thead>
            <tbody>
                <!-- Section: Axial Muscle -->
                <tr>
                    <td class="section-title" colspan="4">Axial Muscle</td>
                </tr>
                <tr>
                    <td>Neck Flexor</td>
                    <td class="dark-row"></td>
                    <td class="dark-row"></td>
                    <td ><input type="text" class="editable-input"></td>
                </tr>

                <!-- Section: Proximal Muscles -->
                <tr>
                    <td class="section-title" colspan="4">Proximal Muscles</td>
                </tr>
                <tr>
                    <td>Deltoid</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>Biceps</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>Quadriceps</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>Gluteus Medius</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>Gluteus Maximus</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>

                <!-- Section: Distal Muscles -->
                <tr>
                    <td class="section-title" colspan="4">Distal Muscles</td>
                </tr>
                <tr>
                    <td>Wrist Extensor</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>Ankle Dorsiflexion</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>

                <!-- Section: MMT-8 scoring -->
                <tr>
                    <td class="section-title" colspan="4">MMT-8 scoring</td>
                </tr>
                <tr>
                    <td>Total Individual Score</td>
                    <td><input type="text" class="editable-input"></td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                </tr>
                <tr>
                    <td>Total Score*</td>
                    <td><input type="text" class="editable-input"></td>
                    <td class="dark-row"></td>
                    <td class="dark-row"></td>
                </tr>

                <!-- Maximum Score Section -->
                <tr>
                    <td rowspan="2">Maximum Possible Score</td>
                    <td colspan="3">
                        <input type="checkbox" class="check-box"> 150 (when all above muscles are assessed)
                    </td>
                </tr>
                <tr>
                    <td colspan="3">
                        <input type="checkbox" class="check-box"> Other than 150 <br>
                        Maximum Score: <input type="text" class="editable-input small-input">
                        <br>
                        Reason: <input type="text" class="editable-input">
                    </td>
                </tr>

            </tbody>
        </table>
        <!-- Notes Section Below the Table -->
<div class="mt-4 p-3 bg-light border rounded">
    <strong>Note:</strong> Use Kendall (0-10 scale) for scoring MMT-8
    <br>
    <strong>@ Total individual score:</strong> Sum total of each side separately (right, left, axial)
    <br>
    <strong>*Total score:</strong> Sum of right + left + axial
    <br><br>
    <strong>Maximum possible score:</strong> Maximum possible score in MMT-8 is <strong>150</strong> if all muscles are assessed on a 0-10 scale. If any individual muscle is not assessed for any reason such as joint replacement, severe arthritis, or muscle injury, etc., mark <em>“not able to evaluate”</em> and in that case, the total possible score might be lower. Please indicate the lower score and the reason on the form.
    <br><br>
    <strong>Order of muscle testing (anti-gravity):</strong> Deltoid, Biceps, Wrist extensor, Quadriceps, Ankle Dorsiflexion, Neck flexors, Gluteus Medius, Gluteus Maximus.
</div>






<hr>




<h5 class="text-center mt-3">Case 1 Presentation: Initial Cutaneous Dermatomyositis Disease Area and Severity Index (CDASI) 

</h5>
                <p class="text-center">Select the score in each anatomical location that describes the most severely affected dermatomyositis-associated skin lesion</p>


                <div class="table-responsive">
    <table class="table table-bordered">
        <thead>
            <tr>
                <th colspan="5" class="text-center" style="background: #dcdcdc; font-weight: bold;">Activity</th>
                <th rowspan="17" class="divider"></th> <!-- BOLD VERTICAL LINE -->
                <th colspan="2" class="text-center" style="background: #dcdcdc; font-weight: bold;">Damage</th>
            </tr>
            <tr>
                <!-- Activity Headers -->
                <th class="bold-header">Anatomical Location</th>
                <th class="bold-header">Erythema</th>
                <th class="bold-header">Scale</th>
                <th class="bold-header">Erosion/Ulceration</th>
                <th class="bold-header">Poikiloderma (Dyschromia or Telangiectasia)</th>
                <!-- Damage Headers -->
                <th class="bold-header">Calcinosis</th>
                <th class="bold-header">Anatomical Location</th>
            </tr>
        </thead>
        <tbody>
            <!-- Row 1 -->
            <tr>
                <td class="bold-header">Scalp</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Scalp</td>
            </tr>

            <!-- Row 2 -->
            <tr>
                <td class="bold-header">Malar Area</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Malar Area</td>
            </tr>

            <!-- Row 3 -->
            <tr>
                <td class="bold-header">Periorbital</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Periorbital</td>
            </tr>

            <!-- Row 4 -->
            <tr>
                <td class="bold-header">Rest of the face</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Rest of the face</td>
            </tr>

            <!-- Row 5 -->
            <tr>
                <td class="bold-header">V-area neck (frontal)</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">V-area neck (frontal)</td>
            </tr>

            <!-- Row 6 -->
            <tr>
                <td class="bold-header">Posterior Neck</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Posterior Neck</td>
            </tr>

            <!-- Row 7 -->
            <tr>
                <td class="bold-header">Upper Back & Shoulders</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Upper Back & Shoulders</td>
            </tr>

            <!-- Row 8 -->
            <tr>
                <td class="bold-header">Rest of Back & Buttocks</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Rest of Back & Buttocks</td>
            </tr>

            <!-- Row 9 -->
            <tr>
                <td class="bold-header">Abdomen</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Abdomen</td>
            </tr>

            <!-- Row 10 -->
            <tr>
                <td class="bold-header">Lateral Upper Thigh</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Lateral Upper Thigh</td>
            </tr>

            <!-- Row 11 -->
            <tr>
                <td class="bold-header">Rest of Leg & Feet</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Rest of Leg & Feet</td>
            </tr>

            <!-- Row 12 -->
            <tr>
                <td class="bold-header">Arm</td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="dark-row"></td>
                <td><input type="text" class="editable-input"></td>
                <td><input type="text" class="editable-input"></td>
                <td class="bold-header">Arm</td>
            </tr>

        </tbody>
    </table>
</div>

 



                

    </div>
</div>

@endsection
