@extends('layouts.app')

@section('content')
<br><br><br>

<div class="container">
    @if(session('success'))
        <div class="alert alert-success alert-dismissible fade in text-center">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong><i class="glyphicon glyphicon-ok-circle"></i> Success! </strong> {{ session('success') }}
        </div>
    @endif

    <h2 class="text-primary text-center"><i class="glyphicon glyphicon-user"></i> User Management</h2>

    <div class="panel panel-default shadow-box">
        <div class="panel-heading">
            <h4 class="panel-title"><i class="glyphicon glyphicon-th-list"></i> All Users</h4>
        </div>
        <div class="panel-body">
            <table class="table table-bordered custom-table">
                <thead>
                    <tr class="table-header">
                        <th>#</th>
                        <th>Username</th>
                        <th>Email</th>
                        <th>Registered On </th>
                        <th>Status</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $key => $user)
                        <tr>
                            <td>{{ $key + 1 }}</td>
                            <td>{{ $user->username }}</td>
                            <td>{{ $user->email }}</td>
                            <td>{{ \Carbon\Carbon::parse($user->created_at)->setTimezone('America/New_York')->format('m/d/Y h:i A') }}</td> 
                            <td>
                                @if($user->is_active)
                                    <span class="label label-success">Active</span>
                                @else
                                    <span class="label label-danger">Inactive</span>
                                @endif
                            </td>
                            <td class="text-center">
                                <form action="{{ route('users.toggleStatus', $user->id) }}" method="POST" style="display:inline;">
                                    @csrf
                                    <button type="submit" class="btn btn-sm {{ $user->is_active ? 'btn-warning' : 'btn-success' }}">
                                        <i class="glyphicon glyphicon-refresh"></i> {{ $user->is_active ? 'Deactivate' : 'Activate' }}
                                    </button>
                                </form>
                                <button class="btn btn-danger btn-sm delete-btn" data-id="{{ $user->id }}">
                                    <i class="glyphicon glyphicon-trash"></i>
                                </button>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            {{ $users->links() }}
        </div>
    </div>
</div>

<!-- Delete Confirmation Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="glyphicon glyphicon-exclamation-sign"></i> Confirm Deletion</h4>
            </div>
            <div class="modal-body text-center">
                Are you sure you want to delete this user?
            </div>
            <div class="modal-footer">
                <form id="deleteForm" method="POST">
                    @csrf @method('DELETE')
                    <button type="submit" class="btn btn-danger">Delete</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function() {
    $('.delete-btn').click(function() {
        var userId = $(this).data('id');
        $('#deleteForm').attr('action', '/users/' + userId);
        $('#deleteModal').modal('show');
    });
});
</script>

@endsection
