<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\PasswordController;
use App\Http\Controllers\AdminController;
use App\Http\Controllers\UserController;
use App\Http\Controllers\ForgotPasswordController;
use App\Http\Controllers\DocumentController;
use App\Http\Controllers\ScorningController;
use App\Http\Controllers\ScoringSheetController;
use App\Http\Controllers\CaseScoreController;
use App\Http\Controllers\FormDraftController;
use App\Http\Controllers\User\FormSubmissionController;
use App\Http\Controllers\Admin\ViewSubmissionController;

  
 // routes/web.php

use Illuminate\Support\Facades\Mail;

Route::get('/mail-test', function () {
    Mail::raw('Testing SMTP from GurukoolHub', function ($message) {
        $message->to('work.sartaj@gmail.com') // ✅ change to your real email
                ->subject('Test Email from GurukoolHub');
    });

    return '✅ Test email sent!';
});


 
// ===================== PUBLIC ROUTES (Login, Register, Forgot Password) =====================

// Registration Routes
Route::get('/register', [AuthController::class, 'showRegisterForm'])->name('register');
Route::post('/register', [AuthController::class, 'register']);

// Login Routes
Route::get('/', [AuthController::class, 'showLoginForm'])->name('login');
Route::post('/', [AuthController::class, 'login']);

// Forgot Password Routes (For users who forgot their password)
 

Route::get('forgot-password', [ForgotPasswordController::class, 'showForgotPasswordForm'])->name('password.request');
Route::post('forgot-password', [ForgotPasswordController::class, 'sendResetLink'])->name('password.email');

Route::get('reset-password/{token}', [ForgotPasswordController::class, 'showResetPasswordForm'])->name('password.reset');
Route::post('reset-password', [ForgotPasswordController::class, 'updatePassword'])->name('password.update');


// ===================== AUTHENTICATED ROUTES =====================
Route::middleware(['auth'])->group(function () {

    /** ===================== ADMIN ROUTES ===================== **/
    Route::middleware(['admin'])->group(function () {
        Route::get('/admin/dashboard', [AdminController::class, 'dashboard'])->name('admin.dashboard');
    
        // Document Management
        Route::get('/admin/upload', [DocumentController::class, 'create'])->name('documents.create');
        Route::post('/admin/upload', [DocumentController::class, 'store'])->name('documents.store');
        Route::get('/admin/documents/{document}/assign', [DocumentController::class, 'assignForm'])->name('documents.assignForm');
        Route::post('/admin/documents/{document}/assign', [DocumentController::class, 'assign'])->name('documents.assign');
        Route::post('/admin/documents/unassign/{document}/{user}', [DocumentController::class, 'unassign'])->name('documents.unassign');
        Route::get('/admin/documents', [DocumentController::class, 'index'])->name('documents.list');
        Route::get('/admin/documents/assign', [DocumentController::class, 'assignPage'])->name('documents.assignPage');
        Route::get('/edit/{document}', [DocumentController::class, 'edit'])->name('documents.edit');
        Route::put('/update/{document}', [DocumentController::class, 'update'])->name('documents.update');
        Route::delete('/documents/{id}', [DocumentController::class, 'destroy'])->name('documents.destroy');
        Route::get('/admin/documents/{document}/view', [DocumentController::class, 'view'])->name('documents.view');
    
        // User Management
        Route::get('/admin/usershow', [UserController::class, 'show'])->name('admin.usershow');
        Route::get('/admin/user/edit/{id}', [UserController::class, 'edit'])->name('admin.user.edit');
        Route::delete('/admin/user/delete/{id}', [UserController::class, 'destroy'])->name('admin.user.delete');
    
        Route::get('/admin/assigned-cases', [DocumentController::class, 'assignedCases'])->name('admin.assigned_cases');
        Route::post('/documents/unassignUser', [DocumentController::class, 'unassignUser'])->name('documents.unassignUser');
    
        // Doctor Form Submission (if kept)
        Route::post('/doctor/form1-mdaat/save', [Form1MdaatController::class, 'save'])->name('doctor.form1mdaat.save');
    
        // Admin: Manage All Users
        Route::get('/users', [UserController::class, 'index'])->name('users.index');
        Route::post('/users/toggle-status/{id}', [UserController::class, 'toggleStatus'])->name('users.toggleStatus');
        Route::delete('/users/{id}', [UserController::class, 'destroy'])->name('users.destroy');
 
    
        // ✅ Admin: Submitted Case Scores (Grouped with Tab-based UI)
        Route::prefix('admin')->middleware(['admin'])->group(function () {
            Route::get('/submissions', [App\Http\Controllers\Admin\FormSubmissionController::class, 'index'])->name('admin.index');
            Route::get('/admin/view-submission/{case_id}/{user_id}', [ViewSubmissionController::class, 'show'])->name('admin.view.submission');
            Route::get('/admin/download/{case_id}/{user_id}', [App\Http\Controllers\Admin\FormSubmissionController::class, 'downloadUserPdf'])->name('admin.download');

        });
        
        
        
    });
    

    /** ===================== USER (DOCTOR) ROUTES ===================== **/
    Route::middleware(['user'])->group(function () {
        Route::get('/user/dashboard', [UserController::class, 'dashboard'])->name('user.dashboard');
        Route::get('/user/my-cases', [UserController::class, 'myCases'])->name('user.myCases');  
        Route::get('/user/document/{document}/view', [UserController::class, 'viewDocument'])->name('user.viewDocument');
        Route::get('/user/document/{document}/download', [UserController::class, 'downloadDocument'])->name('user.downloadDocument');

        Route::get('/user/scorning', [ScorningController::class, 'create'])->name('user.scorning.create');
        Route::get('/user/scorning1', [ScorningController::class, 'create1'])->name('user.scorning.create1');

        route::post('scoringheet/store' , [ScoringSheetController::class , 'store'])->name('scoringSheet.store');

        Route::post('/save-scores', [CaseScoreController::class, 'saveScores'])->middleware('auth');
        Route::get('/load-scores/{case_no}', [CaseScoreController::class, 'loadScores'])->middleware('auth');
        
        //Scoring store
        Route::post('/scoring-sheet/store', [ScoringSheetController::class , 'store'])->name('scoring.sheet.store');


        Route::post('/save-section', [CasePresentationInitialMdaatController::class, 'saveSection']);
        Route::get('/fetch-data', [CasePresentationInitialMdaatController::class, 'fetchData']);
        Route::post('/submit-all', [CasePresentationInitialMdaatController::class, 'submitAllData']);

        Route::get('/profile', [UserController::class, 'profile'])->name('user.profile');


        //Form Drafts
        Route::post('/save-form-data', [FormDraftController::class, 'save'])->name('save.form.data');
        Route::post('/submit-all-forms', [FormDraftController::class, 'submitAll'])->name('submit.all.forms');
        
        Route::post('/submit-all-forms', [FormSubmissionController::class, 'submitAllForms'])->name('submit.all.forms')->middleware('auth');


    });

    /** ===================== COMMON AUTHENTICATED ROUTES ===================== **/
    Route::get('/change-password', [PasswordController::class, 'showChangePasswordForm'])->name('password.change');
    Route::post('/change-password', [PasswordController::class, 'updatePassword'])->name('password.update.user');

    // Logout Route (Common for Admin & User)
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});