 

<?php $__env->startSection('content'); ?>
<!-- Custom CSS -->
<style>
* {
    font-family: 'Poppins', sans-serif;
}

html,
body {
    height: 100%;
    margin: 0;
    padding: 0;
    background: linear-gradient(135deg, #317c81, #a31660, #ff5f6d);
    font-family: 'Poppins', sans-serif;
}

.alltext {
    font-size: 16px;
    font-weight: bold;
    color: #000000;
}

.main-container {
    display: flex;
    flex-direction: column;
    gap: 15px;
    padding: 15px;
    height: calc(100vh - 70px); /* Adjusted for header/footer */
    margin-top: 50px;
}

.content-wrapper {
    display: flex;
    gap: 15px;
    flex-grow: 1;
    overflow: hidden;
    height: 100%;
}

.document-container,
.scrollable-section {
    background: #ffffff;
    padding: 12px;
    border-radius: 10px;
    box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.2);
    flex: 1;
    overflow: hidden;
    display: flex;
    flex-direction: column;
    transition: all 0.3s ease-in-out;
    position: relative;
}

.document-container .header-bar,
.scrollable-section .header-bar {
    position: sticky;
    top: 0;
    background: linear-gradient(135deg, #1B1F24, #2A4B7C);
    z-index: 10;
    padding: 10px 15px;
    display: flex;
    justify-content: space-between;
    align-items: center;
    border-radius: 8px 8px 0 0;
}

.header-bar h4 {
    margin: 0;
    font-weight: 600;
    font-size: 18px;
    color: white;
}

.scrollable {
    overflow-y: auto;
    flex-grow: 1;
    padding: 10px;
}

/* Custom Scrollbar Styling */
.scrollable::-webkit-scrollbar {
    width: 10px;
    height: 10px;
}

.scrollable::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 5px;
}

.scrollable::-webkit-scrollbar-thumb {
    background: #888;
    border-radius: 5px;
}

.scrollable::-webkit-scrollbar-thumb:hover {
    background: #555;
}

.fullscreen {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    z-index: 10000;
    background: #ffffff;
    box-shadow: 0px 6px 20px rgba(0, 0, 0, 0.3);
}

.horizontal-list {
    list-style-type: none;
    padding: 0;
    display: flex;
    flex-wrap: wrap;
}

.horizontal-list li {
    margin-right: 20px;
    font-size: 14px;
}

.header-container {
    margin-bottom: 15px;
}

.header-label {
    font-weight: bold;
    margin-bottom: 5px;
    display: block;
}

.header-input {
    background-color: #f8f9fa;
    border: 1px solid #ced4da;
}

.word-content {
    padding: 15px;
}

.word-content img {
    max-width: 100%;
    height: auto;
}

.btn-custom {
    margin-left: 5px;
    padding: 5px 10px;
    font-size: 14px;
}

/* Adjust footer position */
.footer {
    position: relative;
    bottom: 0;
    width: 100%;
}
</style>

<div class="main-container">
    <div class="content-wrapper">
        <div class="document-container" id="docViewer">
            <div class="header-bar">
                <h4><i class="fa fa-file-alt"></i> <?php echo e($document->title ?? 'Case Document'); ?></h4>
                <div>
                    <a href="<?php echo e(route('documents.view', $document->id)); ?>" class="btn btn-success btn-custom">
                        <i class="fa fa-download"></i> Download
                    </a>
                    <button class="btn btn-primary btn-custom expand-btn" data-target="docViewer">
                        <i class="fa fa-expand"></i> Expand
                    </button>
                    <button class="btn btn-danger btn-custom minimize-btn" data-target="docViewer" style="display: none;">
                        <i class="fa fa-compress"></i> Minimize
                    </button>
                </div>
            </div>
            <div class="scrollable" id="docViewerScroll">
                <?php if(isset($htmlContent)): ?>
                    <div class="word-content"><?php echo $htmlContent; ?></div>
                <?php elseif(isset($document->file_path)): ?>
                    <iframe src="<?php echo e(asset('storage/' . $document->file_path)); ?>" width="100%" height="100%" style="border: none;"></iframe>
                <?php else: ?>
                    <p class="alert alert-warning">No content available.</p>
                <?php endif; ?>
            </div>
        </div>

        <div class="scrollable-section" id="caseScoringSheet">
            <div class="header-bar">
                <h4><i class="fa fa-bars"></i> Myositis Case Scoring Sheet</h4>
                <div>
                    <button class="btn btn-primary btn-custom expand-btn" data-target="caseScoringSheet">
                        <i class="fa fa-expand"></i> Expand
                    </button>
                    <button class="btn btn-danger btn-custom minimize-btn" data-target="caseScoringSheet" style="display: none;">
                        <i class="fa fa-compress"></i> Minimize
                    </button>
                </div>
            </div>
            <div class="scrollable" id="caseScoringSheetScroll">
                <div class="row">
                    <div class="col-sm-12 col-lg-12">
                        <div class="heading clearfix">
                            <div class="row header-container">
                                <div class="col-sm-4 col-md-4">
                                    <label class="header-label">Investigator Name:</label>
                                    <input class="input-sm form-control header-input" value="<?php echo e($user->username ?? $user->name ?? 'N/A'); ?>" type="text" readonly>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <label class="header-label">Case No:</label>
                                    <input class="input-sm form-control header-input" value="<?php echo e($case_no); ?>" type="text" readonly>
                                </div>
                                <div class="col-sm-4 col-md-4">
                                    <label class="header-label">Date:</label>
                                    <input class="input-sm form-control header-input" value="<?php echo e(\Carbon\Carbon::now()->format('m/d/Y')); ?>" type="text" readonly>
                                </div>
                            </div>
                        </div>

                        <input type="hidden" name="case_no" value="<?php echo e($case_no); ?>">

                       
                        <?php echo $__env->make('admin.forms.form2mmt8Readonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form3CDASIReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form4CDASIDamangeReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form5Readonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form1MdaatReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form6PGDAReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

                        <br>
                        <hr style="border:3px solid #1B3A57; color:#1B3A57">

                       
                        <?php echo $__env->make('admin.forms.form8FollowUpMMT8Readonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form9CDASIActivityReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form10CDASIDamageReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form11Readonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form7MdaatFollowUpReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php echo $__env->make('admin.forms.form12PGDAReadonly', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
document.querySelectorAll('.expand-btn').forEach(button => {
    button.addEventListener('click', function () {
        let target = document.getElementById(this.dataset.target);
        target.classList.add('fullscreen');
        this.style.display = 'none';
        target.querySelector('.minimize-btn').style.display = 'inline-block';
        // Recalculate scrollable height
        target.querySelector('.scrollable').style.height = 'calc(100% - 50px)';
    });
});

document.querySelectorAll('.minimize-btn').forEach(button => {
    button.addEventListener('click', function () {
        let target = document.getElementById(this.dataset.target);
        target.classList.remove('fullscreen');
        this.style.display = 'none';
        target.querySelector('.expand-btn').style.display = 'inline-block';
        // Reset scrollable height
        target.querySelector('.scrollable').style.height = '';
    });
});

// Adjust iframe height when content loads
document.addEventListener('DOMContentLoaded', function() {
    const iframe = document.querySelector('iframe');
    if (iframe) {
        iframe.onload = function() {
            this.style.height = this.contentWindow.document.body.scrollHeight + 'px';
        };
    }
});
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/submissions/show.blade.php ENDPATH**/ ?>