<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Case Report - <?php echo e($case_no); ?></title>
    <style>
        body {
            font-family: 'Arial', sans-serif;
            line-height: 1.4;
            font-size: 12px;
            margin: 0;
            padding: 15px;
        }

        .header-container {
            display: flex;
            justify-content: space-between;
            margin-bottom: 20px;
            background-color: #f5f5f5;
            padding: 10px;
            border-radius: 5px;
            border: 1px solid #ddd;
        }

        .header-item {
            flex: 1;
            text-align: left;
        }

        .header-label {
            font-weight: bold;
            display: inline-block;
            margin-right: 5px;
            color: #2A4B7C;
        }

        .header-value {
            font-size: 13px;
            display: inline-block;
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
            font-size: 11px;
        }

        table,
        th,
        td {
            border: 1px solid #ddd;
        }

        th,
        td {
            padding: 6px;
            text-align: left;
        }

        th {
            background-color: #f2f2f2;
            font-weight: bold;
        }

        .page-break {
            page-break-after: always;
        }

        .form-title {
            background-color: #2A4B7C;
            color: white;
            padding: 8px;
            margin: 20px 0 10px 0;
            font-size: 14px;
            border-radius: 4px;
        }

        .sub-heading {
            font-weight: bold;
            font-style: italic;
        }

        .value-cell {
            background-color: #f9f9f9;
            font-weight: bold;
        }
    </style>
</head>

<body>
    <!-- Header Section -->
    <div class="header-container">
        <div class="header-item">
            <span class="header-label">Investigator Name:</span>
            <span class="header-value"><?php echo e($submittedBy ?? 'N/A'); ?></span>
        </div>
        <div class="header-item">
            <span class="header-label">Case No:</span>
            <span class="header-value"><?php echo e($case_no); ?></span>
        </div>
        <div class="header-item">
            <span class="header-label">Date:</span>
            <span class="header-value"><?php echo e($currentDate); ?></span>
        </div>
    </div>

    
    <!-- Form 2: MMT8 -->
    <?php if($document->form2Mmt8Data): ?>
    <?php
$form2Data = json_decode(optional($form2)->form_data, true);
$form2 = $form2Data['scores'] ?? [];
?>

    <div class="form-section">
        <div class="form-title">Form 2: MMT8 (Manual Muscle Testing)</div>

        <table>
            <thead>
                <tr>
                   
                    <th width="45%">Muscle Groups</th>
                    <th width="15%">Right (0-10)</th>
                    <th width="15%">Left (0-10)</th>
                    <th width="15%">Axial (0-10)</th>
                </tr>
            </thead>
            <tbody>
                <!-- Axial Muscle Section -->
                <tr>
                    <td colspan="5" class="section-header">Axial Muscle</td>
                </tr>
                <tr>
                    
                    <td>Neck Flexor</td>
                    <td class="value-cell"><?php echo e($form2['neck_flexor_axial'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['neck_flexor_axial'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['neck_flexor_axial'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Proximal Muscles Section -->
                <tr>
                    <td colspan="5" class="section-header">Proximal Muscles</td>
                </tr>
                <tr>
                  
                    <td>Deltoid</td>
                    <td class="value-cell"><?php echo e($form2['deltoid_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['deltoid_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    
                    <td>Biceps</td>
                    <td class="value-cell"><?php echo e($form2['biceps_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['biceps_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                   
                    <td>Quadriceps</td>
                    <td class="value-cell"><?php echo e($form2['quadriceps_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['quadriceps_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                   
                    <td>Gluteus Medius</td>
                    <td class="value-cell"><?php echo e($form2['gluteus_medius_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['gluteus_medius_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                   
                    <td>Gluteus Maximus</td>
                    <td class="value-cell"><?php echo e($form2['gluteus_maximus_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['gluteus_maximus_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>

                <!-- Distal Muscles Section -->
                <tr>
                    <td colspan="5" class="section-header">Distal Muscles</td>
                </tr>
                <tr>
                  
                    <td>Wrist Extensor</td>
                    <td class="value-cell"><?php echo e($form2['wrist_extensor_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['wrist_extensor_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                
                    <td>Ankle Dorsiflexion</td>
                    <td class="value-cell"><?php echo e($form2['ankle_dorsiflexion_right'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form2['ankle_dorsiflexion_left'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>

                <tr>
    <th colspan="5" class="text-center" style="background-color: aliceblue;">MMT-8 Scoring</th>
</tr>

<tr class="total-scoring-value">
    <td>Total Score</td>
    <td colspan="3">
        <input type="text" class="form-control" readonly
               value="<?php echo e($form2['total_scoring_value'] ?? 'N/A'); ?>">
    </td>
</tr>

<tr class="maximum-scoring">
    <td>Total Maximum Possible Score</td>
    <td>
        <div class="slider-container">
            <input type="text" class="form-control" readonly
                   value="<?php echo e($form2['max_scoring_right'] ?? 'N/A'); ?>">
        </div>
    </td>
    <td>
        <div class="slider-container">
            <input type="text" class="form-control" readonly
                   value="<?php echo e($form2['max_scoring_left'] ?? 'N/A'); ?>">
        </div>
    </td>
    <td>
        <div class="slider-container">
            <input type="text" class="form-control" readonly
                   value="<?php echo e($form2['max_scoring_axial'] ?? 'N/A'); ?>">
        </div>
    </td>
</tr>

<tr class="total-scoring-value">
    <td>Maximum Score</td>
    <td colspan="3">
        <input type="text" class="form-control" readonly
               value="<?php echo e($form2['maximum_score'] ?? 'N/A'); ?>">
    </td>
</tr>

<tr class="total-individual-score">
    <td>Maximum Individual Score</td>
    <td>
        <div class="slider-container">
            <input type="text" class="form-control" readonly
                   value="<?php echo e($form2['total_individual_right'] ?? 'N/A'); ?>">
        </div>
    </td>
    <td>
        <div class="slider-container">
            <input type="text" class="form-control" readonly
                   value="<?php echo e($form2['total_individual_left'] ?? 'N/A'); ?>">
        </div>
    </td>
    <td>
        <div class="slider-container">
            <input type="text" class="form-control" readonly
                   value="<?php echo e($form2['total_individual_axial'] ?? 'N/A'); ?>">
        </div>
    </td>
</tr>

               
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>

    <!-- Form 3: CDASI -->
   <?php if($form3): ?>
    <?php
    $form3Data = json_decode(optional($form3)->form_data, true);
    $form3 = $form3Data['scores'] ?? [];
    ?>

    <div class="form-section">
        <div class="form-title">Form 3: CDASI (Cutaneous Dermatomyositis Disease Area and Severity Index)</div>

        <div
            style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center; margin-bottom: 15px;">
            CDASI Activity
        </div>

        <table>
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="40%">Anatomical Location</th>
                    <th width="20%">Erythema</th>
                    <th width="20%">Scale</th>
                    <th width="15%">Erosion/Ulceration</th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - absent<br>
                        1 - pink; faint erythema<br>
                        2 - red<br>
                        3 - dark red
                    </th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - absent<br>
                        1 - scale<br>
                        2 - crust; lichenification
                    </th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - absent<br>
                        1 - present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>Scalp</td>
                    <td class="value-cell"><?php echo e($form3['activity-radio1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['activity-radio2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['activity-radio3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Malar Area</td>
                    <td class="value-cell"><?php echo e($form3['activity-radio4'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['malar_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['malar_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>Periorbital</td>
                    <td class="value-cell"><?php echo e($form3['Periorbital_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['Periorbital_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['Periorbital_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>Rest of the Face</td>
                    <td class="value-cell"><?php echo e($form3['restofface_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['restofface_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['restofface_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>5</td>
                    <td>V-area Neck (Frontal)</td>
                    <td class="value-cell"><?php echo e($form3['vareaneck_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['vareaneck_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['vareaneck_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6</td>
                    <td>Posterior Neck</td>
                    <td class="value-cell"><?php echo e($form3['posterior_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['posterior_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['posterior_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>7</td>
                    <td>Upper Back & Shoulders</td>
                    <td class="value-cell"><?php echo e($form3['upperbackshoulder_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['upperbackshoulder_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['upperbackshoulder_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>8</td>
                    <td>Rest of Back & Buttocks</td>
                    <td class="value-cell"><?php echo e($form3['restofbackbuttocks_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['restofbackbuttocks_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['restofbackbuttocks_ritgh_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>9</td>
                    <td>Abdomen</td>
                    <td class="value-cell"><?php echo e($form3['abdomen_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['abdomen_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['abdomen_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>10</td>
                    <td>Lateral Upper Thigh</td>
                    <td class="value-cell"><?php echo e($form3['lateralupperthigh_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['lateralupperthigh_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['lateralupperthigh_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>11</td>
                    <td>Rest of Leg & Feet</td>
                    <td class="value-cell"><?php echo e($form3['restoflegfeet_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['restoflegfeet_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['restoflegfeet_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>12</td>
                    <td>Arm</td>
                    <td class="value-cell"><?php echo e($form3['arm_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['arm_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['arm_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>13</td>
                    <td>Mechanic's Hand</td>
                    <td class="value-cell"><?php echo e($form3['mechanichand_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['mechanichand_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['mechanichand_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>14</td>
                    <td>Dorsum of Hands (Not Over Joints)</td>
                    <td class="value-cell"><?php echo e($form3['dorsumofhands_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['dorsumofhands_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['dorsumofhands_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>15</td>
                    <td>Gottron's - Not on Hands</td>
                    <td class="value-cell"><?php echo e($form3['gottronNotonHands_left_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['gottronNotonHands_middle_initia_cdasi'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form3['gottronNotonHands_right_initia_cdasi'] ?? 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
    <!-- Form 4: CDASI Damage -->
   <?php if($form4): ?>
    <?php
    $form4Data = json_decode(optional($form4)->form_data, true);
    $form4 = $form4Data['scores'] ?? [];
    ?>


    <div class="form-section">
        <div class="form-title">Form 4: CDASI Damage (Cutaneous Dermatomyositis Disease Area and Severity Index)</div>

        <div
            style="background-color: #e71f1f; color: white; padding: 12px; border-radius: 5px; border: 2px solid #fe0000; text-align: center; margin-bottom: 15px;">
            CDASI Damage
        </div>

        <table>
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="50%">Anatomical Location</th>
                    <th width="20%">Calcinosis</th>
                    <th width="20%">Poikiloderma</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>Scalp</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_scalp_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_scalp_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Malar Area</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_malar_area_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_malar_area_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>Periorbital</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Periorbital_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Periorbital_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>Rest of the Face</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Rest_of_the_face_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Rest_of_the_face_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>5</td>
                    <td>V-area Neck (Frontal)</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_v_area_neck_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_v_area_neck_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6</td>
                    <td>Posterior Neck</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_posterior_neck_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_posterior_neck_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>7</td>
                    <td>Upper Back & Shoulders</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_upper_back_shoulders_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_upper_back_shoulders_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>8</td>
                    <td>Rest of Back & Buttocks</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Rest_of_back_shoulder_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Rest_of_back_shoulder_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>9</td>
                    <td>Abdomen</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Abdomen_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Abdomen_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>10</td>
                    <td>Lateral Upper Thigh</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Lateral_upper_thigh_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Lateral_upper_thigh_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>11</td>
                    <td>Rest of Leg and feet</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Rest_of_leg_and_feet_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Rest_of_leg_and_feet_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>12</td>
                    <td>Arm</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Arm_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Arm_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>13</td>
                    <td>Mechanic's Hand</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Mechanic_hand_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Mechanic_hand_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>14</td>
                    <td>Dorsums of hands (Not Over Joints)</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Dorums_of_hands_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Dorums_of_hands_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>15</td>
                    <td>Gottron's - Not on Hands</td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Gottrons_not_on_hand_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form4['cdasi_damange_Gottrons_not_on_hand_2'] ?? 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
    <!-- Form 5: Gottron's, Periungual, Alopecia -->
  <?php if($form5): ?>
    <?php
    $form5Data = json_decode(optional($form5)->form_data, true);
    $form5 = $form5Data['scores'] ?? [];

    $erythema = $form5['erythema'] ?? 'N/A';
    $damage = $form5['damage'] ?? 'N/A';
    $papulePresent = $form5['papule_present'] ?? 'N/A';
    $periunguals = $form5['periunguals'] ?? 'N/A';
    $alopecias = $form5['alopecias'] ?? 'N/A';
    ?>


    <div class="form-section">
        <div class="form-title">Form 5: Gottron's, Periungual, Alopecia Assessment</div>

        <!-- Gottron's Hands Section -->
        <table style="margin-bottom: 20px;">
            <thead>
                <tr>
                    <th colspan="5"
                        style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                        Gottron's - Hands
                    </th>
                </tr>
                <tr>
                    <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                        Examine the patient's hands and double score if papules are present
                    </th>
                    <th style="background-color: #f5f5f5; width: 10px;"></th>
                    <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                        Examine patient's hands and score if damage is present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="padding: 8px; font-size: 12px; width: 35%;">
                        0 - absent<br>1 - pink; faint erythema<br>2 - red erythema<br>3 - dark red
                    </td>
                    <td class="value-cell" style="width: 15%;"><?php echo e($erythema); ?></td>
                    <td style="background-color: #f5f5f5;"></td>
                    <td style="padding: 8px; font-size: 12px; width: 35%;">
                        0 - absent<br>1 - dyspigmentation<br>2 - scarring
                    </td>
                    <td class="value-cell" style="width: 15%;"><?php echo e($damage); ?></td>
                </tr>
                <tr style="background-color: #f8f1e9;">
                    <td style="padding: 8px; font-weight: bold;">Papule Present</td>
                    <td class="value-cell"><?php echo e($papulePresent); ?></td>
                    <td colspan="3" style="background-color: #f5f5f5;"></td>
                </tr>
            </tbody>
        </table>

        <!-- Periungual Section -->
        <table style="margin-bottom: 20px;">
            <thead>
                <tr>
                    <th colspan="2"
                        style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                        Periungual
                    </th>
                </tr>
                <tr>
                    <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                        Periungual changes (examine)
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="padding: 8px; font-size: 12px; width: 85%;">
                        0 - absent<br>1 - pink/red erythema / microscopic telangiectasias<br>2 - visible telangiectasias
                    </td>
                    <td class="value-cell" style="width: 15%;"><?php echo e($periunguals); ?></td>
                </tr>
            </tbody>
        </table>

        <!-- Alopecia Section -->
        <table style="margin-bottom: 20px;">
            <thead>
                <tr>
                    <th colspan="2"
                        style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                        Alopecia
                    </th>
                </tr>
                <tr>
                    <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                        Recent Hair loss (within last 30 days as reported by the patient)
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td style="padding: 8px; font-size: 12px; width: 85%;">
                        0 - absent<br>1 - present
                    </td>
                    <td class="value-cell" style="width: 15%;"><?php echo e($alopecias); ?></td>
                </tr>
            </tbody>
        </table>

        <table>
    <tbody>
        <!-- Total Activity Score Header -->
        <tr>
            <td colspan="2"
                style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px; font-weight: bold;">
                Total Activity Score
            </td>
        </tr>
        <!-- Activity Description + Value -->
        <tr>
            <td style="padding: 10px; font-size: 13px; width: 85%;">
                (For the activity score, please add up the scores of the left side, i.e. Erythema, Scale,
                Excoriation, Ulceration, Gottron's, Periungual, Alopecia)
            </td>
            <td class="value-cell" style="width: 15%; font-weight: bold; background-color: #e6f7ff;">
                <?php echo e($form5['total_activity_score'] ?? 'N/A'); ?>

            </td>
        </tr>

        <!-- Total Damage Score Header -->
        <tr>
            <td colspan="2"
                style="background-color: #dc3545; color: white; padding: 10px; text-align: center; font-size: 16px; font-weight: bold;">
                Total Damage Score
            </td>
        </tr>
        <!-- Damage Description + Value -->
        <tr>
            <td style="padding: 10px; font-size: 13px;">
                (For the damage score, add up the scores of the right side, i.e. Poikiloderma, Calcinosis)
            </td>
            <td class="value-cell" style="font-weight: bold; background-color: #ffe6e6;">
                <?php echo e($form5['total_damage_score'] ?? 'N/A'); ?>

            </td>
        </tr>
    </tbody>
</table>

    </div>
    <div class="page-break"></div>
    <?php endif; ?>

    <!-- Form 1: MDAAT -->
   <?php if($form1): ?>
    <?php
    $form1Data = json_decode(optional($form1)->form_data, true);
    $form1 = $form1Data['scores'] ?? [];
    ?>
 


    <div class="form-section">
        <div class="form-title">Form 1: MDAAT (Myositis Disease Activity Assessment Tool)</div>

        <table>
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="45%">Disease Activity</th>
                    <th width="15%">VAS</th>
                    <th width="35%">Clinical Features</th>
                </tr>
            </thead>
            <tbody>
                <!-- Constitutional Disease Activity -->
                <tr>
                    <td>1</td>
                    <td>Constitutional Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['disease_activity_1'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td>1.1</td>
                    <td>Pyrexia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_1_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>1.2</td>
                    <td>Weight Loss</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_1_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>1.3</td>
                    <td>Fatigue</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_1_3'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Cutaneous Disease Activity -->
                <tr>
                    <td>2</td>
                    <td>Cutaneous Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['disease_activity_2'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td>2.1</td>
                    <td>Cutaneous Ulceration</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_2_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.2</td>
                    <td>Erythroderma</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_2_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.3</td>
                    <td>Panniculitis</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_2_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.4</td>
                    <td>Erythematous Rash</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. with secondary changes</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['erythematous_rash_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. without secondary changes</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['erythematous_rash_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.5</td>
                    <td>Heliotrope rash</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_2_5'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.6</td>
                    <td>Gottron's papules/sign</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_2_6'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.7</td>
                    <td>Periungual capillary changes</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_2_7'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.8</td>
                    <td>Alopecia</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Diffuse hair Loss</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['alopecia_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Focal, Patchy with Erythema</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['alopecia_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2.9</td>
                    <td>Mechanics Hand</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['mechanics_hand'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Skeletal Disease Activity -->
                <tr>
                    <td>3</td>
                    <td>Skeletal Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['disease_activity_3'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td>3.1</td>
                    <td>Arthritis</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Severe active polyarthritis</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['polyarthritis_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Moderately active arthritis</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['moderately_active_arthritis_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">C. Mild arthritis</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['milarth_c'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>3.2</td>
                    <td>Arthralgia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['arthralgia'] ?? 'N/A'); ?></td>
                </tr>

                <!-- GI Disease Activity -->
                <tr>
                    <td>4</td>
                    <td>GI Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['disease_activity_4'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td>4.1</td>
                    <td>Dysphagia</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Moderate/severe dysphagia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['dysphagia_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Mild dysphagia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['dysphagia_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>4.2</td>
                    <td>Abdominal Pain</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Severe</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['abdominal_pain_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Moderate</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['abdominal_pain_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">C. Mild</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['abdominal_pain_c'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Pulmonary Disease Activity -->
                <tr>
                    <td>5</td>
                    <td>Pulmonary Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['disease_activity_5'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td>5.1</td>
                    <td>Resp. Muscle weakness without ILD</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Dyspnea at rest</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['resp_muscle_weakness_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Dyspnea on exertion</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['resp_muscle_weakness_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>5.2</td>
                    <td>Active Reversible ILD</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Dyspnea or cough due to ILD</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['active_ild_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Parenchymal abnormalities</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['active_ild_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">C. Pulmonary Function Tests</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['active_ild_c'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>5.3</td>
                    <td>Dysphonia</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Moderate to severe</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['dysphonia_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Mild</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['dysphonia_b'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Cardiovascular Disease Activity -->
                <tr>
                    <td>6</td>
                    <td>Cardiovascular Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['cardiovascular_disease_activity'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    <td>6.1</td>
                    <td>Pericarditis</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_6_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6.2</td>
                    <td>Myocarditis</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['clinical_features_6_2'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6.3</td>
                    <td>Arrhythmias</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Severe arrhythmia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['arrhythmia_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Other arrhythmia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['arrhythmia_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6.4</td>
                    <td>Sinus Tachycardia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['sinus_tachycardia'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Other Disease Activity -->
                <tr>
                    <td>7</td>
                    <td>
                        Other Disease Activity<br>
                        <span class="sub-heading"><?php echo e($form1['other_disease_activity_note'] ?? 'N/A'); ?></span>
                    </td>
                    <td class="value-cell"><?php echo e($form1['other_disease_activity_slider'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form1['other_disease_activity_radio'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Extra Muscular Global Assessment -->
                <tr>
                    <td>8</td>
                    <td>Extra Muscular Global Assessment</td>
                    <td class="value-cell"><?php echo e($form1['extra_muscular_global_assessment'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>

                <!-- Muscle Disease Activity -->
                <tr>
                    <td>9</td>
                    <td>Muscle Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['muscle_disease_activity'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>

                <!-- Myositis -->
                <tr>
                    <td>10</td>
                    <td>Myositis</td>
                    <td></td>
                    <td></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">A. Severe muscle inflammation</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['myositis_a'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">B. Moderate muscle inflammation</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['myositis_b'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td></td>
                    <td class="sub-heading">C. Mild muscle inflammation</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['myositis_c'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Myalgia -->
                <tr>
                    <td>11</td>
                    <td>Myalgia</td>
                    <td></td>
                    <td class="value-cell"><?php echo e($form1['myalgia'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Global Disease Activity -->
                <tr>
                    <td>12</td>
                    <td>Global Disease Activity</td>
                    <td class="value-cell"><?php echo e($form1['global_disease_activity'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
    <!-- Form 6: Physician Global Disease Activity -->
    <?php if($form6): ?>
    <?php
    $form6Data = json_decode(optional($form6)->form_data, true);
    $form6 = $form6Data['scores'] ?? [];
    $physicianGlobalActivity = (int) ($form6['physician_global_activity'] ?? 5);
    ?>
 

    <div class="form-section">
        <div class="form-title">Form 6: Physician Global Disease Activity</div>

        <div style="margin-bottom: 20px;">
            <h4 style="text-align: center; margin-bottom: 5px;">Please rate patient's global (overall) disease activity
            </h4>

            <!-- Slider Visualization -->
            <div style="margin: 30px auto; width: 90%; position: relative;">
                <!-- Slider Track -->
                <div style="height: 8px; background-color: #e9ecef; border-radius: 4px; position: relative;">
                    <!-- Active Portion -->
                    <div
                        style="width: <?php echo e($physicianGlobalActivity * 10); ?>%; height: 100%; background-color: #2A4B7C; border-radius: 4px;">
                    </div>
                    <!-- Slider Thumb -->
                    <div
                        style="position: absolute; left: <?php echo e($physicianGlobalActivity * 10); ?>%; top: -6px; transform: translateX(-50%);">
                        <div
                            style="width: 20px; height: 20px; background-color: #2A4B7C; border-radius: 50%; border: 3px solid white; box-shadow: 0 2px 4px rgba(0,0,0,0.2);">
                        </div>
                    </div>
                </div>

                <!-- Scale Labels -->
                <div style="display: flex; justify-content: space-between; margin-top: 10px; font-size: 12px;">
                    <div>0 - No Evidence</div>
                    <div>5 - Moderate</div>
                    <div>10 - Severe</div>
                </div>
            </div>

            <!-- Current Value Display -->
            <div style="text-align: center; margin-top: 20px;">
                <div style="font-size: 14px; margin-bottom: 5px;">Selected Value:</div>
                <div style="font-size: 24px; font-weight: bold; color: #2A4B7C;"><?php echo e($physicianGlobalActivity); ?></div>
            </div>
        </div>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
   
    <!-- Form 8: MMT-8 Follow-Up -->
   <?php if($form8): ?>
    <?php
    $form8Data = json_decode(optional($form8)->form_data, true);
    $form8 = $form8Data['scores'] ?? [];
    ?>
 

    <div class="form-section">
        <div class="form-title">Form 8: MMT-8 Follow-Up (Manual Muscle Testing)</div>

        <table>
            <thead>
                <tr>
                   
                    <th width="45%">Muscle Groups</th>
                    <th width="15%">Right (0-10)</th>
                    <th width="15%">Left (0-10)</th>
                    <th width="15%">Axial (0-10)</th>
                </tr>
            </thead>
            <tbody>
                <!-- Axial Muscle Section -->
                <tr>
                    <td colspan="5" class="section-header">Axial Muscle</td>
                </tr>
                <tr>
                  
                    <td>Neck Flexor</td>
                    <td class="value-cell"><?php echo e($form8['neck_flexor_axial_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['neck_flexor_axial_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['neck_flexor_axial_followup'] ?? 'N/A'); ?></td>
                </tr>

                <!-- Proximal Muscles Section -->
                <tr>
                    <td colspan="5" class="section-header">Proximal Muscles</td>
                </tr>
                <tr>
               
                    <td>Deltoid</td>
                    <td class="value-cell"><?php echo e($form8['deltoid_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['deltoid_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                    
                    <td>Biceps</td>
                    <td class="value-cell"><?php echo e($form8['biceps_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['biceps_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                
                    <td>Quadriceps</td>
                    <td class="value-cell"><?php echo e($form8['quadriceps_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['quadriceps_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                     
                    <td>Gluteus Medius</td>
                    <td class="value-cell"><?php echo e($form8['gluteus_medius_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['gluteus_medius_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                 
                    <td>Gluteus Maximus</td>
                    <td class="value-cell"><?php echo e($form8['gluteus_maximus_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['gluteus_maximus_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>

                <!-- Distal Muscles Section -->
                <tr>
                    <td colspan="5" class="section-header">Distal Muscles</td>
                </tr>
                <tr>
                  
                    <td>Wrist Extensor</td>
                    <td class="value-cell"><?php echo e($form8['wrist_extensor_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['wrist_extensor_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>
                <tr>
                  
                    <td>Ankle Dorsiflexion</td>
                    <td class="value-cell"><?php echo e($form8['ankle_dorsiflexion_right_followup'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form8['ankle_dorsiflexion_left_followup'] ?? 'N/A'); ?></td>
                    <td></td>
                </tr>

                <tr>
    <th colspan="5" class="text-center" style="background-color: aliceblue;">MMT-8 Scoring</th>
</tr>

<tr class="total-scoring-value">
    <td>Total Score</td>
    <td colspan="3">
        <input type="text" class="form-control total-score-value" readonly
               value="<?php echo e($form8['total_scoring_value_followup'] ?? 'N/A'); ?>">
    </td>
</tr>

<tr class="maximum-scoring">
    <td>Total Maximum Possible Score</td>
    <td>
        <input type="text" class="form-control max-column-score" readonly
               value="<?php echo e($form8['max_scoring_right_followup'] ?? 'N/A'); ?>">
    </td>
    <td>
        <input type="text" class="form-control max-column-score" readonly
               value="<?php echo e($form8['max_scoring_left_followup'] ?? 'N/A'); ?>">
    </td>
    <td>
        <input type="text" class="form-control max-column-score" readonly
               value="<?php echo e($form8['max_scoring_axial_followup'] ?? 'N/A'); ?>">
    </td>
</tr>

<tr class="total-scoring-value">
    <td>Maximum Score</td>
    <td colspan="3">
        <input type="text" class="form-control" readonly
               value="<?php echo e($form8['maximum_score_followup'] ?? 'N/A'); ?>">
    </td>
</tr>

<tr class="total-individual-score">
    <td>Maximum Individual Score</td>
    <td>
        <input type="text" class="form-control total-column-score" readonly
               value="<?php echo e($form8['total_individual_right_followup'] ?? 'N/A'); ?>">
    </td>
    <td>
        <input type="text" class="form-control total-column-score" readonly
               value="<?php echo e($form8['total_individual_left_followup'] ?? 'N/A'); ?>">
    </td>
    <td>
        <input type="text" class="form-control total-column-score" readonly
               value="<?php echo e($form8['total_individual_axial_followup'] ?? 'N/A'); ?>">
    </td>
</tr>

                
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
    <!-- Form 9: CDASI Activity Follow-Up -->
   <?php if($form9): ?>
    <?php
    $form9Data = json_decode(optional($form9)->form_data, true);
    $form9 = $form9Data['scores'] ?? [];
    ?>

    <div class="form-section">
        <div class="form-title">Form 9: CDASI Activity Follow-Up (Cutaneous Dermatomyositis Disease Area and Severity
            Index)</div>

        <div
            style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center; margin-bottom: 15px;">
            CDASI Activity
        </div>

        <table>
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="40%">Anatomical Location</th>
                    <th width="20%">Erythema</th>
                    <th width="20%">Scale</th>
                    <th width="15%">Erosion/Ulceration</th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - absent<br>
                        1 - pink; faint erythema<br>
                        2 - red<br>
                        3 - dark red
                    </th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - absent<br>
                        1 - scale<br>
                        2 - crust; lichenification
                    </th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - absent<br>
                        1 - present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>Scalp</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_scalp_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_scalp_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_scalp_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Malar Area</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_malar_area_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_malar_area_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_malar_area_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>Periorbital</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Periorbital_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Periorbital_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Periorbital_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>Rest of the Face</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_the_face_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_the_face_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_the_face_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>5</td>
                    <td>V-area Neck (Frontal)</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_v-neck_frontal_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_v-neck_frontal_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_v-neck_frontal_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6</td>
                    <td>Posterior Neck</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_posterior_neck_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_posterior_neck_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_posterior_neck_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>7</td>
                    <td>Upper Back & Shoulders</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_upper_back_shoulder_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_upper_back_shoulder_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_upper_back_shoulder_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>8</td>
                    <td>Rest of Back & Buttocks</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_back_buttocks_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_back_buttocks_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_back_buttocks_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>9</td>
                    <td>Abdomen</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Abdomen_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Abdomen_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Abdomen_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>10</td>
                    <td>Lateral Upper Thigh</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Lateral_upper_thigh_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Lateral_upper_thigh_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Lateral_upper_thigh_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>11</td>
                    <td>Rest of Leg & Feet</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_leg_feet_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_leg_feet_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Rest_of_leg_feet_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>12</td>
                    <td>Arm</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Arm_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Arm_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Arm_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>13</td>
                    <td>Mechanic's Hand</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Mechanic_hand_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Mechanic_hand_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Mechanic_hand_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>14</td>
                    <td>Dorsum of Hands (Not Over Joints)</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Dorsum_of_hand_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Dorsum_of_hand_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Dorsum_of_hand_3'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>15</td>
                    <td>Gottron's - Not on Hands</td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Gottrons_not_on_hand_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Gottrons_not_on_hand_2'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form9['cdasi_activity_Gottrons_not_on_hand_3'] ?? 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
    <!-- Form 10: CDASI Damage Follow-Up -->
   <?php if($form10): ?>
    <?php
    $form10Data = json_decode(optional($form10)->form_data, true);
    $form10 = $form10Data['scores'] ?? [];
    ?>
 

    <div class="form-section">
        <div class="form-title">Form 10: CDASI Damage Follow-Up (Cutaneous Dermatomyositis Disease Area and Severity
            Index)</div>

        <div
            style="background-color: #e71f1f; color: white; padding: 12px; border-radius: 5px; border: 2px solid #fe0000; text-align: center; margin-bottom: 15px;">
            CDASI Damage
        </div>

        <table>
            <thead>
                <tr>
                    <th width="5%">#</th>
                    <th width="50%">Anatomical Location</th>
                    <th width="20%">Calcinosis</th>
                    <th width="25%">Poikiloderma</th>
                </tr>
                <tr>
                    <th></th>
                    <th></th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - Absent<br>1 - Present
                    </th>
                    <th style="font-size: 11px; font-weight: normal;">
                        0 - Absent<br>1 - Present
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>1</td>
                    <td>Scalp</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_scalp_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_scalp_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>2</td>
                    <td>Malar Area</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_malar_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_malar_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>3</td>
                    <td>Periorbital</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Periorbital_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Periorbital_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>4</td>
                    <td>Rest of the Face</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_restofface_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_restofface_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>5</td>
                    <td>V-area Neck (Frontal)</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_vareaneck_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_vareaneck_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>6</td>
                    <td>Posterior Neck</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Posterior_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Posterior_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>7</td>
                    <td>Upper Back & Shoulders</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_upperback_shoulder_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_upperback_shoulder_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>8</td>
                    <td>Rest of Back & Buttocks</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_restofback_buttocks_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_restofback_buttocks_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>9</td>
                    <td>Abdomen</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Abdomen_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Abdomen_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>10</td>
                    <td>Lateral Upper Thigh</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Lateralupperthigh_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Lateralupperthigh_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>11</td>
                    <td>Rest of Leg & Feet</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_restofleg_feet_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_restofleg_feet_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>12</td>
                    <td>Arm</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Arm_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_Arm_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>13</td>
                    <td>Mechanic's Hand</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_mechanicshand_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_mechanicshand_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>14</td>
                    <td>Dorsum of Hands (Not Over Joints)</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_dursumofhand_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_dursumofhand_right_1'] ?? 'N/A'); ?></td>
                </tr>
                <tr>
                    <td>15</td>
                    <td>Gottron's - Not on Hands</td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_gottronsnotonhands_left_1'] ?? 'N/A'); ?></td>
                    <td class="value-cell"><?php echo e($form10['cdasi_damange_gottronsnotonhands_right_1'] ?? 'N/A'); ?></td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <?php endif; ?>
    <!-- Form 11: Gottron's, Periungual, Alopecia Follow-Up -->
   <?php if($form11): ?>
 <?php
$form11Data = json_decode(optional($form11)->form_data, true);
$form11 = $form11Data['scores'] ?? [];

$gottronErythema = $form11['erythema_2'] ?? null;
$papule = $form11['papule_present_2'] ?? 'no';
$finalErythema = ($papule === 'yes' && is_numeric($gottronErythema)) ? $gottronErythema * 2 : $gottronErythema;
?>

<div class="form-section">
    <div class="form-title">Form 11: Gottron's, Periungual, Alopecia Follow-Up Assessment</div>

    <!-- Gottron's Hands Section -->
    <table style="margin-bottom: 20px;">
        <thead>
            <tr>
                <th colspan="5"
                    style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                    Gottron's - Hands
                </th>
            </tr>
            <tr>
                <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                    Examine the patient's hands and double score if papules are present
                </th>
                <th style="background-color: #f5f5f5; width: 10px;"></th>
                <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                    Examine patient's hands and score if damage is present
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="padding: 8px; font-size: 12px; width: 35%;">
                    0 - absent<br>1 - pink; faint erythema<br>2 - red erythema<br>3 - dark red
                </td>
                <td class="value-cell" style="width: 15%;"><?php echo e($finalErythema ?? 'N/A'); ?></td>
                <td style="background-color: #f5f5f5;"></td>
                <td style="padding: 8px; font-size: 12px; width: 35%;">
                    0 - absent<br>1 - dyspigmentation<br>2 - scarring
                </td>
                <td class="value-cell" style="width: 15%;"><?php echo e($form11['damage_2'] ?? 'N/A'); ?></td>
            </tr>
            <tr style="background-color: #f8f1e9;">
                <td style="padding: 8px; font-weight: bold;">Papule Present</td>
                <td class="value-cell"><?php echo e($form11['papule_present_2'] ?? 'N/A'); ?></td>
                <td colspan="3" style="background-color: #f5f5f5;"></td>
            </tr>
        </tbody>
    </table>

    <!-- Periungual Section -->
    <table style="margin-bottom: 20px;">
        <thead>
            <tr>
                <th colspan="2"
                    style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                    Periungual
                </th>
            </tr>
            <tr>
                <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                    Periungual changes (examine)
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="padding: 8px; font-size: 12px; width: 85%;">
                    0 - absent<br>1 - pink/red erythema / microscopic telangiectasias<br>2 - visible telangiectasias
                </td>
                <td class="value-cell" style="width: 15%;"><?php echo e($form11['periunguals'] ?? 'N/A'); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Alopecia Section -->
    <table style="margin-bottom: 20px;">
        <thead>
            <tr>
                <th colspan="2"
                    style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                    Alopecia
                </th>
            </tr>
            <tr>
                <th colspan="2" style="text-align: left; padding: 8px; font-size: 14px;">
                    Recent Hair loss (within last 30 days as reported by the patient)
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td style="padding: 8px; font-size: 12px; width: 85%;">
                    0 - absent<br>1 - present
                </td>
                <td class="value-cell" style="width: 15%;"><?php echo e($form11['alopecias'] ?? 'N/A'); ?></td>
            </tr>
        </tbody>
    </table>

    <!-- Score Summary Section -->
    <table>
        <tbody>
            <tr>
                <td colspan="2"
                    style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px; font-weight: bold;">
                    Total Activity Score
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; font-size: 13px; width: 85%;">
                    (For the activity score, please add up the scores of the left side, i.e. Erythema, Scale,
                    Excoriation, Ulceration, Gottron's, Periungual, Alopecia)
                </td>
                <td class="value-cell" style="width: 15%; font-weight: bold; background-color: #e6f7ff;">
                    <?php echo e($form11['total_activity_score'] ?? 'N/A'); ?>

                </td>
            </tr>
            <tr>
                <td colspan="2"
                    style="background-color: #dc3545; color: white; padding: 10px; text-align: center; font-size: 16px; font-weight: bold;">
                    Total Damage Score
                </td>
            </tr>
            <tr>
                <td style="padding: 10px; font-size: 13px;">
                    (For the damage score, add up the scores of the right side, i.e. Poikiloderma, Calcinosis)
                </td>
                <td class="value-cell" style="font-weight: bold; background-color: #ffe6e6;">
                    <?php echo e($form11['total_damage_score'] ?? 'N/A'); ?>

                </td>
            </tr>
        </tbody>
    </table>
</div>
<div class="page-break"></div>
<?php endif; ?>


     <!-- Form 7: MDAAT Follow-Up -->
     <?php if($form7): ?>
    <?php
    $form7Data = json_decode(optional($form7)->form_data, true);
    $form7 = $form7Data['scores'] ?? [];
    ?>
 

     <div class="form-section">
         <div class="form-title">Form 7: MDAAT Follow-Up (Myositis Disease Activity Assessment Tool)</div>
 
         <table>
             <thead>
                 <tr>
                     <th width="5%">#</th>
                     <th width="45%">Disease Activity</th>
                     <th width="15%">VAS (0-10 cm)</th>
                     <th width="35%">Clinical Features (0,1,2,3,4, NA)</th>
                 </tr>
             </thead>
             <tbody>
                 <!-- Constitutional Disease Activity -->
                 <tr>
                     <td>1</td>
                     <td>Constitutional Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_1_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>1.1</td>
                     <td>Pyrexia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_1_1_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>1.2</td>
                     <td>Weight Loss</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_1_2_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>1.3</td>
                     <td>Fatigue</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_1_3_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Cutaneous Disease Activity -->
                 <tr>
                     <td>2</td>
                     <td>Cutaneous Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_2_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>2.1</td>
                     <td>Cutaneous Ulceration</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_1_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.2</td>
                     <td>Erythroderma</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_2_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.3</td>
                     <td>Panniculitis</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_3_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.4</td>
                     <td>Erythematous Rash</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. with secondary changes</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_4a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. without secondary changes</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_4b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.5</td>
                     <td>Heliotrope rash</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_5_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.6</td>
                     <td>Gottron's papules/sign</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_6_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.7</td>
                     <td>Periungual capillary changes</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_7_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.8</td>
                     <td>Alopecia</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Diffuse hair loss</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_8a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Focal, patchy with erythema</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_8b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>2.9</td>
                     <td>Mechanics Hand</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_2_9_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Skeletal Disease Activity -->
                 <tr>
                     <td>3</td>
                     <td>Skeletal Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_3_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>3.1</td>
                     <td>Arthritis</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Severe active polyarthritis</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_3_1a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Moderately active arthritis</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_3_1b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">C. Mild arthritis</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_3_1c_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>3.2</td>
                     <td>Arthralgia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_3_2_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- GI Disease Activity -->
                 <tr>
                     <td>4</td>
                     <td>GI Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_4_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>4.1</td>
                     <td>Dysphagia</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Moderate/severe dysphagia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_4_1a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Mild dysphagia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_4_1b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>4.2</td>
                     <td>Abdominal Pain</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Severe</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_4_2a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Moderate</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_4_2b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">C. Mild</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_4_2c_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Pulmonary Disease Activity -->
                 <tr>
                     <td>5</td>
                     <td>Pulmonary Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_5_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>5.1</td>
                     <td>Resp. Muscle weakness without ILD</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Dyspnea at rest</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_1a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Dyspnea on exertion</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_1b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>5.2</td>
                     <td>Active Reversible ILD</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Dyspnea or cough due to ILD</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_2a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Parenchymal abnormalities</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_2b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">C. Pulmonary Function Tests</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_2c_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>5.3</td>
                     <td>Dysphonia</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Moderate to severe</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_3a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Mild</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_5_3b_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Cardiovascular Disease Activity -->
                 <tr>
                     <td>6</td>
                     <td>Cardiovascular Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_6_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>6.1</td>
                     <td>Pericarditis</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_6_1_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>6.2</td>
                     <td>Myocarditis</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_6_2_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>6.3</td>
                     <td>Arrhythmias</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Severe arrhythmia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_6_3a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Other arrhythmia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_6_3b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>6.4</td>
                     <td>Sinus Tachycardia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_6_4_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Other Disease Activity -->
                 <tr>
                     <td>7</td>
                     <td>
                         Other Disease Activity<br>
                         <span class="sub-heading"><?php echo e($form7['other_disease_specification'] ?? 'N/A'); ?></span>
                     </td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_7_followup'] ?? 'N/A'); ?></td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_7_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Extra Muscular Global Assessment -->
                 <tr>
                     <td>8</td>
                     <td>Extra Muscular Global Assessment</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_8_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
 
                 <!-- Muscle Disease Activity -->
                 <tr>
                     <td>9</td>
                     <td>Muscle Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['disease_activity_9_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td>10</td>
                     <td>Myositis</td>
                     <td></td>
                     <td></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">A. Severe muscle inflammation</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_10a_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">B. Moderate muscle inflammation</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_10b_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td></td>
                     <td class="sub-heading">C. Mild muscle inflammation</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_10c_followup'] ?? 'N/A'); ?></td>
                 </tr>
                 <tr>
                     <td>11</td>
                     <td>Myalgia</td>
                     <td></td>
                     <td class="value-cell"><?php echo e($form7['clinical_features_11_followup'] ?? 'N/A'); ?></td>
                 </tr>
 
                 <!-- Global Disease Activity -->
                 <tr>
                     <td>12</td>
                     <td>Global Disease Activity</td>
                     <td class="value-cell"><?php echo e($form7['global_disease_activity_followup'] ?? 'N/A'); ?></td>
                     <td></td>
                 </tr>
             </tbody>
         </table>
     </div>
     <div class="page-break"></div>
     <?php endif; ?>
    <?php
$form12 = json_decode(optional($form12)->form_data, true);
$form12 = $form12['scores'] ?? [];
$savedValue12 = $form12['scale2'] ?? 5;
?>


    <div class="form-section">
        <div class="form-title">Form 12: Physician Global Disease Activity (Readonly)</div>

        <table style="margin-bottom: 20px;">
            <thead>
                <tr>
                    <th
                        style="background-color: #2A4B7C; color: white; padding: 10px; text-align: center; font-size: 16px;">
                        Case 1 Presentation: Follow-up - Physician Global Disease Activity
                    </th>
                </tr>

            </thead>
            <tbody>
                <tr>
                    <td style="padding: 20px;">
                        <!-- Visual Slider Representation -->
                        <div style="position: relative; margin: 20px 0;">

                            <div style="height: 6px; background: #e9ecef; border-radius: 3px; position: relative;">
                                <div
                                    style="width: <?php echo e($savedValue12 * 10); ?>%; height: 100%; background: #007bff; border-radius: 3px;">
                                </div>
                                <!-- Slider thumb indicator -->
                                <div
                                    style="position: absolute; left: <?php echo e($savedValue12 * 10); ?>%; top: -7px; margin-left: -10px;">
                                    <div
                                        style="width: 20px; height: 20px; background: #007bff; border-radius: 50%; border: 2px solid white;">
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Current Value Display -->
                        <div style="text-align: center; margin-top: 15px; font-size: 14px;">
                            <strong>Selected Value:</strong>
                            <span
                                style="display: inline-block; width: 40px; height: 30px; line-height: 30px; background-color: #f8f9fa; border: 1px solid #ced4da; border-radius: 4px; margin-left: 10px;">
                                <?php echo e($savedValue12); ?>

                            </span>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
    <div class="page-break"></div>
    <!-- Add other forms here -->
</body>

</html><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/submissions/pdf.blade.php ENDPATH**/ ?>