

<?php $__env->startSection('content'); ?> <br><br><br>
<div class="container mt-4">
    <h2 class="text-center mb-4">User Dashboard</h2>

    <!-- Case Summary -->
    <div class="row text-center">
        <div class="col-md-4">
            <div class="card text-white bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Cases</h5>
                    <h3><?php echo e($totalCases); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Completed Cases</h5>
                    <h3><?php echo e($completedCases); ?></h3>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-white bg-warning mb-3">
                <div class="card-body">
                    <h5 class="card-title">Pending Cases</h5>
                    <h3><?php echo e($pendingCases); ?></h3>
                </div>
            </div>
        </div>
    </div>

    <!-- Assigned Cases Table -->
    <div class="card">
        <div class="card-body">
            <h4 class="card-title">Assigned Cases</h4>
            <div class="table-responsive">
                <table class="table table-striped table-bordered">
                    <thead class="table-dark">
                        <tr>
                            
                            <th>Case No.</th>
                            <th>Title</th>
                            <th>Assigned Date</th>
                            <th>Assigned Time</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $assignedCases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $case): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <tr>
                          
                            <td><?php echo e($case->case_no); ?></td>
                            <td><?php echo e($case->title); ?></td>
                            <td><?php echo e($case->created_at->setTimezone('America/Los_Angeles')->format('Y-m-d')); ?></td>
                            <td><?php echo e($case->created_at->setTimezone('America/Los_Angeles')->format('h:i A')); ?></td>
                            
                            <td>
                                <?php if(in_array($case->case_no, $submittedCaseIds)): ?>
                                    <button class="btn btn-sm" style="background: linear-gradient(135deg, #00c9a7, #92fe9d); color: #fff; border: none;">
                                        <i class="fas fa-check-circle"></i> Submitted
                                    </button>
                                    <a href="<?php echo e(route('user.viewDocument', $case->id)); ?>" class="btn btn-sm" style="background: linear-gradient(135deg, #2193b0, #6dd5ed); color: #fff; border: none;">
                                        <i class="fas fa-eye"></i> View
                                    </a>
                                <?php elseif(in_array($case->case_no, $draftCaseIds)): ?>
                                    <a href="<?php echo e(route('user.viewDocument', $case->id)); ?>" class="btn btn-sm" style="background: linear-gradient(135deg, #f7971e, #ffd200); color: #fff; border: none;">
                                        <i class="fas fa-sync-alt"></i> Resume
                                    </a>
                                <?php else: ?>
                                    <a href="<?php echo e(route('user.viewDocument', $case->id)); ?>" class="btn btn-sm" style="background: linear-gradient(135deg, #ff6a00, #ee0979); color: #fff; border: none;">
                                        <i class="fas fa-play"></i> Begin
                                    </a>
                                <?php endif; ?>
                            </td>
                            

                        </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <tr>
                            <td colspan="5" class="text-center">No cases assigned.</td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/doctors/dashboard.blade.php ENDPATH**/ ?>