<?php
    $formData = $savedScores['form3CDASI']['scores'] ?? [];
?>

<div class="panel panel-default" id="form3CDASIReadonly">
    <div class="panel-heading"><strong>Form 3: CDASI (Readonly)</strong></div>
    <div class="panel-body">
        <div class="table-container">
            <h3>Case Presentation: Initial<br><hr>Cutaneous Dermatomyositis Disease Area and Severity Index (CDASI)</h3>
            <h5 style="font-size:15px;">Readonly version of the submitted form</h5>
            
            <table class="table table-striped table-bordered mediaTable table-1">
                <h2 style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">
                    CDASI Activity
                </h2>

                <thead>
                    <tr>
                        
                        <th class="essential persist">Anatomical Location</th>
                        <th class="optional" style="width: 150px;">Erythema</th>
                        <th class="optional" style="width: 200px;">Scale</th>
                        <th>Erosion/Ulceration</th>
                    </tr>
                    <tr>
                        
                        <th class="essential persist"></th>
                        <th class="optional" style="width: 150px; font-size: 12px;">0 - absent <br>1 - pink; faint erythema <br>2 - red <br>3 - dark red</th>
                        <th class="optional" style="width: 200px; font-size: 12px;">0 - absent <br>1 - scale <br>2 - crust; lichenification</th>
                        <th style="font-size: 12px;">0 - absent <br>1 - present</th>
                    </tr>
                </thead>

                <tbody>
                    <tr>
                      
                        <td>Scalp</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['activity-radio1'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['activity-radio2'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['activity-radio3'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                         <td>Malar Area</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['activity-radio4'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['malar_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['malar_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                      
                        <td>Periorbital</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['Periorbital_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['Periorbital_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['Periorbital_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                         
                        <td>Rest of the Face</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restofface_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restofface_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restofface_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>V-area Neck (Frontal)</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['vareaneck_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['vareaneck_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['vareaneck_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>Posterior Neck</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['posterior_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['posterior_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['posterior_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>Upper Back & Shoulders</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['upperbackshoulder_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['upperbackshoulder_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['upperbackshoulder_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>Rest of Back & Buttocks</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restofbackbuttocks_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restofbackbuttocks_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restofbackbuttocks_ritgh_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>Abdomen</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['abdomen_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['abdomen_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['abdomen_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>Lateral Upper Thigh</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['lateralupperthigh_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['lateralupperthigh_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['lateralupperthigh_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                       
                        <td>Rest of Leg & Feet</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restoflegfeet_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restoflegfeet_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['restoflegfeet_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
                        
                        <td>Arm</td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['arm_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['arm_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                        <td><input type="text" class="form-control" value="<?php echo e($formData['arm_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
                    </tr>
                    <tr>
    
    <td>Mechanic's Hand</td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['mechanichand_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['mechanichand_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['mechanichand_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
</tr>

<tr>
   
    <td>Dorsum of Hands (Not Over Joints)</td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['dorsumofhands_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['dorsumofhands_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['dorsumofhands_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
</tr>

<tr>
    
    <td>Gottron's - Not on Hands</td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['gottronNotonHands_left_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['gottronNotonHands_middle_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
    <td><input type="text" class="form-control" value="<?php echo e($formData['gottronNotonHands_right_initia_cdasi'] ?? 'N/A'); ?>" readonly></td>
</tr>
                </tbody>
            </table>
        </div>
    </div>
</div>
<?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/forms/form3CDASIReadonly.blade.php ENDPATH**/ ?>