<?php
$formData = \App\Models\FormDraft::where([
    'form_id' => 'form10cdasidamage',
    'case_id' => $case_no,
    'user_id' => auth()->id()
])->first();

$savedScores = [];

if ($formData) {
    $decoded = json_decode($formData->form_data, true);
    $savedScores = $decoded['scores'] ?? [];
}
?>

<form id="form10cdasidamage" class="scoring-form" data-form-id="form10cdasidamage">
    <input type="hidden" name="form_id" value="form10cdasidamage">
    <input type="hidden" name="case_no" value="<?php echo e($case_no); ?>">

    <div class="table-container1">
        <table id="cdasi_follow_up_damange-table" class="table table-striped table-bordered mediaTable table-2">
            <h2 style="background-color: red; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">
                CDASI Damage
            </h2>
            <thead>
                <tr>
                    
                    <th class="essential persist"><strong>Anatomical Location</strong></th>
                    <th class="optional" style="width: 150px;"><strong>Calcinosis</strong></th>
                    <th class="optional" style="width: 200px;"><strong>Poikiloderma (Dyspigmentation or Telangiectasia)</strong></th>
                </tr>
                <tr>
                     <th class="essential persist"></th>
                    <th class="optional" style="width: 150px;font-size: 12px;">
                        0 - Absent <br>
                        1 - Present
                    </th>
                    <th class="optional" style="width: 200px;font-size: 12px;">
                        0 - Absent <br>
                        1 - Present
                    </th>
                </tr>
            </thead>
            <tbody>
                <!-- Section 1 Subsections -->
                <tr class="section-2-sub">
                   
                    <td><strong>Scalp</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_scalp_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_scalp_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_scalp_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_scalp_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Malar Area</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_malar_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_malar_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_malar_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_malar_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_malar_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_malar_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_malar_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_malar_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Periorbital</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Rest of the Face</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_restofface_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_restofface_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_restofface_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_restofface_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_restofface_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_restofface_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_restofface_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_restofface_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>V-area Neck (Frontal)</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_vareaneck_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_vareaneck_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_vareaneck_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_vareaneck_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_vareaneck_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_vareaneck_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_vareaneck_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_vareaneck_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Posterior Neck</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Posterior_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Posterior_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Posterior_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Posterior_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Posterior_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Posterior_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Posterior_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Posterior_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Upper Back & Shoulders</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_upperback_shoulder_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_upperback_shoulder_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_upperback_shoulder_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_upperback_shoulder_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_upperback_shoulder_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_upperback_shoulder_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_upperback_shoulder_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_upperback_shoulder_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Rest of Back & Buttocks</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_restofback_buttocks_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_restofback_buttocks_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_restofback_buttocks_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_restofback_buttocks_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_restofback_buttocks_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_restofback_buttocks_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_restofback_buttocks_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_restofback_buttocks_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Abdomen</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Lateral Upper Thigh</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Lateralupperthigh_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Lateralupperthigh_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Lateralupperthigh_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Lateralupperthigh_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Lateralupperthigh_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Lateralupperthigh_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Lateralupperthigh_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Lateralupperthigh_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Rest of Leg & Feet</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_restofleg_feet_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_restofleg_feet_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_restofleg_feet_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_restofleg_feet_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_restofleg_feet_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_restofleg_feet_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_restofleg_feet_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_restofleg_feet_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Arm</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Arm_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Arm_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Arm_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Arm_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Mechanic's Hand</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_mechanicshand_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_mechanicshand_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_mechanicshand_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_mechanicshand_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_mechanicshand_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_mechanicshand_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_mechanicshand_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_mechanicshand_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Dorsum of Hands (Not Over Joints)</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_dursumofhand_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_dursumofhand_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_dursumofhand_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_dursumofhand_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_dursumofhand_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_dursumofhand_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_dursumofhand_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_dursumofhand_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-2-sub">
                     <td><strong>Gottron's - Not on Hands</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_gottronsnotonhands_left_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_gottronsnotonhands_left_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_gottronsnotonhands_left_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_gottronsnotonhands_left_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_gottronsnotonhands_right_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_gottronsnotonhands_right_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_gottronsnotonhands_right_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_gottronsnotonhands_right_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>
            </tbody>
        </table>

        <br>
       <!--  <button type="button" class="btn btn-success save-btn" data-form-id="form10cdasidamage">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span> -->
    </div>
</form><?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form10CDASIDamage.blade.php ENDPATH**/ ?>