<div id="maincontainer" class="clearfix">
    <header style="background: #317c81; border-bottom: 3px solid #a31660;">
        <nav class="navbar navbar-default navbar-fixed-top" role="navigation"
            style="background: #317c81; border-bottom: 3px solid #a31660;">
            <div class="navbar-inner">
                <div class="container-fluid">
                    <!-- Brand -->
                    <div class="navbar-header">
                        <?php if(auth()->user()->role == 'admin'): ?>
                        <a class="navbar-brand" href="<?php echo e(route('admin.dashboard')); ?>"
                            style="color:white; font-weight: bold;">Admin Dashboard</a>
                        <?php else: ?>
                        <a class="navbar-brand" href="<?php echo e(route('user.dashboard')); ?>"
                            style="color:white; font-weight: bold;">User Dashboard</a>
                        <?php endif; ?>
                    </div>

                    <!-- ✅ Navigation Based on Role -->
                    <ul class="nav navbar-nav" id="mobile-nav">
                        <?php if(auth()->user()->role == 'admin'): ?>
                        <!-- ✅ ADMIN MENU -->
                        <li><a href="<?php echo e(route('documents.create')); ?>" style="color:white;"><span
                                    class="glyphicon glyphicon-upload"></span> Upload Case</a></li>



                        <!-- Assign Cases Dropdown -->
                        <li class="dropdown mega-dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" style="color:white;">
                                <span class="glyphicon glyphicon-user"></span> Assign Cases <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu mega-dropdown-menu">
                                <div class="row">
                                    <div class="col-md-12">
                                        <li>
                                            <a href="<?php echo e(route('documents.assignPage')); ?>">
                                                Assign:
                                            </a>
                                        </li>
                                        <li>
                                            <a href="<?php echo e(route('admin.assigned_cases')); ?>">
                                                Assigned Cases
                                            </a>
                                        </li>
                                    </div>
                                </div>
                            </ul>
                        </li>

                        <li><a href="<?php echo e(route('users.index')); ?>" style="color:white;">
                                <span class="glyphicon glyphicon-user"></span> Users
                            </a></li>
                        <li>
                            <a href="<?php echo e(route('admin.index')); ?>">
                                <i class="fa fa-check-square-o"></i> Submitted Cases
                            </a>
                        </li>
                        <?php else: ?>
                        <!-- ✅ USER MENU -->
                        <li>
                            <a href="<?php echo e(route('user.myCases')); ?>" style="color:white;">
                                <span class="glyphicon glyphicon-folder-open"></span> My Cases
                            </a>
                        </li>
                        <li>
    <a href="#" data-toggle="modal" data-target="#instructionsModal" style="color:white;">
        <span class="glyphicon glyphicon-info-sign"></span> Instructions
    </a>
</li>

                        <?php endif; ?>
                    </ul>

                    <!-- User Profile & Logout Section -->
                    <ul class="nav navbar-nav user_menu pull-right">
                        <li class="dropdown">
                            <a href="#" class="dropdown-toggle" data-toggle="dropdown" style="color:white;">
                                <img src="<?php echo e(asset('img/user_avatar.png')); ?>" alt="" class="user_avatar">
                                <?php echo e(auth()->user()->username); ?> <b class="caret"></b>
                            </a>
                            <ul class="dropdown-menu dropdown-menu-right">
                                <?php if (! (auth()->user()->role == 'admin')): ?>
    <li><a href="<?php echo e(route('user.profile')); ?>">My Profile</a></li>
    <li class="divider"></li>
    <?php endif; ?>
                                <li>
                                    <form action="<?php echo e(route('logout')); ?>" method="POST" style="display: inline;">
                                        <?php echo csrf_field(); ?>
                                        <button type="submit" class="btn btn-link"
                                            style="border: none; background: none; padding: 0; cursor: pointer; color: inherit;">
                                            Log Out
                                        </button>
                                    </form>
                                </li>
                            </ul>
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- Instructions Modal -->
<div class="modal fade" id="instructionsModal" tabindex="-1" role="dialog" aria-labelledby="instructionsLabel">
    <div class="modal-dialog modal-lg" role="document">
        <div class="modal-content" style="border-radius: 10px;">
            <div class="modal-header" style="background-color:#337ab7; color:white;">
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span style="color:white;" aria-hidden="true">&times;</span>
                </button>
                <h4 class="modal-title" id="instructionsLabel">Instructions for Completing Case-Based Scoring</h4>
            </div>
            <div class="modal-body" style="font-size:14px; line-height:1.8;">
                <p><strong>Myositis Training</strong><br>
                Please follow the steps below to complete the Myositis case-based scoring assignment accurately and efficiently:</p>
                <ol>
                    <li><strong>Login</strong><br>Access the training platform using the login link and credentials provided in your email.</li>
                    <li><strong>Access Assigned Cases</strong><br>Upon logging in, navigate to the Dashboard and select "My Cases" to view your assigned cases.</li>
                    <li><strong>Begin Training</strong><br>Click "Begin" next to a case to start the training module.</li>
                    <li><strong>Interface Overview</strong><br>The case content will appear on the left panel, while the scoring form will be displayed on the right panel.</li>
                    <li><strong>Scoring Components</strong><br>Carefully review the case and complete all required scoring sections, including:
                        <ul>
                            <li>MMT-8 (Manual Muscle Testing)</li>
                            <li>CDASI (Cutaneous Dermatomyositis Disease Area and Severity Index)</li>
                            <li>MDAAT (Myositis Disease Activity Assessment Tool)</li>
                            <li>Physician Global Assessment</li>
                        </ul>
                    </li>
                    <li><strong>Mandatory Completion</strong><br>Do not leave any fields blank. All questions must be answered for accurate assessment.</li>
                    <li><strong>Download Option</strong><br>If needed, click the "Download" button to save a copy of the case for offline review.</li>
                    <li><strong>Expanded View</strong><br>Use the "Expand" button to view the case and scoring form in full-screen mode for better readability.</li>
                    <li><strong>Save Progress</strong><br>You may click “Save Draft” at any time to save your progress and return later to complete the scoring.</li>
                    <li><strong>Final Submission</strong><br>After completing all sections, click "Submit Form" at the bottom of the page.</li>
                    <li><strong>Final Review</strong><br>Ensure all fields are completed and thoroughly reviewed before submission.</li>
                </ol>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-primary" data-dismiss="modal">Got it</button>
            </div>
        </div>
    </div>
</div>

    </header>
</div>

<!-- jQuery and Bootstrap JavaScript -->
<script src="https://code.jquery.com/jquery-3.5.1.min.js"></script>
<script src="https://maxcdn.bootstrapcdn.com/bootstrap/3.3.1/js/bootstrap.min.js"></script>
<script>
$(document).ready(function() {
    $('.dropdown-toggle').dropdown();
});
</script><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/includes/header.blade.php ENDPATH**/ ?>