<?php
$formData = $savedScores['form11']['scores'] ?? [];
?>

<div class="panel panel-default" id="form11">
    <div class="panel-heading"><strong>Form 11: (Readonly)</strong></div>
    <div class="panel-body">
        <div class="table-container">
            <h3>Case 1 Presentation: Follow up</h3>
            <h5 style="font-size: 15px;">Readonly version of the submitted form</h5>

            <table class="table table-striped table-bordered mediaTable table-1">
                <thead>
                    <tr>
                        <th colspan="5" style="text-align: center; font-size: 18px;">Gottron's – Hands (Second Section)</th>
                    </tr>
                    <tr>
                        <th colspan="2">Examine the patient’s hands and double score if papules are present</th>
                        <th style="background-color: #4a4a4a; width: 15px;"></th>
                        <th colspan="2">Examine patient’s hands and score if damage is present</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            0 - absent<br>1 - pink; faint erythema<br>2 - red erythema<br>3 - dark red
                        </td>
                        <td style="text-align: center;">
                            <input type="text" class="form-control" 
                                   value="<?php echo e(isset($formData['erythema_2']) ? 
                                       (isset($formData['papule_present_2']) && $formData['papule_present_2'] == 'yes' ? 
                                       $formData['erythema_2'] * 2 : 
                                       $formData['erythema_2']) : 'N/A'); ?>" readonly>
                        </td>
                        <td style="background-color: #4a4a4a;"></td>
                        <td>
                            0 - absent<br>1 - dyspigmentation<br>2 - scarring
                        </td>
                        <td style="text-align: center;">
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['damage_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <tr style="background: linear-gradient(90deg, #F8EDE3, #E6CCB2);">
                        <td>Papule Present</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['papule_present_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td style="background-color: #4a4a4a;" colspan="3"></td>
                    </tr>
                </tbody>
            </table>
        </div>

        
        <br><hr><hr>
        <div class="table-container">
            <table class="table table-striped table-bordered mediaTable table-1">
                <thead>
                    <tr><th colspan="2" style="text-align: center; font-size: 18px;">Periungual</th></tr>
                    <tr><th colspan="2">Periungual changes (examine)</th></tr>
                </thead>
                <tbody>
                    <tr>
                        <td>
                            0 - absent<br>
                            1 - pink/red erythema / microscopic telangiectasias<br>
                            2 - visible telangiectasias
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['periunguals'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>
                </tbody>
            </table>
        </div>

        
        <br><hr>
        <div class="table-container">
            <table class="table table-striped table-bordered mediaTable table-1">
                <thead>
                    <tr><th colspan="3" style="text-align: center; font-size: 18px;">Alopecia</th></tr>
                    <tr><th colspan="2">Recent Hair loss (within last 30 days as reported by the patient)</th><th style="background-color: #4a4a4a;"></th></tr>
                </thead>
                <tbody>
                    <tr>
                        <td>0 - absent<br>1 - present</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['alopecias'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td style="background-color: #4a4a4a;"></td>
                    </tr>
                </tbody>
            </table>
        </div>

        
<br><br>
<table class="table table-bordered table-striped" style="margin-top: 30px;">
    <thead>
        <tr>
            <th colspan="2" class="text-center" style="font-size: 20px;">
                🔍 <strong>Overall Score Summary</strong>
            </th>
        </tr>
    </thead>
    <tbody>
        <!-- Total Activity Score -->
        <tr>
            <td style="font-weight: bold; background-color: #ecf0f1;">
                Total Activity Score
            </td>
            <td class="text-center" style="font-size: 22px; font-weight: bold; background-color: #dff9fb;">
                <?php echo e($formData['total_activity_score'] ?? '0'); ?>

            </td>
        </tr>
        <tr>
            <td colspan="2" style="background-color: #f8f9fa; padding: 12px;">
                Add up the scores: Erythema, Scale, Excoriation, Ulceration, Gottron's, Periungual, Alopecia
            </td>
        </tr>

        <!-- Total Damage Score -->
        <tr>
            <td style="font-weight: bold; background-color: #f2dede; color: #a94442;">
                Total Damage Score
            </td>
            <td class="text-center" style="font-size: 22px; font-weight: bold; background-color: #f2dede; color: #a94442;">
                <?php echo e($formData['total_damage_score'] ?? '0'); ?>

            </td>
        </tr>
        <tr>
            <td colspan="2" style="background-color: #f8f9fa; padding: 12px;">
                Add up the scores: Poikiloderma, Calcinosis
            </td>
        </tr>
    </tbody>
</table>

    </div>
</div>
<?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/forms/form11Readonly.blade.php ENDPATH**/ ?>