<?php
use App\Models\FormDraft;

// Prevent function redeclaration errors
if (!function_exists('getSavedValue')) {
function getSavedValue($scores, $key, $default = '0') {
return $scores['scores'][$key] ?? $default;
}
}

// Load saved data
$formData = FormDraft::where('user_id', auth()->id())
->where('form_id', 'form8followupmmt8')
->where('case_id', $case_no)

->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded ?? [];
}
?>

<form id="form8followupmmt8" class="scoring-form" data-form-id="form8followupmmt8">
    <div class="table-container1">
        <h3>Case Presentation: Follow up</h3>
        <hr>
        <h5 style="font-size: 15px;">
            Answers with possible correct responses based on patient's examination in the case.
        </h5>

        <table class="table table-striped table-bordered mediaTable table-2">
            <thead>
                <tr>

                    <th class="essential persist"><strong>Muscle Groups</strong></th>
                    <th class="optional" style="width: 220px;"><strong>Right <br> (0-10)</strong></th>
                    <th class="optional" style="width: 210px;"><strong>Left <br> (0-10)</strong></th>
                    <th class="optional" style="width: 210px;"><strong>Axial <br> (0-10)</strong></th>
                </tr>
            </thead>

            <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd)!important;"
                style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                <td colspan="5" style="border: none; background-color: transparent; text-align: center;">
                    <strong>Axial Muscle</strong>
                </td>
            </tr>

            <tbody>
                <!-- Section 1 -->
                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Neck Flexor</strong></td>
                    <td></td>
                    <td></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[neck_flexor_axial_followup]">
                                <option value="">-Select-</option>

                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'neck_flexor_axial_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[neck_flexor_axial_followup]" value="select">
                        </div>
                    </td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <th colspan="5" class="text-center">Proximal Muscles</th>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Deltoid</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[deltoid_right_followup]">
                                <option value="">-Select-</option>

                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'deltoid_right_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[deltoid_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[deltoid_left_followup]">
                                <option value="">-Select-</option>

                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'deltoid_left_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[deltoid_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Biceps</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[biceps_right_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'biceps_right_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[biceps_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[biceps_left_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'biceps_left_followup' )==$val
                                    ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[biceps_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Quadriceps</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[quadriceps_right_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'quadriceps_right_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[quadriceps_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[quadriceps_left_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'quadriceps_left_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[quadriceps_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Gluteus Medius</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_medius_right_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_medius_right_followup' )==$val ? 'selected'
                                    : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_medius_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_medius_left_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_medius_left_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_medius_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Gluteus Maximus</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_maximus_right_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_maximus_right_followup' )==$val ? 'selected'
                                    : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_maximus_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[gluteus_maximus_left_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'gluteus_maximus_left_followup' )==$val ? 'selected'
                                    : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[gluteus_maximus_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <th colspan="5" class="text-center" style="background-color: aliceblue;">Distal Muscles</th>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Wrist Extensor</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[wrist_extensor_right_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'wrist_extensor_right_followup' )==$val ? 'selected'
                                    : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[wrist_extensor_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[wrist_extensor_left_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'wrist_extensor_left_followup'
                                    )==$val ? 'selected' : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[wrist_extensor_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Ankle Dorsiflexion</strong></td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[ankle_dorsiflexion_right_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'ankle_dorsiflexion_right_followup' )==$val ? 'selected'
                                    : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[ankle_dorsiflexion_right_followup]" value="select">
                        </div>
                    </td>
                    <td>
                        <div class="select-container">
                            <select class="form-control option-value" name="scores[ankle_dorsiflexion_left_followup]">
                                <option value="">-Select-</option>
                                <?php $__currentLoopData = ['0','1','2','3','4','5','6','7','8','9','10','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($val); ?>" <?php echo e(getSavedValue($savedScores, 'ankle_dorsiflexion_left_followup' )==$val ? 'selected'
                                    : ''); ?>>
                                    <?php echo e($val); ?>

                                </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="hidden" name="input_types[ankle_dorsiflexion_left_followup]" value="select">
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1" style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <th colspan="5" class="text-center" style="background-color: aliceblue;">MMT-8 Scoring</th>
                </tr>
                <tr class="section-1 total-scoring-value"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Total Score</strong></td>
                    <td colspan="3">
                        <input type="text" class="form-control total-score-value" readonly
                            name="scores[total_scoring_value_followup]"
                            value="<?php echo e(getSavedValue($savedScores, 'total_scoring_value_followup', '')); ?>">
                        <input type="hidden" name="input_types[total_scoring_value_followup]" value="text">
                    </td>
                </tr>
                <tr class="section-1 maximum-scoring"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Total Maximum Possible Score</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control max-column-score" readonly
                                name="scores[max_scoring_right_followup]"
                                value="<?php echo e(getSavedValue($savedScores, 'max_scoring_right_followup', '')); ?>">
                            <input type="hidden" name="input_types[max_scoring_right_followup]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control max-column-score" readonly
                                name="scores[max_scoring_left_followup]"
                                value="<?php echo e(getSavedValue($savedScores, 'max_scoring_left_followup', '')); ?>">
                            <input type="hidden" name="input_types[max_scoring_left_followup]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control max-column-score" readonly
                                name="scores[max_scoring_axial_followup]"
                                value="<?php echo e(getSavedValue($savedScores, 'max_scoring_axial_followup', '')); ?>">
                            <input type="hidden" name="input_types[max_scoring_axial_followup]" value="text">
                        </div>
                    </td>
                </tr>
                <tr class="section-1 total-scoring-value"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Maximum score</strong></td>
                    <td colspan="3">
                        <input type="text" class="form-control" readonly name="scores[maximum_score_followup]"
                            value="<?php echo e(getSavedValue($savedScores, 'maximum_score_followup', '')); ?>">
                        <input type="hidden" name="input_types[maximum_score_followup]" value="text">
                    </td>
                </tr>
                <tr class="section-1 total-individual-score"
                    style="background:linear-gradient(90deg, #82c9e6, #a09ebd) !important;">
                    <td><strong>Maximum Individual Score</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control total-column-score" readonly
                                name="scores[total_individual_right_followup]"
                                value="<?php echo e(getSavedValue($savedScores, 'total_individual_right_followup', '')); ?>">
                            <input type="hidden" name="input_types[total_individual_right_followup]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control total-column-score" readonly
                                name="scores[total_individual_left_followup]"
                                value="<?php echo e(getSavedValue($savedScores, 'total_individual_left_followup', '')); ?>">
                            <input type="hidden" name="input_types[total_individual_left_followup]" value="text">
                        </div>
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="text" class="form-control total-column-score" readonly
                                name="scores[total_individual_axial_followup]"
                                value="<?php echo e(getSavedValue($savedScores, 'total_individual_axial_followup', '')); ?>">
                            <input type="hidden" name="input_types[total_individual_axial_followup]" value="text">
                        </div>
                    </td>
                </tr>





            </tbody>
        </table>

    </div>


</form>

<script>
    document.addEventListener("DOMContentLoaded", function () {
        // Function to calculate and update all totals
        function calculateTotalsForFollowUpTable() {
            const table = document.querySelector('#form8followupmmt8 table.mediaTable');
            if (!table) return;

            // Initialize totals
            let columnTotals = { right: 0, left: 0, axial: 0 };
            let maxPossibleScores = { right: 0, left: 0, axial: 0 };
            let naCounts = { right: 0, left: 0, axial: 0 };

            // Get all rows except the total rows
            const rows = table.querySelectorAll("tr.section-1:not(.total-individual-score):not(.maximum-scoring):not(.total-scoring-value)");

            rows.forEach((row) => {
                // Skip section header rows
                if (row.querySelector('th')) return;

                // Get all cells in the row
                const cells = row.querySelectorAll("td");
                if (cells.length < 4) return; // Skip if not enough columns

                // Process Right column (index 1)
                processColumn(cells[1], 'right');
                // Process Left column (index 2)
                processColumn(cells[2], 'left');
                // Process Axial column (index 3)
                processColumn(cells[3], 'axial');

                function processColumn(cell, column) {
                    const select = cell.querySelector(".option-value");
                    if (select) {
                        const value = select.value === "NA" ? 0 : parseFloat(select.value) || 0;
                        columnTotals[column] += value;

                        // For maximum possible, each non-NA select could contribute up to 10
                        if (select.value === "NA") {
                            naCounts[column]++;
                        } else {
                            maxPossibleScores[column] += 10;
                        }
                    }
                }
            });

            // Update Total Individual Score row
            table.querySelector('input[name="scores[total_individual_right_followup]"]').value = columnTotals.right;
            table.querySelector('input[name="scores[total_individual_left_followup]"]').value = columnTotals.left;
            table.querySelector('input[name="scores[total_individual_axial_followup]"]').value = columnTotals.axial;

            // Update Maximum Possible Score row
            table.querySelector('input[name="scores[max_scoring_right_followup]"]').value = maxPossibleScores.right;
            table.querySelector('input[name="scores[max_scoring_left_followup]"]').value = maxPossibleScores.left;
            table.querySelector('input[name="scores[max_scoring_axial_followup]"]').value = maxPossibleScores.axial;

            // Calculate and update Total Score (sum of all individual scores)
            const totalScore = columnTotals.right + columnTotals.left + columnTotals.axial;
            table.querySelector('input[name="scores[total_scoring_value_followup]"]').value = totalScore;

            // Calculate and update Maximum score (sum of all max possible scores)
            const maximumScore = maxPossibleScores.right + maxPossibleScores.left + maxPossibleScores.axial;
            table.querySelector('input[name="scores[maximum_score_followup]"]').value = maximumScore;
        }

        // Attach event listeners to all select elements
        function attachEventListeners() {
            const selects = document.querySelectorAll('#form8followupmmt8 select.option-value');
            selects.forEach(select => {
                // Remove existing to avoid duplicates
                select.removeEventListener('change', calculateTotalsForFollowUpTable);
                // Add new listener
                select.addEventListener('change', calculateTotalsForFollowUpTable);
            });
        }

        // Initialize
        attachEventListeners();
        calculateTotalsForFollowUpTable(); // Calculate initial totals
    });
</script><?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form8FollowUpMMT8.blade.php ENDPATH**/ ?>