<?php
$formData = $savedScores['form9CdasiActivity']['scores'] ?? [];
?>

<div class="panel panel-default" id="form9CDASIActivity">
    <div class="panel-heading"><strong>Form 9: CDASI Activity (Readonly)</strong></div>
    <div class="panel-body">
        <div class="table-container">
            <h3>Case Presentation: Follow up <br>
                <hr>Cutaneous Dermatomyositis Disease Area and Severity Index (CDASI)
            </h3>
            <h5 style="font-size: 15px;">Readonly version of the submitted form</h5>

            <table id="cdasi_follow_up_activity-table" class="table table-striped table-bordered mediaTable table-1">
                <h2 style="background-color: #28a745; color: white; padding: 12px; border-radius: 5px; border: 2px solid #218838; text-align: center;">
                    CDASI Activity
                </h2>

                <thead>
                    <tr>
                       
                        <th class="essential persist">Anatomical Location</th>
                        <th class="optional" style="width: 150px;">Erythema</th>
                        <th class="optional" style="width: 200px;">Scale</th>
                        <th>Erosion/Ulceration</th>
                    </tr>
                    <tr>
                      
                        <th class="essential persist"></th>
                        <th class="optional" style="width: 150px; font-size: 12px;">
                            0 - absent <br>
                            1 - pink; faint erythema <br>
                            2 - red <br>
                            3 - dark red
                        </th>
                        <th class="optional" style="width: 200px; font-size: 12px;">
                            0 - absent <br>
                            1 - scale <br>
                            2 - crust; lichenification
                        </th>
                        <th style="font-size: 12px;">
                            0 - absent <br>
                            1 - present
                        </th>
                    </tr>
                </thead>

                <tbody>
                    <!-- Row 1 -->
                    <tr >
                      
                        <td>Scalp</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_scalp_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_scalp_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_scalp_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <!-- Row 2 -->
                    <tr >
                       
                        <td>Malar Area</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_malar_area_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_malar_area_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_malar_area_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <!-- Row 3 -->
                    <tr >
                       
                        <td>Periorbital</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_Periorbital_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_Periorbital_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_Periorbital_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <!-- Continue with all other rows in the same pattern -->
                    <!-- Row 4 -->
                    <tr >
                       
                        <td>Rest of the Face</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_Rest_of_the_face_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_Rest_of_the_face_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_Rest_of_the_face_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>

                    <!-- Row 5 -->
                    <tr >
                        
                        <td>V-area Neck (Frontal)</td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_v-neck_frontal_1'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_v-neck_frontal_2'] ?? 'N/A'); ?>" readonly>
                        </td>
                        <td>
                            <input type="text" class="form-control" 
                                   value="<?php echo e($formData['cdasi_activity_v-neck_frontal_3'] ?? 'N/A'); ?>" readonly>
                        </td>
                    </tr>
<!-- Row 6 -->
<tr >
  
    <td>Posterior Neck</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_posterior_neck_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_posterior_neck_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_posterior_neck_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 7 -->
<tr >
  
    <td>Upper Back & Shoulders</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_upper_back_shoulder_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_upper_back_shoulder_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_upper_back_shoulder_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 8 -->
<tr >
   
    <td>Rest of Back & Buttocks</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Rest_of_back_buttocks_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Rest_of_back_buttocks_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Rest_of_back_buttocks_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 9 -->
<tr >
  
    <td>Abdomen</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Abdomen_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Abdomen_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Abdomen_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 10 -->
<tr >
   
    <td>Lateral Upper Thigh</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Lateral_upper_thigh_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Lateral_upper_thigh_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Lateral_upper_thigh_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 11 -->
<tr >
   
    <td>Rest of Leg & Feet</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Rest_of_leg_feet_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Rest_of_leg_feet_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Rest_of_leg_feet_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 12 -->
<tr >
    
    <td>Arm</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Arm_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Arm_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Arm_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 13 -->
<tr >
  
    <td>Mechanic's Hand</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Mechanic_hand_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Mechanic_hand_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Mechanic_hand_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 14 -->
<tr >
     
    <td>Dorsum of Hands (Not Over Joints)</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Dorsum_of_hand_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Dorsum_of_hand_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Dorsum_of_hand_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>

<!-- Row 15 -->
<tr >
 
    <td>Gottron's - Not on Hands</td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Gottrons_not_on_hand_1'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Gottrons_not_on_hand_2'] ?? 'N/A'); ?>" readonly>
    </td>
    <td>
        <input type="text" class="form-control" 
               value="<?php echo e($formData['cdasi_activity_Gottrons_not_on_hand_3'] ?? 'N/A'); ?>" readonly>
    </td>
</tr>
                    
                </tbody>
            </table>
        </div>
    </div>
</div><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/forms/form9CDASIActivityReadonly.blade.php ENDPATH**/ ?>