

<?php $__env->startSection('content'); ?>
<br><br><br>

<div class="container">
    <div class="panel panel-primary shadow-box">
        <div class="panel-heading">
            <h3 class="panel-title">
                <i class="glyphicon glyphicon-file"></i> Viewing Case File: <?php echo e($document->title); ?>

            </h3>
        </div>
        <div class="panel-body">

            <!-- ✅ If the document is a Word file, render as HTML -->
            <?php if(isset($htmlContent)): ?>
                <div class="word-content">
                    <?php echo $htmlContent; ?>

                </div>

            <!-- ✅ If the document is an Excel file, render as a table -->
            <?php elseif(isset($data)): ?>
                <table class="table table-bordered">
                    <thead>
                        <tr>
                            <?php $__currentLoopData = $data[0]; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $header): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <th><?php echo e($header); ?></th>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = array_slice($data, 1); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <?php $__currentLoopData = $row; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cell): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <td><?php echo e($cell); ?></td>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>

            <!-- ✅ If the document is a PDF, render in iframe -->
            <?php elseif(pathinfo($document->file_path, PATHINFO_EXTENSION) === 'pdf'): ?>
                <iframe src="<?php echo e(asset('storage/' . $document->file_path)); ?>" width="100%" height="600px"></iframe>

            <?php else: ?>
                <p class="text-center text-muted"><i class="glyphicon glyphicon-info-sign"></i> Unable to preview this file.</p>
            <?php endif; ?>

            <!-- ✅ Download Button -->
            <div class="text-center mt-3">
                <a href="<?php echo e(asset('storage/' . $document->file_path)); ?>" class="btn btn-primary" download>
                    <i class="glyphicon glyphicon-download"></i> Download File
                </a>
            </div>

        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/admin/view-doc.blade.php ENDPATH**/ ?>