<?php
$formData = \App\Models\FormDraft::where([
'form_id' => 'form4cdasidamange',
'case_id' => $case_no,
'user_id' => auth()->id()
])->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded['scores'] ?? [];
}
?>

<form id="form4cdasidamange" class="scoring-form" data-form-id="form4cdasidamange">
    <input type="hidden" name="form_id" value="form4cdasidamange">
    <input type="hidden" name="case_no" value="<?php echo e($case_no); ?>">

    <div class="table-container">
        <table id="cdasi_damage-table" class="table table-striped table-bordered mediaTable table-1">
            <h2
                style="background-color: rgb(231, 31, 31); color: white; padding: 12px; border-radius: 5px; border: 2px solid #fe0000; text-align: center;">
                CDASI Damage
            </h2>
            <thead>
                <tr>
                     <th><strong>Anatomical Location</strong></th>
                    <th><strong>Calcinosis</strong></th>
                    <th><strong>Poikiloderma (Dyspigmentation or Telangiectasia)</strong></th>
                </tr>
            </thead>
            <tbody>
                
                <tr class="section-1-sub">
                    
                    <td><strong>Scalp</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_scalp_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_scalp_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_scalp_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_scalp_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_scalp_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                
                <tr class="section-1-sub">
                    
                    <td><strong>Malar Area</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_malar_area_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_malar_area_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_malar_area_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_malar_area_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_malar_area_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_malar_area_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_malar_area_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_malar_area_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                
                <tr class="section-1-sub">
                     <td><strong>Periorbital</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Periorbital_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Periorbital_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>
                <tr class="section-1-sub">
                     <td><strong>Rest of the Face</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_the_face_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_the_face_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_the_face_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_the_face_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_the_face_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_the_face_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_the_face_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_the_face_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>V-area Neck (Frontal)</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_v_area_neck_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_v_area_neck_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_v_area_neck_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_v_area_neck_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_v_area_neck_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_v_area_neck_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_v_area_neck_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_v_area_neck_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Posterior Neck</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_posterior_neck_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_posterior_neck_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_posterior_neck_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_posterior_neck_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_posterior_neck_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_posterior_neck_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_posterior_neck_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_posterior_neck_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Upper Back & Shoulders</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_upper_back_shoulders_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_upper_back_shoulders_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_upper_back_shoulders_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_upper_back_shoulders_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_upper_back_shoulders_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_upper_back_shoulders_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_upper_back_shoulders_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_upper_back_shoulders_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Rest of Back & Buttocks</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_back_shoulder_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_back_shoulder_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_back_shoulder_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_back_shoulder_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_back_shoulder_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_back_shoulder_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_back_shoulder_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_back_shoulder_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Abdomen</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Abdomen_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Abdomen_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Lateral Upper Thigh</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Lateral_upper_thigh_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Lateral_upper_thigh_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Lateral_upper_thigh_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Lateral_upper_thigh_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Lateral_upper_thigh_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Lateral_upper_thigh_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Lateral_upper_thigh_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Lateral_upper_thigh_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Rest of Leg and feet</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_leg_and_feet_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_leg_and_feet_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_leg_and_feet_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_leg_and_feet_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_leg_and_feet_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_leg_and_feet_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Rest_of_leg_and_feet_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Rest_of_leg_and_feet_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Arm</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Arm_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Arm_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Arm_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Arm_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Arm_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Mechanic's Hand</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Mechanic_hand_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Mechanic_hand_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Mechanic_hand_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Mechanic_hand_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Mechanic_hand_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Mechanic_hand_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Mechanic_hand_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Mechanic_hand_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Dorsums of hands(Not Over Joints)</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Dorums_of_hands_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Dorums_of_hands_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Dorums_of_hands_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Dorums_of_hands_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Dorums_of_hands_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Dorums_of_hands_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Dorums_of_hands_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Dorums_of_hands_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                     <td><strong>Gottron's - Not on Hands</strong></td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Gottrons_not_on_hand_1]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Gottrons_not_on_hand_1'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Gottrons_not_on_hand_1]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Gottrons_not_on_hand_1'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container text-center">
                            <label style="display: inline-block; margin-right: 10px;">
                                <input type="radio" name="scores[cdasi_damange_Gottrons_not_on_hand_2]" value="0"
                                    <?php echo e(($savedScores['cdasi_damange_Gottrons_not_on_hand_2'] ?? '') == 0 ? 'checked' : ''); ?>>
                                <div>0</div>
                            </label>
                            <label style="display: inline-block;">
                                <input type="radio" name="scores[cdasi_damange_Gottrons_not_on_hand_2]" value="1"
                                    <?php echo e(($savedScores['cdasi_damange_Gottrons_not_on_hand_2'] ?? '') == 1 ? 'checked' : ''); ?>>
                                <div>1</div>
                            </label>
                        </div>
                    </td>
                </tr>
            </tbody>


        </table>

        <br>
        <!-- <button type="button" class="btn btn-success save-btn" data-form-id="form4cdasidamange">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span> -->
    </div>
</form><?php /**PATH /home/yxq9qmneoal1/public_html/novartistraining.gurukoolhub.com/resources/views/doctors/forms/form4CDASIDamange.blade.php ENDPATH**/ ?>