

<?php $__env->startSection('content'); ?>  
<br><br><br>
<div class="container">
    <h2>Uploaded Documents</h2>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table">
        <thead>
            <tr>
                <th>Title</th>
                <th>Date</th>
                <th>Time</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $document): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    <td><?php echo e($document->title); ?></td>
                    <td><?php echo e($document->created_at->format('Y-m-d')); ?></td>
                    <td><?php echo e($document->created_at->format('H:i:s')); ?></td>
                    <td>
                        <a href="<?php echo e(route('documents.assignForm', ['document' => $document->id])); ?>" class="btn btn-warning btn-sm">
                            Assign
                        </a>

                        <!-- Delete Button with Confirmation -->
                        <form action="<?php echo e(route('documents.destroy', $document->id)); ?>" method="POST" style="display:inline;" onsubmit="return confirmDelete();">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <button type="submit" class="btn btn-danger btn-sm">Delete</button>
                        </form>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<!-- Delete Confirmation Script -->
<script>
    function confirmDelete() {
        return confirm("⚠️ Are you sure you want to delete this document? This action cannot be undone.");
    }
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/admin/list-documents.blade.php ENDPATH**/ ?>