

<?php $__env->startSection('content'); ?> 
<br><br><br>

<div class="container">
    <!-- ✅ Success Message -->
    <?php if(session('success')): ?>
        <div class="alert alert-success alert-dismissible fade in text-center">
            <button type="button" class="close" data-dismiss="alert">&times;</button>
            <strong><i class="glyphicon glyphicon-ok-circle"></i> Success! </strong> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="panel panel-primary shadow-box">
        <div class="panel-heading">
            <h3 class="panel-title"><i class="glyphicon glyphicon-tasks"></i> Assign Document</h3>
        </div>
        <div class="panel-body">
            <h4><i class="glyphicon glyphicon-file"></i> <strong>Document Title:</strong> <?php echo e($document->title); ?></h4>
            <hr>

            <!-- ✅ Assign Users Form -->
            <form action="<?php echo e(route('documents.assign', $document->id)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <div class="form-group">
                    <label><i class="glyphicon glyphicon-user"></i> Select Users:</label>
                    <select name="users[]" id="userSelect" class="form-control select2" multiple>
                        <option value="">Search...</option> <!-- Placeholder Option -->
                        <?php $__currentLoopData = $users->where('role', '!=', 'admin')->sortByDesc('created_at'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($user->id); ?>">
                            <?php echo e($user->username); ?> - <?php echo e($user->email); ?> (Registered: <?php echo e($user->created_at->timezone('America/Los_Angeles')->format('d M Y, h:i A')); ?>)
                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <button type="submit" class="btn btn-success btn-block"><i class="glyphicon glyphicon-check"></i> Assign</button>
            </form>
        </div>
    </div>

    <!-- ✅ Assigned Users Section -->
    <div class="panel panel-info shadow-box">
        <div class="panel-heading">
            <h3 class="panel-title"><i class="glyphicon glyphicon-list-alt"></i> Assigned Users</h3>
        </div>
        <div class="panel-body">
            <?php if($document->users->count() > 0): ?>
                <table class="table table-bordered custom-table">
                    <thead>
                        <tr class="table-header">
                            <th>#</th>
                            <th>Username</th>
                            <th>Email</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $document->users; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $user): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php if($user->role !== 'admin'): ?>  <!-- ✅ Ensure Admin is Not Listed -->
                            <tr>
                                <td><?php echo e($key + 1); ?></td>
                                <td><?php echo e($user->username); ?></td>
                                <td><?php echo e($user->email); ?></td>
                                <td class="text-center">
                                    <button class="btn btn-danger btn-sm unassign-btn" 
                                            data-user-id="<?php echo e($user->id); ?>" 
                                            data-document-id="<?php echo e($document->id); ?>">
                                        ❌ Unassign
                                    </button>
                                </td> 
                            </tr>
                            <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                </table>
            <?php else: ?>
                <p class="text-center text-muted"><i class="glyphicon glyphicon-info-sign"></i> No users assigned to this document.</p>
            <?php endif; ?>
        </div>
    </div>
</div>

<!-- ✅ Unassign Confirmation Modal -->
<div class="modal fade" id="unassignModal" tabindex="-1">
    <div class="modal-dialog modal-sm">
        <div class="modal-content">
            <div class="modal-header bg-danger">
                <button type="button" class="close" data-dismiss="modal">&times;</button>
                <h4 class="modal-title"><i class="glyphicon glyphicon-exclamation-sign"></i> Confirm Unassign</h4>
            </div>
            <div class="modal-body text-center">
                Are you sure you want to unassign this user?
            </div>
            <div class="modal-footer">
                <form id="unassignForm" method="POST">
                    <?php echo csrf_field(); ?>
                    <button type="submit" class="btn btn-danger">Unassign</button>
                    <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                </form>
            </div>
        </div>
    </div>
</div>

<!-- ✅ JavaScript for Select2 & Unassign Confirmation -->
<script>
$(document).ready(function() {
    $('#userSelect').select2({
        placeholder: "Search and select users...",
        allowClear: true,
        width: '100%',
        dropdownCssClass: 'big-dropdown', // Enhances dropdown UI
        theme: "classic" // Can be "default" or "bootstrap" based on styling
    });

    $('.unassign-btn').click(function() {
        var userId = $(this).data('user-id');
        var documentId = $(this).data('document-id');

        // Update form action dynamically
        $('#unassignForm').attr('action', '/admin/documents/unassign/' + documentId + '/' + userId);
        $('#unassignModal').modal('show');
    });
});
</script>

<!-- ✅ Custom Styles for a Premium Look -->
<style>
/* ✅ Custom Select2 Styling */
.select2-container .select2-selection--multiple {
    min-height: 45px;
    border-radius: 6px;
    border: 1px solid #007bff;
}

/* ✅ Larger Dropdown Items */
.big-dropdown .select2-results__option {
    font-size: 16px;
    padding: 8px;
}

/* ✅ Styled Selected Options */
.select2-container--default .select2-selection--multiple .select2-selection__choice {
    background-color: #007bff;
    color: white;
    border-radius: 4px;
    padding: 5px;
}

/* ✅ Box Shadow for Panels */
.shadow-box {
    box-shadow: 0px 4px 15px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
}

/* ✅ Table Styling */
.custom-table {
    border: 1px solid #ddd;
    background: #f9f9f9;
}
.custom-table thead {
    background: linear-gradient(to right, #007bff, #6610f2);
    color: white;
}
</style>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/admin/assign-document.blade.php ENDPATH**/ ?>