<?php
use App\Models\FormDraft;

$formData12 = FormDraft::where('user_id', auth()->id())
    ->where('form_id', 'form12pgda')
    ->where('case_id', $case_no)
    ->first();

$savedValue12 = $formData12 ? json_decode($formData12->form_data, true)['scores']['scale2'] ?? null : null;
$initialValue12 = $savedValue12 !== null ? $savedValue12 : 0;
$isValueSet12 = $savedValue12 !== null ? 'true' : 'false';
?>

<form id="form12pgda" class="scoring-form" data-form-id="form12pgda">
<div class="table-container1">
    <section>
        <h3>Case Presentation: Follow-up
            <hr>Physician Global Disease Activity
        </h3>

        <h5>Please rate patient’s global (overall) disease activity</h5><br>
        <span style="text-align:justify; font-size:14px">
            Disease Activity is defined as potentially reversible pathology or physiology resulting from the myositis...
        </span><br><br>

        <div class="slider-section text-center">
            <div class="text-center" style="margin-top: 10px;">
                Selected Value: <strong id="sliderValue2"><?php echo e($savedValue12 !== null ? $savedValue12 : '--'); ?></strong>
                <input type="hidden" id="hiddenSliderValue2" name="input_types[scale2]" value="<?php echo e($savedValue12); ?>">
            </div>

            <input type="range" class="form-control" id="scaleSlider2" name="scores[scale2]"
                min="0" max="10" value="<?php echo e($initialValue12); ?>" data-user-selected="<?php echo e($isValueSet12); ?>"
                oninput="
                    document.getElementById('sliderValue2').innerText = this.value;
                    document.getElementById('hiddenSliderValue2').value = this.value;
                    this.dataset.userSelected = 'true';
                    document.getElementById('sliderError2').style.display = 'none';
                    this.classList.remove('is-invalid');
                "
                style="width: 100%; accent-color: #007bff;">

            <div class="row" style="margin-bottom: 10px;">
                <div class="col-xs-4 text-left">No Evidence of Disease Activity</div>
                <div class="col-xs-4 text-center">Moderate Disease Activity</div>
                <div class="col-xs-4 text-right">Extremely Active or Severe Disease Activity</div>
            </div>

            <div id="sliderError2" class="text-danger" style="display: none; font-weight: bold;">
                Please select a value before submitting.
            </div>
        </div>
    </section>
</div>
</form>
<?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form12PGDA.blade.php ENDPATH**/ ?>