<?php
use App\Models\FormDraft;

$formData = FormDraft::where('user_id', auth()->id())
->where('form_id', 'form1mdaat')
->where('case_id', $case_no)
->first();

$savedScores = [];

if ($formData) {
$decoded = json_decode($formData->form_data, true);
$savedScores = $decoded ?? [];
}
?>

<form id="form1mdaat" class="scoring-form" data-form-id="form1mdaat">

    <div class="table-container">
        <h3>Case  Presentation: Initial
            <br>
            <hr>
            Myositis Disease Activity Assessment Tool (MDAAT)
        </h3>
        <h5 style="font-size:15px;">
            Provide answers with the most appropriate responses based on the case review. Answer all
            questions.
        </h5>
        
        <table class="table table-striped table-bordered mediaTable table-1">
            <thead>
                <tr>
                    <th class="optional fixed-id"><strong>S/N</strong></th>
                    <th class="essential persist"><strong>Disease Activity</strong></th>
                    <th class="optional" style="width: 150px;"><strong>Overall Organ Disease Activity (0-10 cm) VAS</strong></th>
                    <th class="optional" style="width: 200px;"><strong>Clinical Features (0,1,2,3,4, NA: Not Assessed)</strong></th>
                </tr>
            </thead>
            <tbody>
                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Constitutional Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="<?php echo e($savedScores['scores']['disease_activity_1'] ?? ''); ?>"
                                name="scores[disease_activity_1]" oninput="this.nextElementSibling.value = this.value">

                            <input type="text" class="slider-value form-control"
                                value="<?php echo e($savedScores['scores']['disease_activity_1'] ?? ''); ?>"
                                name="input_types[disease_activity_1]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">1</td>
                    <td><strong>Pyrexia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1]" value="0"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_1']) && $savedScores['scores']['clinical_features_1_1'] == '0' ? 'checked' : ''); ?>>
                                0
                            </label>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1]" value="1"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_1']) && $savedScores['scores']['clinical_features_1_1'] == '1' ? 'checked' : ''); ?>>
                                1
                            </label>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1]" value="2"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_1']) && $savedScores['scores']['clinical_features_1_1'] == '2' ? 'checked' : ''); ?>>
                                2
                            </label>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1]" value="3"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_1']) && $savedScores['scores']['clinical_features_1_1'] == '3' ? 'checked' : ''); ?>>
                                3
                            </label>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1]" value="4"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_1']) && $savedScores['scores']['clinical_features_1_1'] == '4' ? 'checked' : ''); ?>>
                                4
                            </label>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_1]" value="NA"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_1']) && $savedScores['scores']['clinical_features_1_1'] == 'NA' ? 'checked' : ''); ?>>
                                NA
                            </label>
                            <input type="hidden" name="input_types[clinical_features_1_1]" value="radio">
                        </div>
                    </td>

                </tr>
                <tr class="section-1-sub">
                    <td class="fixed-id">2</td>
                    <td><strong>Weight Loss</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_2']) && $savedScores['scores']['clinical_features_1_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_1_2]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">3</td>
                    <td><strong>Fatigue</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_1_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_1_3']) && $savedScores['scores']['clinical_features_1_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_1_3]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Cutaneous Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider"
                                value="<?php echo e($savedScores['scores']['disease_activity_2'] ?? ''); ?>"
                                name="scores[disease_activity_2]" oninput="this.nextElementSibling.value = this.value">

                            <input type="text" class="slider-value form-control"
                                value="<?php echo e($savedScores['scores']['disease_activity_2'] ?? ''); ?>"
                                name="input_types[disease_activity_2]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">4</td>
                    <td><strong>Cutaneous Ulceration</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_2_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_2_1']) && $savedScores['scores']['clinical_features_2_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_2_1]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">5</td>
                    <td><strong>Erythroderma</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_2_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_2_2']) && $savedScores['scores']['clinical_features_2_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_2_2]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">6</td>
                    <td><strong>Panniculitis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_2_3]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_2_3']) && $savedScores['scores']['clinical_features_2_3'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_2_3]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">7</td>
                    <td><strong>Erythematous Rash</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading">
                       <strong> A. with secondary changes (e.g. accompanied by erosions, vesiculobullous change or necrosis)</strong>
                    </td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[erythematous_rash_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['erythematous_rash_a']) && $savedScores['scores']['erythematous_rash_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[erythematous_rash_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"> <strong>B. without secondary changes</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[erythematous_rash_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['erythematous_rash_b']) && $savedScores['scores']['erythematous_rash_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[erythematous_rash_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">8</td>
                    <td><strong>Heliotrope rash</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_2_5]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_2_5']) && $savedScores['scores']['clinical_features_2_5'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_2_5]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">9</td>
                    <td><strong>Gottron's papules/sign</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_2_6]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_2_6']) && $savedScores['scores']['clinical_features_2_6'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_2_6]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">10</td>
                    <td><strong>Periungual capillary changes</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_2_7]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_2_7']) && $savedScores['scores']['clinical_features_2_7'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_2_7]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">11</td>
                    <td><strong>Alopecia</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Diffuse hair Loss</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[alopecia_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['alopecia_a']) && $savedScores['scores']['alopecia_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[alopecia_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Focal, Patchy with Erythema</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[alopecia_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['alopecia_b']) && $savedScores['scores']['alopecia_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[alopecia_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">12</td>
                    <td><strong>Mechanics Hand</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[mechanics_hand]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['mechanics_hand']) && $savedScores['scores']['mechanics_hand'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[mechanics_hand]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Skeletal Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider" name="scores[disease_activity_3]"
                                value="<?php echo e($savedScores['scores']['disease_activity_3'] ?? ''); ?>"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control" name="input_types[disease_activity_3]"
                                value="<?php echo e($savedScores['scores']['disease_activity_3'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">13</td>
                    <td><strong><strong>Arthritis</strong></strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe active polyarthritis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[polyarthritis_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['polyarthritis_a']) && $savedScores['scores']['polyarthritis_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[polyarthritis_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Moderately active arthritis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[moderately_active_arthritis_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['moderately_active_arthritis_b']) && $savedScores['scores']['moderately_active_arthritis_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[moderately_active_arthritis_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Mild arthritis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[milarth_c]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['milarth_c']) && $savedScores['scores']['milarth_c'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[milarth_c]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">14</td>
                    <td><strong>Arthralgia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[arthralgia]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['arthralgia']) && $savedScores['scores']['arthralgia'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[arthralgia]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>GI Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider" name="scores[disease_activity_4]"
                                value="<?php echo e($savedScores['scores']['disease_activity_4'] ?? ''); ?>"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control" name="input_types[disease_activity_4]"
                                value="<?php echo e($savedScores['scores']['disease_activity_4'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">15</td>
                    <td><strong>Dysphagia</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Moderate/severe dysphagia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dysphagia_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['dysphagia_a']) && $savedScores['scores']['dysphagia_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[dysphagia_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Mild dysphagia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dysphagia_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['dysphagia_b']) && $savedScores['scores']['dysphagia_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[dysphagia_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">16</td>
                    <td><strong>Abdominal Pain</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[abdominal_pain_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['abdominal_pain_a']) && $savedScores['scores']['abdominal_pain_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[abdominal_pain_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Moderate</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[abdominal_pain_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['abdominal_pain_b']) && $savedScores['scores']['abdominal_pain_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[abdominal_pain_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Mild</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[abdominal_pain_c]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['abdominal_pain_c']) && $savedScores['scores']['abdominal_pain_c'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[abdominal_pain_c]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Pulmonary Disease Activity</strong> </td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10" class="slider" name="scores[disease_activity_5]"
                                value="<?php echo e($savedScores['scores']['disease_activity_5'] ?? ''); ?>"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control" name="input_types[disease_activity_5]"
                                value="<?php echo e($savedScores['scores']['disease_activity_5'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">17</td>
                    <td><strong>Resp. Muscle weakness without ILD</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Dyspnea at rest</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[resp_muscle_weakness_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['resp_muscle_weakness_a']) && $savedScores['scores']['resp_muscle_weakness_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[resp_muscle_weakness_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Dyspnea on exertion</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[resp_muscle_weakness_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['resp_muscle_weakness_b']) && $savedScores['scores']['resp_muscle_weakness_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[resp_muscle_weakness_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id"><strong>18</strong></td>
                    <td><strong>Active Reversible ILD</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Dyspnea or cough due to ILD</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[active_ild_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['active_ild_a']) && $savedScores['scores']['active_ild_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[active_ild_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Parenchymal abnormalities on chest x-ray or high-resolution CT scan
                        (HRCT) and/or ground glass shadowing on HRCT</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[active_ild_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['active_ild_b']) && $savedScores['scores']['active_ild_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[active_ild_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Pulmonary Function Tests: ≥ 10% change in FVC OR ≥ 15% change in DLCO</strong>
                    </td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[active_ild_c]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['active_ild_c']) && $savedScores['scores']['active_ild_c'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[active_ild_c]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">19</td>
                    <td><strong>Dysphonia</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Moderate to severe</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dysphonia_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['dysphonia_a']) && $savedScores['scores']['dysphonia_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[dysphonia_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Mild</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[dysphonia_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['dysphonia_b']) && $savedScores['scores']['dysphonia_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[dysphonia_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Cardiovascular Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10"
                                value="<?php echo e($savedScores['scores']['cardiovascular_disease_activity'] ?? ''); ?>"
                                class="slider" name="scores[cardiovascular_disease_activity]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                value="<?php echo e($savedScores['scores']['cardiovascular_disease_activity'] ?? ''); ?>"
                                name="input_types[cardiovascular_disease_activity]" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">20</td>
                    <td><strong>Pericarditis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_6_1]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_6_1']) && $savedScores['scores']['clinical_features_6_1'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_6_1]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">21</td>
                    <td><strong>Myocarditis</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[clinical_features_6_2]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['clinical_features_6_2']) && $savedScores['scores']['clinical_features_6_2'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[clinical_features_6_2]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id"><strong>22</strong></td>
                    <td><strong>Arrhythmias</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe arrhythmia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[arrhythmia_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['arrhythmia_a']) && $savedScores['scores']['arrhythmia_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[arrhythmia_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Other arrhythmia, except sinus tachycardia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[arrhythmia_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['arrhythmia_b']) && $savedScores['scores']['arrhythmia_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[arrhythmia_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">23</td>
                    <td><strong>Sinus Tachycardia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[sinus_tachycardia]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['sinus_tachycardia']) && $savedScores['scores']['sinus_tachycardia'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[sinus_tachycardia]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td>
                        <strong>Other Disease Activity</strong><br>
                        <input type="text" class="form-control form-control-sm w-25"
                            name="scores[other_disease_activity_note]"
                            value="<?php echo e($savedScores['scores']['other_disease_activity_note'] ?? ''); ?>"
                            placeholder="Specify_____" />

                        <input type="hidden" name="input_types[other_disease_activity_note]" value="text">
                    </td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10"
                                value="<?php echo e($savedScores['scores']['other_disease_activity_slider'] ?? ''); ?>"
                                class="slider" name="scores[other_disease_activity_slider]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                name="input_types[other_disease_activity_slider]"
                                value="<?php echo e($savedScores['scores']['other_disease_activity_slider'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0', '1', '2', '3', '4', 'NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[other_disease_activity_radio]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['other_disease_activity_radio']) && $savedScores['scores']['other_disease_activity_radio'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[other_disease_activity_radio]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Extra Muscular Global Assessment</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10"
                                value="<?php echo e($savedScores['scores']['extra_muscular_global_assessment'] ?? ''); ?>"
                                class="slider" name="scores[extra_muscular_global_assessment]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                name="input_types[extra_muscular_global_assessment]"
                                value="<?php echo e($savedScores['scores']['extra_muscular_global_assessment'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1">
                    <td class="fixed-id"></td>
                    <td><strong>Muscle Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10"
                                value="<?php echo e($savedScores['scores']['muscle_disease_activity'] ?? ''); ?>" class="slider"
                                name="scores[muscle_disease_activity]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                name="input_types[muscle_disease_activity]"
                                value="<?php echo e($savedScores['scores']['muscle_disease_activity'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">24</td>
                    <td><strong>Myositis</strong></td>
                    <td></td>
                    <td></td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>A. Severe muscle inflammation</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0','1','2','3','4','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[myositis_a]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['myositis_a']) && $savedScores['scores']['myositis_a'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[myositis_a]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>B. Moderate muscle inflammation</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0','1','2','3','4','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[myositis_b]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['myositis_b']) && $savedScores['scores']['myositis_b'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[myositis_b]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td></td>
                    <td class="sub-heading"><strong>C. Mild muscle inflammation</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0','1','2','3','4','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[myositis_c]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['myositis_c']) && $savedScores['scores']['myositis_c'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[myositis_c]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id">25</td>
                    <td><strong>Myalgia</strong></td>
                    <td></td>
                    <td>
                        <div class="radio-container">
                            <?php $__currentLoopData = ['0','1','2','3','4','NA']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $val): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label>
                                <input type="radio" name="scores[myalgia]" value="<?php echo e($val); ?>"
                                    <?php echo e(isset($savedScores['scores']['myalgia']) && $savedScores['scores']['myalgia'] == $val ? 'checked' : ''); ?>>
                                <?php echo e($val); ?>

                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            <input type="hidden" name="input_types[myalgia]" value="radio">
                        </div>
                    </td>
                </tr>

                <tr class="section-1-sub">
                    <td class="fixed-id"></td>
                    <td><strong>Global Disease Activity</strong></td>
                    <td>
                        <div class="slider-container">
                            <input type="range" min="0" max="10"
                                value="<?php echo e($savedScores['scores']['global_disease_activity'] ?? ''); ?>" class="slider"
                                name="scores[global_disease_activity]"
                                oninput="this.nextElementSibling.value = this.value">
                            <input type="text" class="slider-value form-control"
                                name="input_types[global_disease_activity]"
                                value="<?php echo e($savedScores['scores']['global_disease_activity'] ?? ''); ?>" readonly>
                        </div>
                    </td>
                    <td></td>
                </tr>

            </tbody>

        </table>
       <!--  <button type="button" class="btn btn-success save-btn" data-form-id="form1mdaat">📝 Save Draft</button>
        <span class="save-success-msg text-success" style="margin-left: 15px; font-weight: bold; display: none;">
            ✔ Draft saved successfully
        </span> -->
    </div>


</form>

<br>
<hr>
 <?php /**PATH E:\Case Management Software\21Aprilupdated\resources\views/doctors/forms/form1Mdaat.blade.php ENDPATH**/ ?>